/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.firebase.annotations.PublicApi;

@PublicApi
public final class FirebaseFirestoreSettings {
    @PublicApi
    public static final long CACHE_SIZE_UNLIMITED = -1L;
    private static final long MINIMUM_CACHE_BYTES = 0x100000L;
    private static final long DEFAULT_CACHE_SIZE_BYTES = -1L;
    private static final String DEFAULT_HOST = "firestore.googleapis.com";
    private static final boolean DEFAULT_TIMESTAMPS_IN_SNAPSHOTS_ENABLED = true;
    private final String host;
    private final boolean sslEnabled;
    private final boolean persistenceEnabled;
    private final boolean timestampsInSnapshotsEnabled;
    private final long cacheSizeBytes;

    private FirebaseFirestoreSettings(Builder builder) {
        this.host = builder.host;
        this.sslEnabled = builder.sslEnabled;
        this.persistenceEnabled = builder.persistenceEnabled;
        this.timestampsInSnapshotsEnabled = builder.timestampsInSnapshotsEnabled;
        this.cacheSizeBytes = builder.cacheSizeBytes;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FirebaseFirestoreSettings that = (FirebaseFirestoreSettings)o;
        return this.host.equals(that.host) && this.sslEnabled == that.sslEnabled && this.persistenceEnabled == that.persistenceEnabled && this.timestampsInSnapshotsEnabled == that.timestampsInSnapshotsEnabled && this.cacheSizeBytes == that.cacheSizeBytes;
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + (this.sslEnabled ? 1 : 0);
        result = 31 * result + (this.persistenceEnabled ? 1 : 0);
        result = 31 * result + (this.timestampsInSnapshotsEnabled ? 1 : 0);
        result = 31 * result + (int)this.cacheSizeBytes;
        return result;
    }

    @NonNull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("host", (Object)this.host).add("sslEnabled", this.sslEnabled).add("persistenceEnabled", this.persistenceEnabled).add("timestampsInSnapshotsEnabled", this.timestampsInSnapshotsEnabled).toString();
    }

    @NonNull
    @PublicApi
    public String getHost() {
        return this.host;
    }

    @PublicApi
    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    @PublicApi
    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    @PublicApi
    public boolean areTimestampsInSnapshotsEnabled() {
        return this.timestampsInSnapshotsEnabled;
    }

    @PublicApi
    public long getCacheSizeBytes() {
        return this.cacheSizeBytes;
    }

    @PublicApi
    public static final class Builder {
        private String host;
        private boolean sslEnabled;
        private boolean persistenceEnabled;
        private boolean timestampsInSnapshotsEnabled;
        private long cacheSizeBytes;

        @PublicApi
        public Builder() {
            this.host = FirebaseFirestoreSettings.DEFAULT_HOST;
            this.sslEnabled = true;
            this.persistenceEnabled = true;
            this.timestampsInSnapshotsEnabled = true;
            this.cacheSizeBytes = -1L;
        }

        @PublicApi
        public Builder(@NonNull FirebaseFirestoreSettings settings) {
            Preconditions.checkNotNull((Object)settings, (Object)"Provided settings must not be null.");
            this.host = settings.host;
            this.sslEnabled = settings.sslEnabled;
            this.persistenceEnabled = settings.persistenceEnabled;
            this.timestampsInSnapshotsEnabled = settings.timestampsInSnapshotsEnabled;
        }

        @NonNull
        @PublicApi
        public Builder setHost(@NonNull String host) {
            this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"Provided host must not be null.");
            return this;
        }

        @NonNull
        @PublicApi
        public Builder setSslEnabled(boolean value) {
            this.sslEnabled = value;
            return this;
        }

        @NonNull
        @PublicApi
        public Builder setPersistenceEnabled(boolean value) {
            this.persistenceEnabled = value;
            return this;
        }

        @Deprecated
        @NonNull
        @PublicApi
        public Builder setTimestampsInSnapshotsEnabled(boolean value) {
            this.timestampsInSnapshotsEnabled = value;
            return this;
        }

        @NonNull
        @PublicApi
        public Builder setCacheSizeBytes(long value) {
            if (value != -1L && value < 0x100000L) {
                throw new IllegalArgumentException("Cache size must be set to at least 1048576 bytes");
            }
            this.cacheSizeBytes = value;
            return this;
        }

        @NonNull
        @PublicApi
        public FirebaseFirestoreSettings build() {
            if (!this.sslEnabled && this.host.equals(FirebaseFirestoreSettings.DEFAULT_HOST)) {
                throw new IllegalStateException("You can't set the 'sslEnabled' setting unless you also set a non-default 'host'.");
            }
            return new FirebaseFirestoreSettings(this);
        }
    }
}

