/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Preconditions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.Query$$Lambda$1;
import com.google.firebase.firestore.Query$$Lambda$2;
import com.google.firebase.firestore.Query$$Lambda$3;
import com.google.firebase.firestore.QuerySnapshot;
import com.google.firebase.firestore.Source;
import com.google.firebase.firestore.core.Bound;
import com.google.firebase.firestore.core.EventManager;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.core.QueryListener;
import com.google.firebase.firestore.core.RelationFilter;
import com.google.firebase.firestore.core.ViewSnapshot;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.model.value.ReferenceValue;
import com.google.firebase.firestore.model.value.ServerTimestampValue;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.ExecutorEventListener;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.ListenerRegistrationImpl;
import com.google.firebase.firestore.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@PublicApi
public class Query {
    final com.google.firebase.firestore.core.Query query;
    final FirebaseFirestore firestore;

    Query(com.google.firebase.firestore.core.Query query, FirebaseFirestore firestore) {
        this.query = (com.google.firebase.firestore.core.Query)Preconditions.checkNotNull((Object)query);
        this.firestore = (FirebaseFirestore)Preconditions.checkNotNull((Object)firestore);
    }

    @NonNull
    @PublicApi
    public FirebaseFirestore getFirestore() {
        return this.firestore;
    }

    private void validateOrderByFieldMatchesInequality(com.google.firebase.firestore.model.FieldPath orderBy, com.google.firebase.firestore.model.FieldPath inequality) {
        if (!orderBy.equals(inequality)) {
            String inequalityString = inequality.canonicalString();
            throw new IllegalArgumentException(String.format("Invalid query. You have an inequality where filter (whereLessThan(), whereGreaterThan(), etc.) on field '%s' and so you must also have '%s' as your first orderBy() field, but your first orderBy() is currently on field '%s' instead.", inequalityString, inequalityString, orderBy.canonicalString()));
        }
    }

    private void validateNewFilter(Filter filter) {
        if (filter instanceof RelationFilter) {
            RelationFilter relationFilter = (RelationFilter)filter;
            if (relationFilter.isInequality()) {
                com.google.firebase.firestore.model.FieldPath existingInequality = this.query.inequalityField();
                com.google.firebase.firestore.model.FieldPath newInequality = filter.getField();
                if (existingInequality != null && !existingInequality.equals(newInequality)) {
                    throw new IllegalArgumentException(String.format("All where filters other than whereEqualTo() must be on the same field. But you have filters on '%s' and '%s'", existingInequality.canonicalString(), newInequality.canonicalString()));
                }
                com.google.firebase.firestore.model.FieldPath firstOrderByField = this.query.getFirstOrderByField();
                if (firstOrderByField != null) {
                    this.validateOrderByFieldMatchesInequality(firstOrderByField, newInequality);
                }
            } else if (relationFilter.getOperator() == Filter.Operator.ARRAY_CONTAINS && this.query.hasArrayContainsFilter()) {
                throw new IllegalArgumentException("Invalid Query. Queries only support having a single array-contains filter.");
            }
        }
    }

    @NonNull
    @PublicApi
    public Query whereEqualTo(@NonNull String field, @Nullable Object value) {
        return this.whereHelper(FieldPath.fromDotSeparatedPath(field), Filter.Operator.EQUAL, value);
    }

    @NonNull
    @PublicApi
    public Query whereEqualTo(@NonNull FieldPath fieldPath, @Nullable Object value) {
        return this.whereHelper(fieldPath, Filter.Operator.EQUAL, value);
    }

    @NonNull
    @PublicApi
    public Query whereLessThan(@NonNull String field, @NonNull Object value) {
        return this.whereHelper(FieldPath.fromDotSeparatedPath(field), Filter.Operator.LESS_THAN, value);
    }

    @NonNull
    @PublicApi
    public Query whereLessThan(@NonNull FieldPath fieldPath, @NonNull Object value) {
        return this.whereHelper(fieldPath, Filter.Operator.LESS_THAN, value);
    }

    @NonNull
    @PublicApi
    public Query whereLessThanOrEqualTo(@NonNull String field, @NonNull Object value) {
        return this.whereHelper(FieldPath.fromDotSeparatedPath(field), Filter.Operator.LESS_THAN_OR_EQUAL, value);
    }

    @NonNull
    @PublicApi
    public Query whereLessThanOrEqualTo(@NonNull FieldPath fieldPath, @NonNull Object value) {
        return this.whereHelper(fieldPath, Filter.Operator.LESS_THAN_OR_EQUAL, value);
    }

    @NonNull
    @PublicApi
    public Query whereGreaterThan(@NonNull String field, @NonNull Object value) {
        return this.whereHelper(FieldPath.fromDotSeparatedPath(field), Filter.Operator.GREATER_THAN, value);
    }

    @NonNull
    @PublicApi
    public Query whereGreaterThan(@NonNull FieldPath fieldPath, @NonNull Object value) {
        return this.whereHelper(fieldPath, Filter.Operator.GREATER_THAN, value);
    }

    @NonNull
    @PublicApi
    public Query whereGreaterThanOrEqualTo(@NonNull String field, @NonNull Object value) {
        return this.whereHelper(FieldPath.fromDotSeparatedPath(field), Filter.Operator.GREATER_THAN_OR_EQUAL, value);
    }

    @NonNull
    @PublicApi
    public Query whereGreaterThanOrEqualTo(@NonNull FieldPath fieldPath, @NonNull Object value) {
        return this.whereHelper(fieldPath, Filter.Operator.GREATER_THAN_OR_EQUAL, value);
    }

    @NonNull
    @PublicApi
    public Query whereArrayContains(@NonNull String field, @NonNull Object value) {
        return this.whereHelper(FieldPath.fromDotSeparatedPath(field), Filter.Operator.ARRAY_CONTAINS, value);
    }

    @NonNull
    @PublicApi
    public Query whereArrayContains(@NonNull FieldPath fieldPath, @NonNull Object value) {
        return this.whereHelper(fieldPath, Filter.Operator.ARRAY_CONTAINS, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Query whereHelper(@NonNull FieldPath fieldPath, Filter.Operator op, Object value) {
        FieldValue fieldValue;
        Preconditions.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        Preconditions.checkNotNull((Object)((Object)op), (Object)"Provided op must not be null.");
        com.google.firebase.firestore.model.FieldPath internalPath = fieldPath.getInternalPath();
        if (internalPath.isKeyField()) {
            if (op == Filter.Operator.ARRAY_CONTAINS) {
                throw new IllegalArgumentException("Invalid query. You can't perform array-contains queries on FieldPath.documentId() since document IDs are not arrays.");
            }
            if (value instanceof String) {
                String documentKey = (String)value;
                if (documentKey.contains("/")) {
                    throw new IllegalArgumentException("Invalid query. When querying with FieldPath.documentId() you must provide a valid document ID, but '" + documentKey + "' contains a '/' character.");
                }
                if (documentKey.isEmpty()) {
                    throw new IllegalArgumentException("Invalid query. When querying with FieldPath.documentId() you must provide a valid document ID, but it was an empty string.");
                }
                ResourcePath path = (ResourcePath)((Object)this.query.getPath().append(documentKey));
                Assert.hardAssert(path.length() % 2 == 0, "Path should be a document key", new Object[0]);
                fieldValue = ReferenceValue.valueOf(this.getFirestore().getDatabaseId(), DocumentKey.fromPath(path));
            } else {
                if (!(value instanceof DocumentReference)) throw new IllegalArgumentException("Invalid query. When querying with FieldPath.documentId() you must provide a valid String or DocumentReference, but it was of type: " + Util.typeName(value));
                DocumentReference ref = (DocumentReference)value;
                fieldValue = ReferenceValue.valueOf(this.getFirestore().getDatabaseId(), ref.getKey());
            }
        } else {
            fieldValue = this.firestore.getDataConverter().parseQueryValue(value);
        }
        Filter filter = Filter.create(fieldPath.getInternalPath(), op, fieldValue);
        this.validateNewFilter(filter);
        return new Query(this.query.filter(filter), this.firestore);
    }

    private void validateOrderByField(com.google.firebase.firestore.model.FieldPath field) {
        com.google.firebase.firestore.model.FieldPath inequalityField = this.query.inequalityField();
        if (this.query.getFirstOrderByField() == null && inequalityField != null) {
            this.validateOrderByFieldMatchesInequality(field, inequalityField);
        }
    }

    @NonNull
    @PublicApi
    public Query orderBy(@NonNull String field) {
        return this.orderBy(FieldPath.fromDotSeparatedPath(field), Direction.ASCENDING);
    }

    @NonNull
    @PublicApi
    public Query orderBy(@NonNull FieldPath fieldPath) {
        Preconditions.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.orderBy(fieldPath.getInternalPath(), Direction.ASCENDING);
    }

    @NonNull
    @PublicApi
    public Query orderBy(@NonNull String field, @NonNull Direction direction) {
        return this.orderBy(FieldPath.fromDotSeparatedPath(field), direction);
    }

    @NonNull
    @PublicApi
    public Query orderBy(@NonNull FieldPath fieldPath, @NonNull Direction direction) {
        Preconditions.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.orderBy(fieldPath.getInternalPath(), direction);
    }

    private Query orderBy(@NonNull com.google.firebase.firestore.model.FieldPath fieldPath, @NonNull Direction direction) {
        Preconditions.checkNotNull((Object)((Object)direction), (Object)"Provided direction must not be null.");
        if (this.query.getStartAt() != null) {
            throw new IllegalArgumentException("Invalid query. You must not call Query.startAt() or Query.startAfter() before calling Query.orderBy().");
        }
        if (this.query.getEndAt() != null) {
            throw new IllegalArgumentException("Invalid query. You must not call Query.endAt() or Query.endAfter() before calling Query.orderBy().");
        }
        this.validateOrderByField(fieldPath);
        OrderBy.Direction dir = direction == Direction.ASCENDING ? OrderBy.Direction.ASCENDING : OrderBy.Direction.DESCENDING;
        return new Query(this.query.orderBy(OrderBy.getInstance(dir, fieldPath)), this.firestore);
    }

    @NonNull
    @PublicApi
    public Query limit(long limit) {
        if (limit <= 0L) {
            throw new IllegalArgumentException("Invalid Query. Query limit (" + limit + ") is invalid. Limit must be positive.");
        }
        return new Query(this.query.limit(limit), this.firestore);
    }

    @NonNull
    @PublicApi
    public Query startAt(@NonNull DocumentSnapshot snapshot) {
        Bound bound = this.boundFromDocumentSnapshot("startAt", snapshot, true);
        return new Query(this.query.startAt(bound), this.firestore);
    }

    @NonNull
    @PublicApi
    public Query startAt(Object ... fieldValues) {
        Bound bound = this.boundFromFields("startAt", fieldValues, true);
        return new Query(this.query.startAt(bound), this.firestore);
    }

    @NonNull
    @PublicApi
    public Query startAfter(@NonNull DocumentSnapshot snapshot) {
        Bound bound = this.boundFromDocumentSnapshot("startAfter", snapshot, false);
        return new Query(this.query.startAt(bound), this.firestore);
    }

    @NonNull
    @PublicApi
    public Query startAfter(Object ... fieldValues) {
        Bound bound = this.boundFromFields("startAfter", fieldValues, false);
        return new Query(this.query.startAt(bound), this.firestore);
    }

    @NonNull
    @PublicApi
    public Query endBefore(@NonNull DocumentSnapshot snapshot) {
        Bound bound = this.boundFromDocumentSnapshot("endBefore", snapshot, true);
        return new Query(this.query.endAt(bound), this.firestore);
    }

    @NonNull
    @PublicApi
    public Query endBefore(Object ... fieldValues) {
        Bound bound = this.boundFromFields("endBefore", fieldValues, true);
        return new Query(this.query.endAt(bound), this.firestore);
    }

    @NonNull
    @PublicApi
    public Query endAt(@NonNull DocumentSnapshot snapshot) {
        Bound bound = this.boundFromDocumentSnapshot("endAt", snapshot, false);
        return new Query(this.query.endAt(bound), this.firestore);
    }

    @NonNull
    @PublicApi
    public Query endAt(Object ... fieldValues) {
        Bound bound = this.boundFromFields("endAt", fieldValues, false);
        return new Query(this.query.endAt(bound), this.firestore);
    }

    private Bound boundFromDocumentSnapshot(String methodName, DocumentSnapshot snapshot, boolean before) {
        Preconditions.checkNotNull((Object)snapshot, (Object)"Provided snapshot must not be null.");
        if (!snapshot.exists()) {
            throw new IllegalArgumentException("Can't use a DocumentSnapshot for a document that doesn't exist for " + methodName + "().");
        }
        Document document = snapshot.getDocument();
        ArrayList<FieldValue> components = new ArrayList<FieldValue>();
        for (OrderBy orderBy : this.query.getOrderBy()) {
            if (orderBy.getField().equals(com.google.firebase.firestore.model.FieldPath.KEY_PATH)) {
                components.add(ReferenceValue.valueOf(this.firestore.getDatabaseId(), document.getKey()));
                continue;
            }
            FieldValue value = document.getField(orderBy.getField());
            if (value instanceof ServerTimestampValue) {
                throw new IllegalArgumentException("Invalid query. You are trying to start or end a query using a document for which the field '" + orderBy.getField() + "' is an uncommitted server timestamp. (Since the value of this field is unknown, you cannot start/end a query with it.)");
            }
            if (value != null) {
                components.add(value);
                continue;
            }
            throw new IllegalArgumentException("Invalid query. You are trying to start or end a query using a document for which the field '" + orderBy.getField() + "' (used as the orderBy) does not exist.");
        }
        return new Bound(components, before);
    }

    private Bound boundFromFields(String methodName, Object[] values, boolean before) {
        List<OrderBy> explicitOrderBy = this.query.getExplicitOrderBy();
        if (values.length > explicitOrderBy.size()) {
            throw new IllegalArgumentException("Too many arguments provided to " + methodName + "(). The number of arguments must be less than or equal to the number of orderBy() clauses.");
        }
        ArrayList<FieldValue> components = new ArrayList<FieldValue>();
        for (int i = 0; i < values.length; ++i) {
            Object rawValue = values[i];
            OrderBy orderBy = explicitOrderBy.get(i);
            if (orderBy.getField().equals(com.google.firebase.firestore.model.FieldPath.KEY_PATH)) {
                if (!(rawValue instanceof String)) {
                    throw new IllegalArgumentException("Invalid query. Expected a string for document ID in " + methodName + "(), but got " + rawValue + ".");
                }
                String documentId = (String)rawValue;
                if (documentId.contains("/")) {
                    throw new IllegalArgumentException("Invalid query. Document ID '" + documentId + "' contains a slash in " + methodName + "().");
                }
                DocumentKey key = DocumentKey.fromPath((ResourcePath)((Object)this.query.getPath().append(documentId)));
                components.add(ReferenceValue.valueOf(this.firestore.getDatabaseId(), key));
                continue;
            }
            FieldValue wrapped = this.firestore.getDataConverter().parseQueryValue(rawValue);
            components.add(wrapped);
        }
        return new Bound(components, before);
    }

    @NonNull
    @PublicApi
    public Task<QuerySnapshot> get() {
        return this.get(Source.DEFAULT);
    }

    @NonNull
    @PublicApi
    public Task<QuerySnapshot> get(Source source) {
        if (source == Source.CACHE) {
            return this.firestore.getClient().getDocumentsFromLocalCache(this.query).continueWith(Executors.DIRECT_EXECUTOR, Query$$Lambda$1.lambdaFactory$(this));
        }
        return this.getViaSnapshotListener(source);
    }

    private Task<QuerySnapshot> getViaSnapshotListener(Source source) {
        TaskCompletionSource res = new TaskCompletionSource();
        TaskCompletionSource registration = new TaskCompletionSource();
        EventManager.ListenOptions options = new EventManager.ListenOptions();
        options.includeDocumentMetadataChanges = true;
        options.includeQueryMetadataChanges = true;
        options.waitForSyncWhenOnline = true;
        ListenerRegistration listenerRegistration = this.addSnapshotListenerInternal(Executors.DIRECT_EXECUTOR, options, null, Query$$Lambda$2.lambdaFactory$(res, registration, source));
        registration.setResult((Object)listenerRegistration);
        return res.getTask();
    }

    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull EventListener<QuerySnapshot> listener) {
        return this.addSnapshotListener(MetadataChanges.EXCLUDE, listener);
    }

    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull EventListener<QuerySnapshot> listener) {
        return this.addSnapshotListener(executor, MetadataChanges.EXCLUDE, listener);
    }

    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull EventListener<QuerySnapshot> listener) {
        return this.addSnapshotListener(activity, MetadataChanges.EXCLUDE, listener);
    }

    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull MetadataChanges metadataChanges, @NonNull EventListener<QuerySnapshot> listener) {
        return this.addSnapshotListener(Executors.DEFAULT_CALLBACK_EXECUTOR, metadataChanges, listener);
    }

    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull MetadataChanges metadataChanges, @NonNull EventListener<QuerySnapshot> listener) {
        Preconditions.checkNotNull((Object)executor, (Object)"Provided executor must not be null.");
        Preconditions.checkNotNull((Object)((Object)metadataChanges), (Object)"Provided MetadataChanges value must not be null.");
        Preconditions.checkNotNull(listener, (Object)"Provided EventListener must not be null.");
        return this.addSnapshotListenerInternal(executor, Query.internalOptions(metadataChanges), null, listener);
    }

    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull MetadataChanges metadataChanges, @NonNull EventListener<QuerySnapshot> listener) {
        Preconditions.checkNotNull((Object)activity, (Object)"Provided activity must not be null.");
        Preconditions.checkNotNull((Object)((Object)metadataChanges), (Object)"Provided MetadataChanges value must not be null.");
        Preconditions.checkNotNull(listener, (Object)"Provided EventListener must not be null.");
        return this.addSnapshotListenerInternal(Executors.DEFAULT_CALLBACK_EXECUTOR, Query.internalOptions(metadataChanges), activity, listener);
    }

    private ListenerRegistration addSnapshotListenerInternal(Executor executor, EventManager.ListenOptions options, @Nullable Activity activity, EventListener<QuerySnapshot> listener) {
        ExecutorEventListener<ViewSnapshot> wrappedListener = new ExecutorEventListener<ViewSnapshot>(executor, Query$$Lambda$3.lambdaFactory$(this, listener));
        QueryListener queryListener = this.firestore.getClient().listen(this.query, options, wrappedListener);
        return new ListenerRegistrationImpl(this.firestore.getClient(), queryListener, activity, wrappedListener);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query that = (Query)o;
        return this.query.equals(that.query) && this.firestore.equals(that.firestore);
    }

    public int hashCode() {
        int result = this.query.hashCode();
        result = 31 * result + this.firestore.hashCode();
        return result;
    }

    private static EventManager.ListenOptions internalOptions(MetadataChanges metadataChanges) {
        EventManager.ListenOptions internalOptions = new EventManager.ListenOptions();
        internalOptions.includeDocumentMetadataChanges = metadataChanges == MetadataChanges.INCLUDE;
        internalOptions.includeQueryMetadataChanges = metadataChanges == MetadataChanges.INCLUDE;
        internalOptions.waitForSyncWhenOnline = false;
        return internalOptions;
    }

    static /* synthetic */ void lambda$addSnapshotListenerInternal$2(Query this_, EventListener listener, ViewSnapshot snapshot, FirebaseFirestoreException error) {
        if (snapshot != null) {
            QuerySnapshot querySnapshot = new QuerySnapshot(this_, snapshot, this_.firestore);
            listener.onEvent(querySnapshot, null);
        } else {
            Assert.hardAssert(error != null, "Got event without value or error set", new Object[0]);
            listener.onEvent(null, error);
        }
    }

    static /* synthetic */ void lambda$getViaSnapshotListener$1(TaskCompletionSource res, TaskCompletionSource registration, Source source, QuerySnapshot snapshot, FirebaseFirestoreException error) {
        if (error != null) {
            res.setException((Exception)((Object)error));
            return;
        }
        try {
            ListenerRegistration actualRegistration = (ListenerRegistration)Tasks.await((Task)registration.getTask());
            actualRegistration.remove();
            if (snapshot.getMetadata().isFromCache() && source == Source.SERVER) {
                res.setException((Exception)((Object)new FirebaseFirestoreException("Failed to get documents from server. (However, these documents may exist in the local cache. Run again without setting source to SERVER to retrieve the cached documents.)", FirebaseFirestoreException.Code.UNAVAILABLE)));
            } else {
                res.setResult((Object)snapshot);
            }
        }
        catch (ExecutionException e) {
            throw Assert.fail(e, "Failed to register a listener for a query result", new Object[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Assert.fail(e, "Failed to register a listener for a query result", new Object[0]);
        }
    }

    static /* synthetic */ QuerySnapshot lambda$get$0(Query this_, Task viewSnap) throws Exception {
        return new QuerySnapshot(new Query(this_.query, this_.firestore), (ViewSnapshot)viewSnap.getResult(), this_.firestore);
    }

    @Keep
    public static enum Direction {
        ASCENDING,
        DESCENDING;

    }
}

