/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.model.value.NullValue;

public class NullFilter
extends Filter {
    private final FieldPath fieldPath;

    public NullFilter(FieldPath fieldPath) {
        this.fieldPath = fieldPath;
    }

    @Override
    public FieldPath getField() {
        return this.fieldPath;
    }

    @Override
    public boolean matches(Document doc) {
        FieldValue fieldValue = doc.getField(this.fieldPath);
        return fieldValue != null && fieldValue.equals(NullValue.nullValue());
    }

    @Override
    public String getCanonicalId() {
        return this.fieldPath.canonicalString() + " IS NULL";
    }

    public String toString() {
        return this.getCanonicalId();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof NullFilter)) {
            return false;
        }
        NullFilter other = (NullFilter)o;
        return this.fieldPath.equals(other.fieldPath);
    }

    public int hashCode() {
        int result = 37;
        result = 31 * result + this.fieldPath.hashCode();
        return result;
    }
}

