/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.core.DatabaseInfo;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.remote.Datastore$$Lambda$1;
import com.google.firebase.firestore.remote.Datastore$$Lambda$2;
import com.google.firebase.firestore.remote.RemoteSerializer;
import com.google.firebase.firestore.remote.WatchStream;
import com.google.firebase.firestore.remote.WriteStream;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.FirestoreChannel;
import com.google.firebase.firestore.util.Supplier;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.FirestoreGrpc;
import com.google.firestore.v1.WriteResult;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.android.AndroidChannelBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class Datastore {
    public static final Set<String> WHITE_LISTED_HEADERS = new HashSet<String>(Arrays.asList("date", "x-google-backends", "x-google-netmon-label", "x-google-service", "x-google-gfe-request-trace"));
    private final DatabaseInfo databaseInfo;
    private final RemoteSerializer serializer;
    private final AsyncQueue workerQueue;
    private final FirestoreChannel channel;
    private static Supplier<ManagedChannelBuilder<?>> overrideChannelBuilderSupplier;

    @VisibleForTesting
    public static void overrideChannelBuilder(Supplier<ManagedChannelBuilder<?>> channelBuilderSupplier) {
        overrideChannelBuilderSupplier = channelBuilderSupplier;
    }

    public Datastore(DatabaseInfo databaseInfo, AsyncQueue workerQueue, CredentialsProvider credentialsProvider, Context context) {
        ManagedChannelBuilder channelBuilder;
        this.databaseInfo = databaseInfo;
        this.workerQueue = workerQueue;
        this.serializer = new RemoteSerializer(databaseInfo.getDatabaseId());
        if (overrideChannelBuilderSupplier != null) {
            channelBuilder = overrideChannelBuilderSupplier.get();
        } else {
            channelBuilder = ManagedChannelBuilder.forTarget((String)databaseInfo.getHost());
            if (!databaseInfo.isSslEnabled()) {
                channelBuilder.usePlaintext();
            }
        }
        channelBuilder.keepAliveTime(30L, TimeUnit.SECONDS);
        channelBuilder.executor(workerQueue.getExecutor());
        AndroidChannelBuilder androidChannelBuilder = AndroidChannelBuilder.fromBuilder((ManagedChannelBuilder)channelBuilder).context(context);
        this.channel = new FirestoreChannel(workerQueue, credentialsProvider, androidChannelBuilder.build(), databaseInfo.getDatabaseId());
    }

    void shutdown() {
        this.channel.shutdown();
    }

    AsyncQueue getWorkerQueue() {
        return this.workerQueue;
    }

    DatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    WatchStream createWatchStream(WatchStream.Callback listener) {
        return new WatchStream(this.channel, this.workerQueue, this.serializer, listener);
    }

    WriteStream createWriteStream(WriteStream.Callback listener) {
        return new WriteStream(this.channel, this.workerQueue, this.serializer, listener);
    }

    public Task<List<MutationResult>> commit(List<Mutation> mutations) {
        CommitRequest.Builder builder = CommitRequest.newBuilder();
        builder.setDatabase(this.serializer.databaseName());
        for (Mutation mutation : mutations) {
            builder.addWrites(this.serializer.encodeMutation(mutation));
        }
        return this.channel.runRpc(FirestoreGrpc.getCommitMethod(), (CommitRequest)builder.build()).continueWith(this.workerQueue.getExecutor(), Datastore$$Lambda$1.lambdaFactory$(this));
    }

    public Task<List<MaybeDocument>> lookup(List<DocumentKey> keys) {
        BatchGetDocumentsRequest.Builder builder = BatchGetDocumentsRequest.newBuilder();
        builder.setDatabase(this.serializer.databaseName());
        for (DocumentKey key : keys) {
            builder.addDocuments(this.serializer.encodeKey(key));
        }
        return this.channel.runStreamingResponseRpc(FirestoreGrpc.getBatchGetDocumentsMethod(), (BatchGetDocumentsRequest)builder.build()).continueWith(this.workerQueue.getExecutor(), Datastore$$Lambda$2.lambdaFactory$(this, keys));
    }

    public static boolean isPermanentError(Status status) {
        switch (status.getCode()) {
            case OK: {
                throw new IllegalArgumentException("Treated status OK as error");
            }
            case CANCELLED: 
            case UNKNOWN: 
            case DEADLINE_EXCEEDED: 
            case RESOURCE_EXHAUSTED: 
            case INTERNAL: 
            case UNAVAILABLE: 
            case UNAUTHENTICATED: {
                return false;
            }
            case INVALID_ARGUMENT: 
            case NOT_FOUND: 
            case ALREADY_EXISTS: 
            case PERMISSION_DENIED: 
            case FAILED_PRECONDITION: 
            case ABORTED: 
            case OUT_OF_RANGE: 
            case UNIMPLEMENTED: 
            case DATA_LOSS: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown gRPC status code: " + status.getCode());
    }

    public static boolean isPermanentWriteError(Status status) {
        return Datastore.isPermanentError(status) && !status.getCode().equals((Object)Status.Code.ABORTED);
    }

    static /* synthetic */ List lambda$lookup$1(Datastore this_, List keys, Task task) throws Exception {
        if (!task.isSuccessful() && task.getException() instanceof FirebaseFirestoreException && ((FirebaseFirestoreException)((Object)task.getException())).getCode() == FirebaseFirestoreException.Code.UNAUTHENTICATED) {
            this_.channel.invalidateToken();
        }
        HashMap<DocumentKey, MaybeDocument> resultMap = new HashMap<DocumentKey, MaybeDocument>();
        List responses = (List)task.getResult();
        for (BatchGetDocumentsResponse response : responses) {
            MaybeDocument doc = this_.serializer.decodeMaybeDocument(response);
            resultMap.put(doc.getKey(), doc);
        }
        ArrayList<MaybeDocument> results = new ArrayList<MaybeDocument>();
        for (DocumentKey key : keys) {
            results.add((MaybeDocument)resultMap.get(key));
        }
        return results;
    }

    static /* synthetic */ List lambda$commit$0(Datastore this_, Task task) throws Exception {
        if (!task.isSuccessful()) {
            if (task.getException() instanceof FirebaseFirestoreException && ((FirebaseFirestoreException)((Object)task.getException())).getCode() == FirebaseFirestoreException.Code.UNAUTHENTICATED) {
                this_.channel.invalidateToken();
            }
            throw task.getException();
        }
        CommitResponse response = (CommitResponse)task.getResult();
        SnapshotVersion commitVersion = this_.serializer.decodeVersion(response.getCommitTime());
        int count = response.getWriteResultsCount();
        ArrayList<MutationResult> results = new ArrayList<MutationResult>(count);
        for (int i = 0; i < count; ++i) {
            WriteResult result = response.getWriteResults(i);
            results.add(this_.serializer.decodeMutationResult(result, commitVersion));
        }
        return results;
    }
}

