/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.number;

public class IndexNumberEncoder {
    public static final int MAX_ENCODED_BYTES = 11;
    static final long DOUBLE_SIGN_BIT = Long.MIN_VALUE;
    static final int DOUBLE_EXPONENT_BIAS = 1023;
    static final int DOUBLE_MIN_EXPONENT = -1022;
    static final int DOUBLE_SIGNIFICAND_BITS = 52;
    static final int SIGNIFICAND_BITS = 64;
    static final int POSITIVE_INFINITE_EXPONENT = Integer.MAX_VALUE;
    static final int NEGATIVE_INFINITE_EXPONENT = Integer.MIN_VALUE;
    static final int EXP1_END = 4;
    static final int EXP2_END = 20;
    static final int EXP3_END = 148;
    static final int EXP4_END = 1172;

    private IndexNumberEncoder() {
    }

    public static int encodeLong(boolean descending, long value, byte[] buffer, int offset) {
        if (value == 0L) {
            return IndexNumberEncoder.encodeZero(buffer, offset);
        }
        boolean negative = descending;
        if (value < 0L) {
            negative = !negative;
            value = -value;
        }
        int leadingZeros = Long.numberOfLeadingZeros(value);
        int exponent = 63 - leadingZeros;
        long significand = value & (1L << exponent ^ 0xFFFFFFFFFFFFFFFFL);
        return IndexNumberEncoder.encodeNumber(negative, exponent, significand <<= leadingZeros + 1, buffer, offset);
    }

    public static int encodeDouble(boolean descending, double value, byte[] buffer, int offset) {
        if (value == 0.0) {
            return IndexNumberEncoder.encodeZero(buffer, offset);
        }
        long doubleBits = Double.doubleToLongBits(value);
        boolean invertEncoding = value < 0.0 ^ descending;
        int exponent = (int)(doubleBits >>> 52 & 0x7FFL) - 1023;
        long significand = doubleBits & 0xFFFFFFFFFFFFFL;
        if (exponent < -1022) {
            int leadingZeros = Long.numberOfLeadingZeros(significand);
            int binaryExponent = 63 - leadingZeros;
            significand &= 1L << binaryExponent ^ 0xFFFFFFFFFFFFFFFFL;
            significand <<= leadingZeros + 1;
            int adjustment = leadingZeros - 12;
            exponent -= adjustment;
        } else {
            if (exponent > 1023) {
                if (significand == 0L) {
                    if (invertEncoding) {
                        buffer[offset++] = 0;
                        buffer[offset++] = -128;
                        return 2;
                    }
                    buffer[offset++] = -1;
                    return 1;
                }
                buffer[offset++] = 0;
                buffer[offset++] = 96;
                return 2;
            }
            significand <<= 12;
        }
        return IndexNumberEncoder.encodeNumber(invertEncoding, exponent, significand, buffer, offset);
    }

    private static int encodeZero(byte[] buffer, int offset) {
        buffer[offset] = -128;
        return 1;
    }

    private static int encodeNumber(boolean invertEncoding, int exponent, long significand, byte[] buffer, int offset) {
        int lastByte;
        int bufferPos = offset;
        int inverter = invertEncoding ? 255 : 0;
        int exponentMask = 0;
        if (exponent < 0) {
            exponent = -exponent;
            exponentMask = 255;
        }
        if (exponent < 4) {
            lastByte = 192;
            int significandStart = exponent + 1;
            lastByte |= 1 << significandStart;
            int significandMask = (1 << significandStart) - 2;
            lastByte |= (int)(significand >>> 64 - significandStart) & significandMask;
            significand <<= exponent;
            if (exponentMask != 0) {
                int exponentInverter = -1 << significandStart & 0x7E;
                lastByte ^= exponentInverter;
            }
        } else if (exponent < 20) {
            lastByte = 224;
            assert ((exponent -= 4) <= 15);
            lastByte |= exponent;
            buffer[bufferPos++] = (byte)(lastByte ^= 0x7F & exponentMask ^ inverter);
            lastByte = IndexNumberEncoder.topSignificandByte(significand);
            significand <<= 7;
        } else if (exponent < 148) {
            lastByte = 240;
            assert ((exponent -= 20) <= 127);
            lastByte |= exponent >>> 4;
            buffer[bufferPos++] = (byte)(lastByte ^= 0x7F & exponentMask ^ inverter);
            lastByte = exponent << 4 & 0xF0;
            lastByte |= (int)(significand >>> 60);
            buffer[bufferPos++] = (byte)(lastByte ^= 0xF0 & exponentMask ^ inverter);
            lastByte = IndexNumberEncoder.topSignificandByte(significand <<= 4);
            significand <<= 7;
        } else if (exponent < 1172) {
            lastByte = 248;
            assert ((exponent -= 148) <= 1023);
            lastByte |= exponent >>> 8;
            buffer[bufferPos++] = (byte)(lastByte ^= 0x7F & exponentMask ^ inverter);
            lastByte = exponent & 0xFF;
            buffer[bufferPos++] = (byte)(lastByte ^= 0xFF & exponentMask ^ inverter);
            lastByte = IndexNumberEncoder.topSignificandByte(significand);
            significand <<= 7;
        } else {
            throw new IllegalStateException("unimplemented");
        }
        while (significand != 0L) {
            lastByte |= 1;
            buffer[bufferPos++] = (byte)(lastByte ^= inverter);
            lastByte = IndexNumberEncoder.topSignificandByte(significand);
            significand <<= 7;
        }
        buffer[bufferPos++] = (byte)(lastByte ^= inverter);
        return bufferPos - offset;
    }

    private static int topSignificandByte(long significand) {
        return (int)(significand >>> 56) & 0xFE;
    }
}

