/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import com.google.common.base.Preconditions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.util.Assert;
import java.util.Map;
import javax.annotation.Nullable;

@PublicApi
public class QueryDocumentSnapshot
extends DocumentSnapshot {
    private QueryDocumentSnapshot(FirebaseFirestore firestore, DocumentKey key, @Nullable Document doc, boolean isFromCache, boolean hasPendingWrites) {
        super(firestore, key, doc, isFromCache, hasPendingWrites);
    }

    static QueryDocumentSnapshot fromDocument(FirebaseFirestore firestore, Document doc, boolean fromCache, boolean hasPendingWrites) {
        return new QueryDocumentSnapshot(firestore, doc.getKey(), doc, fromCache, hasPendingWrites);
    }

    @Override
    @NonNull
    @PublicApi
    public Map<String, Object> getData() {
        Map<String, Object> result = super.getData();
        Assert.hardAssert(result != null, "Data in a QueryDocumentSnapshot should be non-null", new Object[0]);
        return result;
    }

    @Override
    @NonNull
    @PublicApi
    public Map<String, Object> getData(@NonNull DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior) {
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        Map<String, Object> result = super.getData(serverTimestampBehavior);
        Assert.hardAssert(result != null, "Data in a QueryDocumentSnapshot should be non-null", new Object[0]);
        return result;
    }

    @Override
    @NonNull
    @PublicApi
    public <T> T toObject(@NonNull Class<T> valueType) {
        T result = super.toObject(valueType);
        Assert.hardAssert(result != null, "Object in a QueryDocumentSnapshot should be non-null", new Object[0]);
        return result;
    }

    @Override
    @NonNull
    @PublicApi
    public <T> T toObject(@NonNull Class<T> valueType, @NonNull DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior) {
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        T result = super.toObject(valueType, serverTimestampBehavior);
        Assert.hardAssert(result != null, "Object in a QueryDocumentSnapshot should be non-null", new Object[0]);
        return result;
    }
}

