/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Preconditions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.core.UserData;
import com.google.firebase.firestore.model.mutation.DeleteMutation;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firebase.firestore.util.Util;
import java.util.ArrayList;
import java.util.Map;

@PublicApi
public class WriteBatch {
    private final FirebaseFirestore firestore;
    private final ArrayList<Mutation> mutations = new ArrayList();
    private boolean committed = false;

    WriteBatch(FirebaseFirestore firestore) {
        this.firestore = (FirebaseFirestore)Preconditions.checkNotNull((Object)firestore);
    }

    @NonNull
    @PublicApi
    public WriteBatch set(@NonNull DocumentReference documentRef, @NonNull Object data) {
        return this.set(documentRef, data, SetOptions.OVERWRITE);
    }

    @NonNull
    @PublicApi
    public WriteBatch set(@NonNull DocumentReference documentRef, @NonNull Object data, @NonNull SetOptions options) {
        this.firestore.validateReference(documentRef);
        Preconditions.checkNotNull((Object)data, (Object)"Provided data must not be null.");
        Preconditions.checkNotNull((Object)options, (Object)"Provided options must not be null.");
        this.verifyNotCommitted();
        UserData.ParsedSetData parsed = options.isMerge() ? this.firestore.getDataConverter().parseMergeData(data, options.getFieldMask()) : this.firestore.getDataConverter().parseSetData(data);
        this.mutations.addAll(parsed.toMutationList(documentRef.getKey(), Precondition.NONE));
        return this;
    }

    @NonNull
    @PublicApi
    public WriteBatch update(@NonNull DocumentReference documentRef, @NonNull Map<String, Object> data) {
        UserData.ParsedUpdateData parsedData = this.firestore.getDataConverter().parseUpdateData(data);
        return this.update(documentRef, parsedData);
    }

    @NonNull
    @PublicApi
    public WriteBatch update(@NonNull DocumentReference documentRef, @NonNull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        UserData.ParsedUpdateData parsedData = this.firestore.getDataConverter().parseUpdateData(Util.collectUpdateArguments(1, field, value, moreFieldsAndValues));
        return this.update(documentRef, parsedData);
    }

    @NonNull
    @PublicApi
    public WriteBatch update(@NonNull DocumentReference documentRef, @NonNull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        UserData.ParsedUpdateData parsedData = this.firestore.getDataConverter().parseUpdateData(Util.collectUpdateArguments(1, fieldPath, value, moreFieldsAndValues));
        return this.update(documentRef, parsedData);
    }

    private WriteBatch update(@NonNull DocumentReference documentRef, @NonNull UserData.ParsedUpdateData updateData) {
        this.firestore.validateReference(documentRef);
        this.verifyNotCommitted();
        this.mutations.addAll(updateData.toMutationList(documentRef.getKey(), Precondition.exists(true)));
        return this;
    }

    @NonNull
    @PublicApi
    public WriteBatch delete(@NonNull DocumentReference documentRef) {
        this.firestore.validateReference(documentRef);
        this.verifyNotCommitted();
        this.mutations.add(new DeleteMutation(documentRef.getKey(), Precondition.NONE));
        return this;
    }

    @NonNull
    @PublicApi
    public Task<Void> commit() {
        this.verifyNotCommitted();
        this.committed = true;
        if (this.mutations.size() > 0) {
            return this.firestore.getClient().write(this.mutations);
        }
        return Tasks.forResult(null);
    }

    private void verifyNotCommitted() {
        if (this.committed) {
            throw new IllegalStateException("A write batch can no longer be used after commit() has been called.");
        }
    }

    @PublicApi
    public static interface Function {
        @PublicApi
        public void apply(@NonNull WriteBatch var1);
    }
}

