/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.util.SparseArray;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.MemoryPersistence;
import com.google.firebase.firestore.local.QueryCache;
import com.google.firebase.firestore.local.QueryData;
import com.google.firebase.firestore.local.ReferenceDelegate;
import com.google.firebase.firestore.local.ReferenceSet;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.util.Consumer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

final class MemoryQueryCache
implements QueryCache {
    private final Map<Query, QueryData> queries = new HashMap<Query, QueryData>();
    private final ReferenceSet references = new ReferenceSet();
    private int highestTargetId;
    private SnapshotVersion lastRemoteSnapshotVersion = SnapshotVersion.NONE;
    private long highestSequenceNumber = 0L;
    private final MemoryPersistence persistence;

    MemoryQueryCache(MemoryPersistence persistence) {
        this.persistence = persistence;
    }

    @Override
    public int getHighestTargetId() {
        return this.highestTargetId;
    }

    @Override
    public long getTargetCount() {
        return this.queries.size();
    }

    @Override
    public void forEachTarget(Consumer<QueryData> consumer) {
        for (QueryData queryData : this.queries.values()) {
            consumer.accept(queryData);
        }
    }

    @Override
    public long getHighestListenSequenceNumber() {
        return this.highestSequenceNumber;
    }

    @Override
    public SnapshotVersion getLastRemoteSnapshotVersion() {
        return this.lastRemoteSnapshotVersion;
    }

    @Override
    public void setLastRemoteSnapshotVersion(SnapshotVersion snapshotVersion) {
        this.lastRemoteSnapshotVersion = snapshotVersion;
    }

    @Override
    public void addQueryData(QueryData queryData) {
        this.queries.put(queryData.getQuery(), queryData);
        int targetId = queryData.getTargetId();
        if (targetId > this.highestTargetId) {
            this.highestTargetId = targetId;
        }
        if (queryData.getSequenceNumber() > this.highestSequenceNumber) {
            this.highestSequenceNumber = queryData.getSequenceNumber();
        }
    }

    @Override
    public void updateQueryData(QueryData queryData) {
        this.addQueryData(queryData);
    }

    @Override
    public void removeQueryData(QueryData queryData) {
        this.queries.remove(queryData.getQuery());
        this.references.removeReferencesForId(queryData.getTargetId());
    }

    int removeQueries(long upperBound, SparseArray<?> activeTargetIds) {
        int removed = 0;
        Iterator<Map.Entry<Query, QueryData>> it = this.queries.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Query, QueryData> entry = it.next();
            int targetId = entry.getValue().getTargetId();
            long sequenceNumber = entry.getValue().getSequenceNumber();
            if (sequenceNumber > upperBound || activeTargetIds.get(targetId) != null) continue;
            it.remove();
            this.removeMatchingKeysForTargetId(targetId);
            ++removed;
        }
        return removed;
    }

    @Override
    @Nullable
    public QueryData getQueryData(Query query) {
        return this.queries.get(query);
    }

    @Override
    public void addMatchingKeys(ImmutableSortedSet<DocumentKey> keys, int targetId) {
        this.references.addReferences(keys, targetId);
        ReferenceDelegate referenceDelegate = this.persistence.getReferenceDelegate();
        for (DocumentKey key : keys) {
            referenceDelegate.addReference(key);
        }
    }

    @Override
    public void removeMatchingKeys(ImmutableSortedSet<DocumentKey> keys, int targetId) {
        this.references.removeReferences(keys, targetId);
        ReferenceDelegate referenceDelegate = this.persistence.getReferenceDelegate();
        for (DocumentKey key : keys) {
            referenceDelegate.removeReference(key);
        }
    }

    private void removeMatchingKeysForTargetId(int targetId) {
        this.references.removeReferencesForId(targetId);
    }

    @Override
    public ImmutableSortedSet<DocumentKey> getMatchingKeysForTargetId(int targetId) {
        return this.references.referencesForId(targetId);
    }

    @Override
    public boolean containsKey(DocumentKey key) {
        return this.references.containsKey(key);
    }

    long getByteSize(LocalSerializer serializer) {
        long count = 0L;
        for (Map.Entry<Query, QueryData> entry : this.queries.entrySet()) {
            count += (long)serializer.encodeQueryData(entry.getValue()).getSerializedSize();
        }
        return count;
    }
}

