/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.common.base.Preconditions;
import com.google.firebase.firestore.CollectionReference$$Lambda$1;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.Query;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Util;

public class CollectionReference
extends Query {
    CollectionReference(ResourcePath path, FirebaseFirestore firestore) {
        super(com.google.firebase.firestore.core.Query.atPath(path), firestore);
        if (path.length() % 2 != 1) {
            throw new IllegalArgumentException("Invalid collection reference. Collection references must have an odd number of segments, but " + path.canonicalString() + " has " + path.length());
        }
    }

    @NonNull
    public String getId() {
        return this.query.getPath().getLastSegment();
    }

    @Nullable
    public DocumentReference getParent() {
        ResourcePath parentPath = (ResourcePath)this.query.getPath().popLast();
        if (parentPath.isEmpty()) {
            return null;
        }
        return new DocumentReference(DocumentKey.fromPath(parentPath), this.firestore);
    }

    @NonNull
    public String getPath() {
        return this.query.getPath().canonicalString();
    }

    @NonNull
    public DocumentReference document() {
        return this.document(Util.autoId());
    }

    @NonNull
    public DocumentReference document(@NonNull String documentPath) {
        Preconditions.checkNotNull((Object)documentPath, (Object)"Provided document path must not be null.");
        return DocumentReference.forPath(this.query.getPath().append(ResourcePath.fromString(documentPath)), this.firestore);
    }

    @NonNull
    public Task<DocumentReference> add(@NonNull Object data) {
        Preconditions.checkNotNull((Object)data, (Object)"Provided data must not be null.");
        DocumentReference ref = this.document();
        return ref.set(data).continueWith(Executors.DIRECT_EXECUTOR, CollectionReference$$Lambda$1.lambdaFactory$(ref));
    }

    static /* synthetic */ DocumentReference lambda$add$0(DocumentReference ref, Task task) throws Exception {
        task.getResult();
        return ref;
    }
}

