/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.common.base.Preconditions;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.mutation.FieldMask;
import java.util.HashSet;
import java.util.List;

public final class SetOptions {
    static final SetOptions OVERWRITE = new SetOptions(false, null);
    private static final SetOptions MERGE_ALL_FIELDS = new SetOptions(true, null);
    private final boolean merge;
    @Nullable
    private final FieldMask fieldMask;

    private SetOptions(boolean merge, @Nullable FieldMask fieldMask) {
        Preconditions.checkArgument((fieldMask == null || merge ? 1 : 0) != 0, (Object)"Cannot specify a fieldMask for non-merge sets()");
        this.merge = merge;
        this.fieldMask = fieldMask;
    }

    boolean isMerge() {
        return this.merge;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public FieldMask getFieldMask() {
        return this.fieldMask;
    }

    @NonNull
    public static SetOptions merge() {
        return MERGE_ALL_FIELDS;
    }

    @NonNull
    public static SetOptions mergeFields(@NonNull List<String> fields) {
        HashSet<FieldPath> fieldPaths = new HashSet<FieldPath>();
        for (String field : fields) {
            fieldPaths.add(com.google.firebase.firestore.FieldPath.fromDotSeparatedPath(field).getInternalPath());
        }
        return new SetOptions(true, FieldMask.fromSet(fieldPaths));
    }

    @NonNull
    public static SetOptions mergeFields(String ... fields) {
        HashSet<FieldPath> fieldPaths = new HashSet<FieldPath>();
        for (String field : fields) {
            fieldPaths.add(com.google.firebase.firestore.FieldPath.fromDotSeparatedPath(field).getInternalPath());
        }
        return new SetOptions(true, FieldMask.fromSet(fieldPaths));
    }

    @NonNull
    public static SetOptions mergeFieldPaths(@NonNull List<com.google.firebase.firestore.FieldPath> fields) {
        HashSet<FieldPath> fieldPaths = new HashSet<FieldPath>();
        for (com.google.firebase.firestore.FieldPath field : fields) {
            fieldPaths.add(field.getInternalPath());
        }
        return new SetOptions(true, FieldMask.fromSet(fieldPaths));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetOptions that = (SetOptions)o;
        if (this.merge != that.merge) {
            return false;
        }
        return this.fieldMask != null ? this.fieldMask.equals(that.fieldMask) : that.fieldMask == null;
    }

    public int hashCode() {
        int result = this.merge ? 1 : 0;
        result = 31 * result + (this.fieldMask != null ? this.fieldMask.hashCode() : 0);
        return result;
    }
}

