/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.common.base.Preconditions;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FieldValue;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.core.UserData;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.model.mutation.ArrayTransformOperation;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.model.mutation.NumericIncrementTransformOperation;
import com.google.firebase.firestore.model.mutation.ServerTimestampOperation;
import com.google.firebase.firestore.model.value.ArrayValue;
import com.google.firebase.firestore.model.value.BlobValue;
import com.google.firebase.firestore.model.value.BooleanValue;
import com.google.firebase.firestore.model.value.DoubleValue;
import com.google.firebase.firestore.model.value.GeoPointValue;
import com.google.firebase.firestore.model.value.IntegerValue;
import com.google.firebase.firestore.model.value.NullValue;
import com.google.firebase.firestore.model.value.NumberValue;
import com.google.firebase.firestore.model.value.ObjectValue;
import com.google.firebase.firestore.model.value.ReferenceValue;
import com.google.firebase.firestore.model.value.StringValue;
import com.google.firebase.firestore.model.value.TimestampValue;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.CustomClassMapper;
import com.google.firebase.firestore.util.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class UserDataConverter {
    private final DatabaseId databaseId;

    public UserDataConverter(DatabaseId databaseId) {
        this.databaseId = databaseId;
    }

    public UserData.ParsedSetData parseSetData(Object input) {
        UserData.ParseAccumulator accumulator = new UserData.ParseAccumulator(UserData.Source.Set);
        ObjectValue updateData = this.convertAndParseDocumentData(input, accumulator.rootContext());
        return accumulator.toSetData(updateData);
    }

    public UserData.ParsedSetData parseMergeData(Object input, @Nullable FieldMask fieldMask) {
        UserData.ParseAccumulator accumulator = new UserData.ParseAccumulator(UserData.Source.MergeSet);
        ObjectValue updateData = this.convertAndParseDocumentData(input, accumulator.rootContext());
        if (fieldMask != null) {
            for (com.google.firebase.firestore.model.FieldPath field : fieldMask.getMask()) {
                if (accumulator.contains(field)) continue;
                throw new IllegalArgumentException("Field '" + field.toString() + "' is specified in your field mask but not in your input data.");
            }
            return accumulator.toMergeData(updateData, fieldMask);
        }
        return accumulator.toMergeData(updateData);
    }

    public UserData.ParsedUpdateData parseUpdateData(Map<String, Object> data) {
        Preconditions.checkNotNull(data, (Object)"Provided update data must not be null.");
        UserData.ParseAccumulator accumulator = new UserData.ParseAccumulator(UserData.Source.Update);
        UserData.ParseContext context = accumulator.rootContext();
        ObjectValue updateData = ObjectValue.emptyObject();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            com.google.firebase.firestore.model.FieldPath fieldPath = FieldPath.fromDotSeparatedPath(entry.getKey()).getInternalPath();
            Object fieldValue = entry.getValue();
            if (fieldValue instanceof FieldValue.DeleteFieldValue) {
                context.addToFieldMask(fieldPath);
                continue;
            }
            com.google.firebase.firestore.model.value.FieldValue parsedValue = this.convertAndParseFieldData(fieldValue, context.childContext(fieldPath));
            if (parsedValue == null) continue;
            context.addToFieldMask(fieldPath);
            updateData = updateData.set(fieldPath, parsedValue);
        }
        return accumulator.toUpdateData(updateData);
    }

    public UserData.ParsedUpdateData parseUpdateData(List<Object> fieldsAndValues) {
        Assert.hardAssert(fieldsAndValues.size() % 2 == 0, "Expected fieldAndValues to contain an even number of elements", new Object[0]);
        UserData.ParseAccumulator accumulator = new UserData.ParseAccumulator(UserData.Source.Update);
        UserData.ParseContext context = accumulator.rootContext();
        ObjectValue updateData = ObjectValue.emptyObject();
        Iterator<Object> iterator = fieldsAndValues.iterator();
        while (iterator.hasNext()) {
            Object fieldPath = iterator.next();
            Object fieldValue = iterator.next();
            Assert.hardAssert(fieldPath instanceof String || fieldPath instanceof FieldPath, "Expected argument to be String or FieldPath.", new Object[0]);
            com.google.firebase.firestore.model.FieldPath parsedField = fieldPath instanceof String ? FieldPath.fromDotSeparatedPath((String)fieldPath).getInternalPath() : ((FieldPath)fieldPath).getInternalPath();
            if (fieldValue instanceof FieldValue.DeleteFieldValue) {
                context.addToFieldMask(parsedField);
                continue;
            }
            com.google.firebase.firestore.model.value.FieldValue parsedValue = this.convertAndParseFieldData(fieldValue, context.childContext(parsedField));
            if (parsedValue == null) continue;
            context.addToFieldMask(parsedField);
            updateData = updateData.set(parsedField, parsedValue);
        }
        return accumulator.toUpdateData(updateData);
    }

    public com.google.firebase.firestore.model.value.FieldValue parseQueryValue(Object input) {
        UserData.ParseAccumulator accumulator = new UserData.ParseAccumulator(UserData.Source.Argument);
        com.google.firebase.firestore.model.value.FieldValue parsed = this.convertAndParseFieldData(input, accumulator.rootContext());
        Assert.hardAssert(parsed != null, "Parsed data should not be null.", new Object[0]);
        Assert.hardAssert(accumulator.getFieldTransforms().isEmpty(), "Field transforms should have been disallowed.", new Object[0]);
        return parsed;
    }

    private com.google.firebase.firestore.model.value.FieldValue convertAndParseFieldData(Object input, UserData.ParseContext context) {
        Object converted = CustomClassMapper.convertToPlainJavaTypes(input);
        return this.parseData(converted, context);
    }

    private ObjectValue convertAndParseDocumentData(Object input, UserData.ParseContext context) {
        String badDocReason = "Invalid data. Data must be a Map<String, Object> or a suitable POJO object, but it was ";
        if (input.getClass().isArray()) {
            throw new IllegalArgumentException(badDocReason + "an array");
        }
        Object converted = CustomClassMapper.convertToPlainJavaTypes(input);
        com.google.firebase.firestore.model.value.FieldValue value = this.parseData(converted, context);
        if (!(value instanceof ObjectValue)) {
            throw new IllegalArgumentException(badDocReason + "of type: " + Util.typeName(input));
        }
        return (ObjectValue)value;
    }

    @Nullable
    private com.google.firebase.firestore.model.value.FieldValue parseData(Object input, UserData.ParseContext context) {
        if (input instanceof Map) {
            return this.parseMap((Map)input, context);
        }
        if (input instanceof FieldValue) {
            this.parseSentinelFieldValue((FieldValue)input, context);
            return null;
        }
        if (context.getPath() != null) {
            context.addToFieldMask(context.getPath());
        }
        if (input instanceof List) {
            if (context.isArrayElement()) {
                throw context.createError("Nested arrays are not supported");
            }
            return this.parseList((List)input, context);
        }
        return this.parseScalarValue(input, context);
    }

    private <K, V> ObjectValue parseMap(Map<K, V> map, UserData.ParseContext context) {
        HashMap<String, com.google.firebase.firestore.model.value.FieldValue> result = new HashMap<String, com.google.firebase.firestore.model.value.FieldValue>();
        if (map.isEmpty()) {
            if (context.getPath() != null && !context.getPath().isEmpty()) {
                context.addToFieldMask(context.getPath());
            }
            return ObjectValue.emptyObject();
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw context.createError(String.format("Non-String Map key (%s) is not allowed", entry.getValue()));
            }
            String key = (String)entry.getKey();
            com.google.firebase.firestore.model.value.FieldValue parsedValue = this.parseData(entry.getValue(), context.childContext(key));
            if (parsedValue == null) continue;
            result.put(key, parsedValue);
        }
        return ObjectValue.fromMap(result);
    }

    private <T> ArrayValue parseList(List<T> list, UserData.ParseContext context) {
        ArrayList<com.google.firebase.firestore.model.value.FieldValue> result = new ArrayList<com.google.firebase.firestore.model.value.FieldValue>(list.size());
        int entryIndex = 0;
        for (T entry : list) {
            com.google.firebase.firestore.model.value.FieldValue parsedEntry = this.parseData(entry, context.childContext(entryIndex));
            if (parsedEntry == null) {
                parsedEntry = NullValue.nullValue();
            }
            result.add(parsedEntry);
            ++entryIndex;
        }
        return ArrayValue.fromList(result);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseSentinelFieldValue(FieldValue value, UserData.ParseContext context) {
        if (!context.isWrite()) {
            throw context.createError(String.format("%s() can only be used with set() and update()", value.getMethodName()));
        }
        if (context.getPath() == null) {
            throw context.createError(String.format("%s() is not currently supported inside arrays", value.getMethodName()));
        }
        if (value instanceof FieldValue.DeleteFieldValue) {
            if (context.getDataSource() == UserData.Source.MergeSet) {
                context.addToFieldMask(context.getPath());
                return;
            }
            if (context.getDataSource() != UserData.Source.Update) throw context.createError("FieldValue.delete() can only be used with update() and set() with SetOptions.merge()");
            Assert.hardAssert(context.getPath().length() > 0, "FieldValue.delete() at the top level should have already been handled.", new Object[0]);
            throw context.createError("FieldValue.delete() can only appear at the top level of your update data");
        }
        if (value instanceof FieldValue.ServerTimestampFieldValue) {
            context.addToFieldTransforms(context.getPath(), ServerTimestampOperation.getInstance());
            return;
        }
        if (value instanceof FieldValue.ArrayUnionFieldValue) {
            List<com.google.firebase.firestore.model.value.FieldValue> parsedElements = this.parseArrayTransformElements(((FieldValue.ArrayUnionFieldValue)value).getElements());
            ArrayTransformOperation.Union arrayUnion = new ArrayTransformOperation.Union(parsedElements);
            context.addToFieldTransforms(context.getPath(), arrayUnion);
            return;
        }
        if (value instanceof FieldValue.ArrayRemoveFieldValue) {
            List<com.google.firebase.firestore.model.value.FieldValue> parsedElements = this.parseArrayTransformElements(((FieldValue.ArrayRemoveFieldValue)value).getElements());
            ArrayTransformOperation.Remove arrayRemove = new ArrayTransformOperation.Remove(parsedElements);
            context.addToFieldTransforms(context.getPath(), arrayRemove);
            return;
        }
        if (value instanceof FieldValue.NumericIncrementFieldValue) {
            FieldValue.NumericIncrementFieldValue numericIncrementFieldValue = (FieldValue.NumericIncrementFieldValue)value;
            NumberValue operand = (NumberValue)this.parseQueryValue(numericIncrementFieldValue.getOperand());
            NumericIncrementTransformOperation incrementOperation = new NumericIncrementTransformOperation(operand);
            context.addToFieldTransforms(context.getPath(), incrementOperation);
            return;
        }
        throw Assert.fail("Unknown FieldValue type: %s", Util.typeName(value));
    }

    @Nullable
    private com.google.firebase.firestore.model.value.FieldValue parseScalarValue(Object input, UserData.ParseContext context) {
        if (input == null) {
            return NullValue.nullValue();
        }
        if (input instanceof Integer) {
            return IntegerValue.valueOf(((Integer)input).longValue());
        }
        if (input instanceof Long) {
            return IntegerValue.valueOf((Long)input);
        }
        if (input instanceof Float) {
            return DoubleValue.valueOf(((Float)input).doubleValue());
        }
        if (input instanceof Double) {
            return DoubleValue.valueOf((Double)input);
        }
        if (input instanceof Boolean) {
            return BooleanValue.valueOf((Boolean)input);
        }
        if (input instanceof String) {
            return StringValue.valueOf((String)input);
        }
        if (input instanceof Date) {
            return TimestampValue.valueOf(new Timestamp((Date)input));
        }
        if (input instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)input;
            long seconds = timestamp.getSeconds();
            int truncatedNanoseconds = timestamp.getNanoseconds() / 1000 * 1000;
            return TimestampValue.valueOf(new Timestamp(seconds, truncatedNanoseconds));
        }
        if (input instanceof GeoPoint) {
            return GeoPointValue.valueOf((GeoPoint)input);
        }
        if (input instanceof Blob) {
            return BlobValue.valueOf((Blob)input);
        }
        if (input instanceof DocumentReference) {
            DatabaseId otherDb;
            DocumentReference ref = (DocumentReference)input;
            if (ref.getFirestore() != null && !(otherDb = ref.getFirestore().getDatabaseId()).equals(this.databaseId)) {
                throw context.createError(String.format("Document reference is for database %s/%s but should be for database %s/%s", otherDb.getProjectId(), otherDb.getDatabaseId(), this.databaseId.getProjectId(), this.databaseId.getDatabaseId()));
            }
            return ReferenceValue.valueOf(this.databaseId, ref.getKey());
        }
        if (input.getClass().isArray()) {
            throw context.createError("Arrays are not supported; use a List instead");
        }
        throw context.createError("Unsupported type: " + Util.typeName(input));
    }

    private List<com.google.firebase.firestore.model.value.FieldValue> parseArrayTransformElements(List<Object> elements) {
        UserData.ParseAccumulator accumulator = new UserData.ParseAccumulator(UserData.Source.Argument);
        ArrayList<com.google.firebase.firestore.model.value.FieldValue> result = new ArrayList<com.google.firebase.firestore.model.value.FieldValue>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            Object element = elements.get(i);
            UserData.ParseContext context = accumulator.rootContext();
            result.add(this.convertAndParseFieldData(element, context.childContext(i)));
        }
        return result;
    }
}

