/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.common.base.Preconditions;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.QueryPurpose;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.remote.WatchStream;
import com.google.protobuf.ByteString;

public final class QueryData {
    private final Query query;
    private final int targetId;
    private final long sequenceNumber;
    private final QueryPurpose purpose;
    private final SnapshotVersion snapshotVersion;
    private final SnapshotVersion lastLimboFreeSnapshotVersion;
    private final ByteString resumeToken;

    QueryData(Query query, int targetId, long sequenceNumber, QueryPurpose purpose, SnapshotVersion snapshotVersion, SnapshotVersion lastLimboFreeSnapshotVersion, ByteString resumeToken) {
        this.query = (Query)Preconditions.checkNotNull((Object)query);
        this.targetId = targetId;
        this.sequenceNumber = sequenceNumber;
        this.lastLimboFreeSnapshotVersion = lastLimboFreeSnapshotVersion;
        this.purpose = purpose;
        this.snapshotVersion = (SnapshotVersion)Preconditions.checkNotNull((Object)snapshotVersion);
        this.resumeToken = (ByteString)Preconditions.checkNotNull((Object)resumeToken);
    }

    public QueryData(Query query, int targetId, long sequenceNumber, QueryPurpose purpose) {
        this(query, targetId, sequenceNumber, purpose, SnapshotVersion.NONE, SnapshotVersion.NONE, WatchStream.EMPTY_RESUME_TOKEN);
    }

    public QueryData withSequenceNumber(long sequenceNumber) {
        return new QueryData(this.query, this.targetId, sequenceNumber, this.purpose, this.snapshotVersion, this.lastLimboFreeSnapshotVersion, this.resumeToken);
    }

    public QueryData withResumeToken(ByteString resumeToken, SnapshotVersion snapshotVersion) {
        return new QueryData(this.query, this.targetId, this.sequenceNumber, this.purpose, snapshotVersion, this.lastLimboFreeSnapshotVersion, resumeToken);
    }

    public QueryData withLastLimboFreeSnapshotVersion(SnapshotVersion lastLimboFreeSnapshotVersion) {
        return new QueryData(this.query, this.targetId, this.sequenceNumber, this.purpose, this.snapshotVersion, lastLimboFreeSnapshotVersion, this.resumeToken);
    }

    public Query getQuery() {
        return this.query;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public QueryPurpose getPurpose() {
        return this.purpose;
    }

    public SnapshotVersion getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public ByteString getResumeToken() {
        return this.resumeToken;
    }

    public SnapshotVersion getLastLimboFreeSnapshotVersion() {
        return this.lastLimboFreeSnapshotVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryData queryData = (QueryData)o;
        return this.query.equals(queryData.query) && this.targetId == queryData.targetId && this.sequenceNumber == queryData.sequenceNumber && this.purpose.equals((Object)queryData.purpose) && this.snapshotVersion.equals(queryData.snapshotVersion) && this.lastLimboFreeSnapshotVersion.equals(queryData.lastLimboFreeSnapshotVersion) && this.resumeToken.equals((Object)queryData.resumeToken);
    }

    public int hashCode() {
        int result = this.query.hashCode();
        result = 31 * result + this.targetId;
        result = 31 * result + (int)this.sequenceNumber;
        result = 31 * result + this.purpose.hashCode();
        result = 31 * result + this.snapshotVersion.hashCode();
        result = 31 * result + this.lastLimboFreeSnapshotVersion.hashCode();
        result = 31 * result + this.resumeToken.hashCode();
        return result;
    }

    public String toString() {
        return "QueryData{query=" + this.query + ", targetId=" + this.targetId + ", sequenceNumber=" + this.sequenceNumber + ", purpose=" + (Object)((Object)this.purpose) + ", snapshotVersion=" + this.snapshotVersion + ", lastLimboFreeSnapshotVersion=" + this.lastLimboFreeSnapshotVersion + ", resumeToken=" + this.resumeToken + '}';
    }
}

