/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import androidx.annotation.Nullable;
import com.google.common.base.Preconditions;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.MutationQueue;
import com.google.firebase.firestore.local.SQLiteMutationQueue$$Lambda$1;
import com.google.firebase.firestore.local.SQLiteMutationQueue$$Lambda$10;
import com.google.firebase.firestore.local.SQLiteMutationQueue$$Lambda$11;
import com.google.firebase.firestore.local.SQLiteMutationQueue$$Lambda$12;
import com.google.firebase.firestore.local.SQLiteMutationQueue$$Lambda$2;
import com.google.firebase.firestore.local.SQLiteMutationQueue$$Lambda$3;
import com.google.firebase.firestore.local.SQLiteMutationQueue$$Lambda$4;
import com.google.firebase.firestore.local.SQLiteMutationQueue$$Lambda$5;
import com.google.firebase.firestore.local.SQLiteMutationQueue$$Lambda$6;
import com.google.firebase.firestore.local.SQLiteMutationQueue$$Lambda$7;
import com.google.firebase.firestore.local.SQLiteMutationQueue$$Lambda$8;
import com.google.firebase.firestore.local.SQLiteMutationQueue$$Lambda$9;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationBatch;
import com.google.firebase.firestore.proto.WriteBatch;
import com.google.firebase.firestore.remote.WriteStream;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Consumer;
import com.google.firebase.firestore.util.Util;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class SQLiteMutationQueue
implements MutationQueue {
    private static final int BLOB_MAX_INLINE_LENGTH = 1000000;
    private final SQLitePersistence db;
    private final LocalSerializer serializer;
    private final String uid;
    private int nextBatchId;
    private ByteString lastStreamToken;

    SQLiteMutationQueue(SQLitePersistence persistence, LocalSerializer serializer, User user) {
        this.db = persistence;
        this.serializer = serializer;
        this.uid = user.isAuthenticated() ? user.getUid() : "";
        this.lastStreamToken = WriteStream.EMPTY_STREAM_TOKEN;
    }

    @Override
    public void start() {
        this.loadNextBatchIdAcrossAllUsers();
        int rows = this.db.query("SELECT last_stream_token FROM mutation_queues WHERE uid = ?").binding(this.uid).first(SQLiteMutationQueue$$Lambda$1.lambdaFactory$(this));
        if (rows == 0) {
            this.writeMutationQueueMetadata();
        }
    }

    private void loadNextBatchIdAcrossAllUsers() {
        ArrayList uids = new ArrayList();
        this.db.query("SELECT uid FROM mutation_queues").forEach(SQLiteMutationQueue$$Lambda$2.lambdaFactory$(uids));
        this.nextBatchId = 0;
        for (String uid : uids) {
            this.db.query("SELECT MAX(batch_id) FROM mutations WHERE uid = ?").binding(uid).forEach(SQLiteMutationQueue$$Lambda$3.lambdaFactory$(this));
        }
        ++this.nextBatchId;
    }

    @Override
    public boolean isEmpty() {
        return this.db.query("SELECT batch_id FROM mutations WHERE uid = ? LIMIT 1").binding(this.uid).isEmpty();
    }

    @Override
    public void acknowledgeBatch(MutationBatch batch, ByteString streamToken) {
        this.lastStreamToken = (ByteString)Preconditions.checkNotNull((Object)streamToken);
        this.writeMutationQueueMetadata();
    }

    @Override
    public ByteString getLastStreamToken() {
        return this.lastStreamToken;
    }

    @Override
    public void setLastStreamToken(ByteString streamToken) {
        this.lastStreamToken = (ByteString)Preconditions.checkNotNull((Object)streamToken);
        this.writeMutationQueueMetadata();
    }

    private void writeMutationQueueMetadata() {
        this.db.execute("INSERT OR REPLACE INTO mutation_queues (uid, last_acknowledged_batch_id, last_stream_token) VALUES (?, ?, ?)", this.uid, -1, this.lastStreamToken.toByteArray());
    }

    @Override
    public MutationBatch addMutationBatch(Timestamp localWriteTime, List<Mutation> baseMutations, List<Mutation> mutations) {
        int batchId = this.nextBatchId++;
        MutationBatch batch = new MutationBatch(batchId, localWriteTime, baseMutations, mutations);
        WriteBatch proto = this.serializer.encodeMutationBatch(batch);
        this.db.execute("INSERT INTO mutations (uid, batch_id, mutations) VALUES (?, ?, ?)", this.uid, batchId, proto.toByteArray());
        HashSet<DocumentKey> inserted = new HashSet<DocumentKey>();
        SQLiteStatement indexInserter = this.db.prepare("INSERT INTO document_mutations (uid, path, batch_id) VALUES (?, ?, ?)");
        for (Mutation mutation : mutations) {
            DocumentKey key = mutation.getKey();
            if (!inserted.add(key)) continue;
            String path = EncodedPath.encode(key.getPath());
            this.db.execute(indexInserter, this.uid, path, batchId);
            this.db.getIndexManager().addToCollectionParentIndex((ResourcePath)key.getPath().popLast());
        }
        return batch;
    }

    @Override
    @Nullable
    public MutationBatch lookupMutationBatch(int batchId) {
        return (MutationBatch)this.db.query("SELECT SUBSTR(mutations, 1, ?) FROM mutations WHERE uid = ? AND batch_id = ?").binding(1000000, this.uid, batchId).firstValue(SQLiteMutationQueue$$Lambda$4.lambdaFactory$(this, batchId));
    }

    @Override
    @Nullable
    public MutationBatch getNextMutationBatchAfterBatchId(int batchId) {
        int nextBatchId = batchId + 1;
        return (MutationBatch)this.db.query("SELECT batch_id, SUBSTR(mutations, 1, ?) FROM mutations WHERE uid = ? AND batch_id >= ? ORDER BY batch_id ASC LIMIT 1").binding(1000000, this.uid, nextBatchId).firstValue(SQLiteMutationQueue$$Lambda$5.lambdaFactory$(this));
    }

    @Override
    public int getHighestUnacknowledgedBatchId() {
        return (Integer)this.db.query("SELECT IFNULL(MAX(batch_id), ?) FROM mutations WHERE uid = ?").binding(-1, this.uid).firstValue(SQLiteMutationQueue$$Lambda$6.lambdaFactory$());
    }

    @Override
    public List<MutationBatch> getAllMutationBatches() {
        ArrayList<MutationBatch> result = new ArrayList<MutationBatch>();
        this.db.query("SELECT batch_id, SUBSTR(mutations, 1, ?) FROM mutations WHERE uid = ? ORDER BY batch_id ASC").binding(1000000, this.uid).forEach(SQLiteMutationQueue$$Lambda$7.lambdaFactory$(this, result));
        return result;
    }

    @Override
    public List<MutationBatch> getAllMutationBatchesAffectingDocumentKey(DocumentKey documentKey) {
        String path = EncodedPath.encode(documentKey.getPath());
        ArrayList<MutationBatch> result = new ArrayList<MutationBatch>();
        this.db.query("SELECT m.batch_id, SUBSTR(m.mutations, 1, ?) FROM document_mutations dm, mutations m WHERE dm.uid = ? AND dm.path = ? AND dm.uid = m.uid AND dm.batch_id = m.batch_id ORDER BY dm.batch_id").binding(1000000, this.uid, path).forEach(SQLiteMutationQueue$$Lambda$8.lambdaFactory$(this, result));
        return result;
    }

    @Override
    public List<MutationBatch> getAllMutationBatchesAffectingDocumentKeys(Iterable<DocumentKey> documentKeys) {
        ArrayList<Object> args = new ArrayList<Object>();
        for (DocumentKey key : documentKeys) {
            args.add(EncodedPath.encode(key.getPath()));
        }
        SQLitePersistence.LongQuery longQuery = new SQLitePersistence.LongQuery(this.db, "SELECT DISTINCT dm.batch_id, SUBSTR(m.mutations, 1, ?) FROM document_mutations dm, mutations m WHERE dm.uid = ? AND dm.path IN (", Arrays.asList(1000000, this.uid), args, ") AND dm.uid = m.uid AND dm.batch_id = m.batch_id ORDER BY dm.batch_id");
        ArrayList<MutationBatch> result = new ArrayList<MutationBatch>();
        HashSet uniqueBatchIds = new HashSet();
        while (longQuery.hasMoreSubqueries()) {
            longQuery.performNextSubquery().forEach(SQLiteMutationQueue$$Lambda$9.lambdaFactory$(this, uniqueBatchIds, result));
        }
        if (longQuery.getSubqueriesPerformed() > 1) {
            Collections.sort(result, SQLiteMutationQueue$$Lambda$10.lambdaFactory$());
        }
        return result;
    }

    @Override
    public List<MutationBatch> getAllMutationBatchesAffectingQuery(Query query) {
        Assert.hardAssert(!query.isCollectionGroupQuery(), "CollectionGroup queries should be handled in LocalDocumentsView", new Object[0]);
        ResourcePath prefix = query.getPath();
        int immediateChildrenPathLength = prefix.length() + 1;
        String prefixPath = EncodedPath.encode(prefix);
        String prefixSuccessorPath = EncodedPath.prefixSuccessor(prefixPath);
        ArrayList<MutationBatch> result = new ArrayList<MutationBatch>();
        this.db.query("SELECT dm.batch_id, dm.path, SUBSTR(m.mutations, 1, ?) FROM document_mutations dm, mutations m WHERE dm.uid = ? AND dm.path >= ? AND dm.path < ? AND dm.uid = m.uid AND dm.batch_id = m.batch_id ORDER BY dm.batch_id").binding(1000000, this.uid, prefixPath, prefixSuccessorPath).forEach(SQLiteMutationQueue$$Lambda$11.lambdaFactory$(this, result, immediateChildrenPathLength));
        return result;
    }

    @Override
    public void removeMutationBatch(MutationBatch batch) {
        SQLiteStatement mutationDeleter = this.db.prepare("DELETE FROM mutations WHERE uid = ? AND batch_id = ?");
        SQLiteStatement indexDeleter = this.db.prepare("DELETE FROM document_mutations WHERE uid = ? AND path = ? AND batch_id = ?");
        int batchId = batch.getBatchId();
        int deleted = this.db.execute(mutationDeleter, this.uid, batchId);
        Assert.hardAssert(deleted != 0, "Mutation batch (%s, %d) did not exist", this.uid, batch.getBatchId());
        for (Mutation mutation : batch.getMutations()) {
            DocumentKey key = mutation.getKey();
            String path = EncodedPath.encode(key.getPath());
            this.db.execute(indexDeleter, this.uid, path, batchId);
            this.db.getReferenceDelegate().removeMutationReference(key);
        }
    }

    @Override
    public void performConsistencyCheck() {
        if (!this.isEmpty()) {
            return;
        }
        ArrayList danglingMutationReferences = new ArrayList();
        this.db.query("SELECT path FROM document_mutations WHERE uid = ?").binding(this.uid).forEach(SQLiteMutationQueue$$Lambda$12.lambdaFactory$(danglingMutationReferences));
        Assert.hardAssert(danglingMutationReferences.isEmpty(), "Document leak -- detected dangling mutation references when queue is empty. Dangling keys: %s", danglingMutationReferences);
    }

    private MutationBatch decodeInlineMutationBatch(int batchId, byte[] bytes) {
        try {
            if (bytes.length < 1000000) {
                return this.serializer.decodeMutationBatch(WriteBatch.parseFrom(bytes));
            }
            BlobAccumulator accumulator = new BlobAccumulator(bytes);
            while (accumulator.more) {
                int start = accumulator.numChunks() * 1000000 + 1;
                this.db.query("SELECT SUBSTR(mutations, ?, ?) FROM mutations WHERE uid = ? AND batch_id = ?").binding(start, 1000000, this.uid, batchId).first(accumulator);
            }
            ByteString blob = accumulator.result();
            return this.serializer.decodeMutationBatch(WriteBatch.parseFrom(blob));
        }
        catch (InvalidProtocolBufferException e) {
            throw Assert.fail("MutationBatch failed to parse: %s", new Object[]{e});
        }
    }

    static /* synthetic */ void lambda$performConsistencyCheck$11(List danglingMutationReferences, Cursor row) {
        ResourcePath path = EncodedPath.decodeResourcePath(row.getString(0));
        danglingMutationReferences.add(path);
    }

    static /* synthetic */ void lambda$getAllMutationBatchesAffectingQuery$10(SQLiteMutationQueue this_, List result, int immediateChildrenPathLength, Cursor row) {
        int batchId = row.getInt(0);
        int size = result.size();
        if (size > 0 && batchId == ((MutationBatch)result.get(size - 1)).getBatchId()) {
            return;
        }
        ResourcePath path = EncodedPath.decodeResourcePath(row.getString(1));
        if (path.length() != immediateChildrenPathLength) {
            return;
        }
        result.add(this_.decodeInlineMutationBatch(batchId, row.getBlob(2)));
    }

    static /* synthetic */ int lambda$getAllMutationBatchesAffectingDocumentKeys$9(MutationBatch lhs, MutationBatch rhs) {
        return Util.compareInts(lhs.getBatchId(), rhs.getBatchId());
    }

    static /* synthetic */ void lambda$getAllMutationBatchesAffectingDocumentKeys$8(SQLiteMutationQueue this_, Set uniqueBatchIds, List result, Cursor row) {
        int batchId = row.getInt(0);
        if (!uniqueBatchIds.contains(batchId)) {
            uniqueBatchIds.add(batchId);
            result.add(this_.decodeInlineMutationBatch(batchId, row.getBlob(1)));
        }
    }

    static /* synthetic */ void lambda$getAllMutationBatchesAffectingDocumentKey$7(SQLiteMutationQueue this_, List result, Cursor row) {
        result.add(this_.decodeInlineMutationBatch(row.getInt(0), row.getBlob(1)));
    }

    static /* synthetic */ void lambda$getAllMutationBatches$6(SQLiteMutationQueue this_, List result, Cursor row) {
        result.add(this_.decodeInlineMutationBatch(row.getInt(0), row.getBlob(1)));
    }

    static /* synthetic */ Integer lambda$getHighestUnacknowledgedBatchId$5(Cursor row) {
        return row.getInt(0);
    }

    static /* synthetic */ MutationBatch lambda$getNextMutationBatchAfterBatchId$4(SQLiteMutationQueue this_, Cursor row) {
        return this_.decodeInlineMutationBatch(row.getInt(0), row.getBlob(1));
    }

    static /* synthetic */ MutationBatch lambda$lookupMutationBatch$3(SQLiteMutationQueue this_, int batchId, Cursor row) {
        return this_.decodeInlineMutationBatch(batchId, row.getBlob(0));
    }

    static /* synthetic */ void lambda$loadNextBatchIdAcrossAllUsers$2(SQLiteMutationQueue this_, Cursor row) {
        this_.nextBatchId = Math.max(this_.nextBatchId, row.getInt(0));
    }

    static /* synthetic */ void lambda$loadNextBatchIdAcrossAllUsers$1(List uids, Cursor row) {
        uids.add(row.getString(0));
    }

    static /* synthetic */ void lambda$start$0(SQLiteMutationQueue this_, Cursor row) {
        this_.lastStreamToken = ByteString.copyFrom((byte[])row.getBlob(0));
    }

    private static class BlobAccumulator
    implements Consumer<Cursor> {
        private final ArrayList<ByteString> chunks = new ArrayList();
        private boolean more = true;

        BlobAccumulator(byte[] firstChunk) {
            this.addChunk(firstChunk);
        }

        int numChunks() {
            return this.chunks.size();
        }

        ByteString result() {
            return ByteString.copyFrom(this.chunks);
        }

        @Override
        public void accept(Cursor row) {
            byte[] bytes = row.getBlob(0);
            this.addChunk(bytes);
            if (bytes.length < 1000000) {
                this.more = false;
            }
        }

        private void addChunk(byte[] bytes) {
            ByteString wrapped = ByteString.copyFrom((byte[])bytes);
            this.chunks.add(wrapped);
        }
    }
}

