/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentCollections;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.DocumentSet$$Lambda$1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class DocumentSet
implements Iterable<Document> {
    private final ImmutableSortedMap<DocumentKey, Document> keyIndex;
    private final ImmutableSortedSet<Document> sortedSet;

    public static DocumentSet emptySet(Comparator<Document> comparator) {
        Comparator adjustedComparator = DocumentSet$$Lambda$1.lambdaFactory$(comparator);
        return new DocumentSet(DocumentCollections.emptyDocumentMap(), (ImmutableSortedSet<Document>)new ImmutableSortedSet(Collections.emptyList(), adjustedComparator));
    }

    private DocumentSet(ImmutableSortedMap<DocumentKey, Document> keyIndex, ImmutableSortedSet<Document> sortedSet) {
        this.keyIndex = keyIndex;
        this.sortedSet = sortedSet;
    }

    public int size() {
        return this.keyIndex.size();
    }

    public boolean isEmpty() {
        return this.keyIndex.isEmpty();
    }

    public boolean contains(DocumentKey key) {
        return this.keyIndex.containsKey((Object)key);
    }

    @Nullable
    public Document getDocument(DocumentKey key) {
        return (Document)this.keyIndex.get((Object)key);
    }

    @Nullable
    public Document getFirstDocument() {
        return (Document)this.sortedSet.getMinEntry();
    }

    @Nullable
    public Document getLastDocument() {
        return (Document)this.sortedSet.getMaxEntry();
    }

    @Nullable
    public Document getPredecessor(DocumentKey key) {
        Document document = (Document)this.keyIndex.get((Object)key);
        if (document == null) {
            throw new IllegalArgumentException("Key not contained in DocumentSet: " + key);
        }
        return (Document)this.sortedSet.getPredecessorEntry((Object)document);
    }

    public int indexOf(DocumentKey key) {
        Document document = (Document)this.keyIndex.get((Object)key);
        if (document == null) {
            return -1;
        }
        return this.sortedSet.indexOf((Object)document);
    }

    public DocumentSet add(Document document) {
        DocumentSet removed = this.remove(document.getKey());
        ImmutableSortedMap newKeyIndex = removed.keyIndex.insert((Object)document.getKey(), (Object)document);
        ImmutableSortedSet newSortedSet = removed.sortedSet.insert((Object)document);
        return new DocumentSet((ImmutableSortedMap<DocumentKey, Document>)newKeyIndex, (ImmutableSortedSet<Document>)newSortedSet);
    }

    public DocumentSet remove(DocumentKey key) {
        Document document = (Document)this.keyIndex.get((Object)key);
        if (document == null) {
            return this;
        }
        ImmutableSortedMap newKeyIndex = this.keyIndex.remove((Object)key);
        ImmutableSortedSet newSortedSet = this.sortedSet.remove((Object)document);
        return new DocumentSet((ImmutableSortedMap<DocumentKey, Document>)newKeyIndex, (ImmutableSortedSet<Document>)newSortedSet);
    }

    public List<Document> toList() {
        ArrayList<Document> documents = new ArrayList<Document>(this.size());
        for (Document document : this) {
            documents.add(document);
        }
        return documents;
    }

    @Override
    @NonNull
    public Iterator<Document> iterator() {
        return this.sortedSet.iterator();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DocumentSet documentSet = (DocumentSet)other;
        if (this.size() != documentSet.size()) {
            return false;
        }
        Iterator<Document> thisIterator = this.iterator();
        Iterator<Document> otherIterator = documentSet.iterator();
        while (thisIterator.hasNext()) {
            Document otherDoc;
            Document thisDoc = thisIterator.next();
            if (thisDoc.equals(otherDoc = otherIterator.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (Document document : this) {
            result = 31 * result + document.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        boolean first = true;
        for (Document doc : this) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(doc);
        }
        builder.append("]");
        return builder.toString();
    }

    static /* synthetic */ int lambda$emptySet$0(Comparator comparator, Document left, Document right) {
        int comparison = comparator.compare(left, right);
        if (comparison == 0) {
            return Document.keyComparator().compare(left, right);
        }
        return comparison;
    }
}

