/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firebase.firestore.model.value.ObjectValue;
import com.google.firebase.firestore.util.Assert;

public abstract class Mutation {
    private final DocumentKey key;
    private final Precondition precondition;

    Mutation(DocumentKey key, Precondition precondition) {
        this.key = key;
        this.precondition = precondition;
    }

    public DocumentKey getKey() {
        return this.key;
    }

    public Precondition getPrecondition() {
        return this.precondition;
    }

    public abstract MaybeDocument applyToRemoteDocument(@Nullable MaybeDocument var1, MutationResult var2);

    @Nullable
    public abstract MaybeDocument applyToLocalView(@Nullable MaybeDocument var1, @Nullable MaybeDocument var2, Timestamp var3);

    @Nullable
    public abstract ObjectValue extractBaseValue(@Nullable MaybeDocument var1);

    boolean hasSameKeyAndPrecondition(Mutation other) {
        return this.key.equals(other.key) && this.precondition.equals(other.precondition);
    }

    int keyAndPreconditionHashCode() {
        return this.getKey().hashCode() * 31 + this.precondition.hashCode();
    }

    String keyAndPreconditionToString() {
        return "key=" + this.key + ", precondition=" + this.precondition;
    }

    void verifyKeyMatches(@Nullable MaybeDocument maybeDoc) {
        if (maybeDoc != null) {
            Assert.hardAssert(maybeDoc.getKey().equals(this.getKey()), "Can only apply a mutation to a document with the same key", new Object[0]);
        }
    }

    static SnapshotVersion getPostMutationVersion(@Nullable MaybeDocument maybeDoc) {
        if (maybeDoc instanceof Document) {
            return maybeDoc.getVersion();
        }
        return SnapshotVersion.NONE;
    }
}

