/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.value;

import com.google.firebase.firestore.model.value.NumberValue;

public final class DoubleValue
extends NumberValue {
    public static final DoubleValue NaN = new DoubleValue(Double.NaN);
    private final double internalValue;

    private DoubleValue(Double val) {
        this.internalValue = val;
    }

    public static DoubleValue valueOf(Double val) {
        if (Double.isNaN(val)) {
            return NaN;
        }
        return new DoubleValue(val);
    }

    @Override
    public Double value() {
        return this.internalValue;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof DoubleValue && Double.doubleToLongBits(this.internalValue) == Double.doubleToLongBits(((DoubleValue)o).internalValue);
    }

    @Override
    public int hashCode() {
        long bits = Double.doubleToLongBits(this.internalValue);
        return (int)(bits ^ bits >>> 32);
    }

    public double getInternalValue() {
        return this.internalValue;
    }
}

