/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.value;

import androidx.annotation.Nullable;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ObjectValue
extends FieldValue {
    private static final ObjectValue EMPTY_INSTANCE = new ObjectValue((ImmutableSortedMap<String, FieldValue>)ImmutableSortedMap.Builder.emptyMap(Util.comparator()));
    private final ImmutableSortedMap<String, FieldValue> internalValue;

    public static ObjectValue fromMap(Map<String, FieldValue> value) {
        return ObjectValue.fromImmutableMap((ImmutableSortedMap<String, FieldValue>)ImmutableSortedMap.Builder.fromMap(value, Util.comparator()));
    }

    public static ObjectValue fromImmutableMap(ImmutableSortedMap<String, FieldValue> value) {
        if (value.isEmpty()) {
            return EMPTY_INSTANCE;
        }
        return new ObjectValue(value);
    }

    public static ObjectValue emptyObject() {
        return EMPTY_INSTANCE;
    }

    private ObjectValue(ImmutableSortedMap<String, FieldValue> value) {
        this.internalValue = value;
    }

    @Override
    public int typeOrder() {
        return 9;
    }

    public FieldMask getFieldMask() {
        HashSet<FieldPath> fields = new HashSet<FieldPath>();
        for (Map.Entry entry : this.internalValue) {
            FieldPath currentPath = FieldPath.fromSingleSegment((String)entry.getKey());
            FieldValue value = (FieldValue)entry.getValue();
            if (value instanceof ObjectValue) {
                FieldMask nestedMask = ((ObjectValue)value).getFieldMask();
                Set<FieldPath> nestedFields = nestedMask.getMask();
                if (nestedFields.isEmpty()) {
                    fields.add(currentPath);
                    continue;
                }
                for (FieldPath nestedPath : nestedFields) {
                    fields.add(currentPath.append(nestedPath));
                }
                continue;
            }
            fields.add(currentPath);
        }
        return FieldMask.fromSet(fields);
    }

    @Override
    public Map<String, Object> value() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (Map.Entry entry : this.internalValue) {
            res.put((String)entry.getKey(), ((FieldValue)entry.getValue()).value());
        }
        return res;
    }

    public ImmutableSortedMap<String, FieldValue> getInternalValue() {
        return this.internalValue;
    }

    @Override
    public String toString() {
        return this.internalValue.toString();
    }

    @Override
    public int hashCode() {
        return this.internalValue.hashCode();
    }

    @Override
    public int compareTo(FieldValue o) {
        if (o instanceof ObjectValue) {
            ObjectValue other = (ObjectValue)o;
            Iterator iterator1 = this.internalValue.iterator();
            Iterator iterator2 = other.internalValue.iterator();
            while (iterator1.hasNext() && iterator2.hasNext()) {
                Map.Entry entry1 = (Map.Entry)iterator1.next();
                Map.Entry entry2 = (Map.Entry)iterator2.next();
                int keyCompare = ((String)entry1.getKey()).compareTo((String)entry2.getKey());
                if (keyCompare != 0) {
                    return keyCompare;
                }
                int valueCompare = ((FieldValue)entry1.getValue()).compareTo((FieldValue)entry2.getValue());
                if (valueCompare == 0) continue;
                return valueCompare;
            }
            return Util.compareBooleans(iterator1.hasNext(), iterator2.hasNext());
        }
        return this.defaultCompareTo(o);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ObjectValue && this.internalValue.equals(((ObjectValue)other).internalValue);
    }

    public ObjectValue set(FieldPath path, FieldValue value) {
        Assert.hardAssert(!path.isEmpty(), "Cannot set field for empty path on ObjectValue", new Object[0]);
        String childName = path.getFirstSegment();
        if (path.length() == 1) {
            return this.setChild(childName, value);
        }
        FieldValue child = (FieldValue)this.internalValue.get((Object)childName);
        ObjectValue obj = child instanceof ObjectValue ? (ObjectValue)child : ObjectValue.emptyObject();
        ObjectValue newChild = obj.set((FieldPath)path.popFirst(), value);
        return this.setChild(childName, newChild);
    }

    public ObjectValue delete(FieldPath path) {
        Assert.hardAssert(!path.isEmpty(), "Cannot delete field for empty path on ObjectValue", new Object[0]);
        String childName = path.getFirstSegment();
        if (path.length() == 1) {
            return ObjectValue.fromImmutableMap((ImmutableSortedMap<String, FieldValue>)this.internalValue.remove((Object)childName));
        }
        FieldValue child = (FieldValue)this.internalValue.get((Object)childName);
        if (child instanceof ObjectValue) {
            ObjectValue newChild = ((ObjectValue)child).delete((FieldPath)path.popFirst());
            return this.setChild(childName, newChild);
        }
        return this;
    }

    @Nullable
    public FieldValue get(FieldPath fieldPath) {
        FieldValue current = this;
        for (int i = 0; i < fieldPath.length(); ++i) {
            if (!(current instanceof ObjectValue)) {
                return null;
            }
            current = (FieldValue)current.internalValue.get((Object)fieldPath.getSegment(i));
        }
        return current;
    }

    private ObjectValue setChild(String childName, FieldValue value) {
        return ObjectValue.fromImmutableMap((ImmutableSortedMap<String, FieldValue>)this.internalValue.insert((Object)childName, (Object)value));
    }
}

