/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.Timestamp;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.core.TargetIdGenerator;
import com.google.firebase.firestore.local.LocalDocumentsView;
import com.google.firebase.firestore.local.LocalStore$$Lambda$1;
import com.google.firebase.firestore.local.LocalStore$$Lambda$10;
import com.google.firebase.firestore.local.LocalStore$$Lambda$2;
import com.google.firebase.firestore.local.LocalStore$$Lambda$3;
import com.google.firebase.firestore.local.LocalStore$$Lambda$4;
import com.google.firebase.firestore.local.LocalStore$$Lambda$5;
import com.google.firebase.firestore.local.LocalStore$$Lambda$6;
import com.google.firebase.firestore.local.LocalStore$$Lambda$7;
import com.google.firebase.firestore.local.LocalStore$$Lambda$8;
import com.google.firebase.firestore.local.LocalStore$$Lambda$9;
import com.google.firebase.firestore.local.LocalViewChanges;
import com.google.firebase.firestore.local.LocalWriteResult;
import com.google.firebase.firestore.local.LruGarbageCollector;
import com.google.firebase.firestore.local.MutationQueue;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.QueryCache;
import com.google.firebase.firestore.local.QueryData;
import com.google.firebase.firestore.local.QueryEngine;
import com.google.firebase.firestore.local.QueryPurpose;
import com.google.firebase.firestore.local.QueryResult;
import com.google.firebase.firestore.local.ReferenceSet;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.NoDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationBatch;
import com.google.firebase.firestore.model.mutation.MutationBatchResult;
import com.google.firebase.firestore.model.mutation.PatchMutation;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firebase.firestore.model.value.ObjectValue;
import com.google.firebase.firestore.remote.RemoteEvent;
import com.google.firebase.firestore.remote.TargetChange;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Logger;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class LocalStore {
    private static final long RESUME_TOKEN_MAX_AGE_SECONDS = TimeUnit.MINUTES.toSeconds(5L);
    private final Persistence persistence;
    private MutationQueue mutationQueue;
    private final RemoteDocumentCache remoteDocuments;
    private LocalDocumentsView localDocuments;
    private QueryEngine queryEngine;
    private final ReferenceSet localViewReferences;
    private final QueryCache queryCache;
    private final SparseArray<QueryData> queryDataByTarget;
    private final Map<Target, Integer> targetIdByTarget;
    private final TargetIdGenerator targetIdGenerator;

    public LocalStore(Persistence persistence, QueryEngine queryEngine, User initialUser) {
        Assert.hardAssert(persistence.isStarted(), "LocalStore was passed an unstarted persistence implementation", new Object[0]);
        this.persistence = persistence;
        this.queryCache = persistence.getQueryCache();
        this.targetIdGenerator = TargetIdGenerator.forQueryCache(this.queryCache.getHighestTargetId());
        this.mutationQueue = persistence.getMutationQueue(initialUser);
        this.remoteDocuments = persistence.getRemoteDocumentCache();
        this.localDocuments = new LocalDocumentsView(this.remoteDocuments, this.mutationQueue, persistence.getIndexManager());
        this.queryEngine = queryEngine;
        queryEngine.setLocalDocumentsView(this.localDocuments);
        this.localViewReferences = new ReferenceSet();
        persistence.getReferenceDelegate().setInMemoryPins(this.localViewReferences);
        this.queryDataByTarget = new SparseArray();
        this.targetIdByTarget = new HashMap<Target, Integer>();
    }

    public void start() {
        this.startMutationQueue();
    }

    private void startMutationQueue() {
        this.persistence.runTransaction("Start MutationQueue", LocalStore$$Lambda$1.lambdaFactory$(this));
    }

    public ImmutableSortedMap<DocumentKey, MaybeDocument> handleUserChange(User user) {
        List<MutationBatch> oldBatches = this.mutationQueue.getAllMutationBatches();
        this.mutationQueue = this.persistence.getMutationQueue(user);
        this.startMutationQueue();
        List<MutationBatch> newBatches = this.mutationQueue.getAllMutationBatches();
        this.localDocuments = new LocalDocumentsView(this.remoteDocuments, this.mutationQueue, this.persistence.getIndexManager());
        this.queryEngine.setLocalDocumentsView(this.localDocuments);
        ImmutableSortedSet changedKeys = DocumentKey.emptyKeySet();
        for (List batches : Arrays.asList(oldBatches, newBatches)) {
            for (MutationBatch batch : batches) {
                for (Mutation mutation : batch.getMutations()) {
                    changedKeys = changedKeys.insert((Object)mutation.getKey());
                }
            }
        }
        return this.localDocuments.getDocuments((Iterable<DocumentKey>)changedKeys);
    }

    public LocalWriteResult writeLocally(List<Mutation> mutations) {
        Timestamp localWriteTime = Timestamp.now();
        HashSet<DocumentKey> keys = new HashSet<DocumentKey>();
        for (Mutation mutation : mutations) {
            keys.add(mutation.getKey());
        }
        return (LocalWriteResult)this.persistence.runTransaction("Locally write mutations", LocalStore$$Lambda$2.lambdaFactory$(this, keys, mutations, localWriteTime));
    }

    public ImmutableSortedMap<DocumentKey, MaybeDocument> acknowledgeBatch(MutationBatchResult batchResult) {
        return (ImmutableSortedMap)this.persistence.runTransaction("Acknowledge batch", LocalStore$$Lambda$3.lambdaFactory$(this, batchResult));
    }

    public ImmutableSortedMap<DocumentKey, MaybeDocument> rejectBatch(int batchId) {
        return (ImmutableSortedMap)this.persistence.runTransaction("Reject batch", LocalStore$$Lambda$4.lambdaFactory$(this, batchId));
    }

    public int getHighestUnacknowledgedBatchId() {
        return this.mutationQueue.getHighestUnacknowledgedBatchId();
    }

    public ByteString getLastStreamToken() {
        return this.mutationQueue.getLastStreamToken();
    }

    public void setLastStreamToken(ByteString streamToken) {
        this.persistence.runTransaction("Set stream token", LocalStore$$Lambda$5.lambdaFactory$(this, streamToken));
    }

    public SnapshotVersion getLastRemoteSnapshotVersion() {
        return this.queryCache.getLastRemoteSnapshotVersion();
    }

    public ImmutableSortedMap<DocumentKey, MaybeDocument> applyRemoteEvent(RemoteEvent remoteEvent) {
        SnapshotVersion remoteVersion = remoteEvent.getSnapshotVersion();
        return (ImmutableSortedMap)this.persistence.runTransaction("Apply remote event", LocalStore$$Lambda$6.lambdaFactory$(this, remoteEvent, remoteVersion));
    }

    private static boolean shouldPersistQueryData(QueryData oldQueryData, QueryData newQueryData, TargetChange change) {
        long oldSeconds;
        Assert.hardAssert(!newQueryData.getResumeToken().isEmpty(), "Attempted to persist query data with empty resume token", new Object[0]);
        if (oldQueryData.getResumeToken().isEmpty()) {
            return true;
        }
        long newSeconds = newQueryData.getSnapshotVersion().getTimestamp().getSeconds();
        long timeDelta = newSeconds - (oldSeconds = oldQueryData.getSnapshotVersion().getTimestamp().getSeconds());
        if (timeDelta >= RESUME_TOKEN_MAX_AGE_SECONDS) {
            return true;
        }
        int changes = change.getAddedDocuments().size() + change.getModifiedDocuments().size() + change.getRemovedDocuments().size();
        return changes > 0;
    }

    public void notifyLocalViewChanges(List<LocalViewChanges> viewChanges) {
        this.persistence.runTransaction("notifyLocalViewChanges", LocalStore$$Lambda$7.lambdaFactory$(this, viewChanges));
    }

    @Nullable
    public MutationBatch getNextMutationBatch(int afterBatchId) {
        return this.mutationQueue.getNextMutationBatchAfterBatchId(afterBatchId);
    }

    @Nullable
    public MaybeDocument readDocument(DocumentKey key) {
        return this.localDocuments.getDocument(key);
    }

    public QueryData allocateTarget(Target target) {
        int targetId;
        QueryData cached = this.queryCache.getQueryData(target);
        if (cached != null) {
            targetId = cached.getTargetId();
        } else {
            AllocateQueryHolder holder = new AllocateQueryHolder();
            this.persistence.runTransaction("Allocate target", LocalStore$$Lambda$8.lambdaFactory$(this, holder, target));
            targetId = holder.targetId;
            cached = holder.cached;
        }
        if (this.queryDataByTarget.get(targetId) == null) {
            this.queryDataByTarget.put(targetId, (Object)cached);
            this.targetIdByTarget.put(target, targetId);
        }
        return cached;
    }

    @VisibleForTesting
    @Nullable
    QueryData getQueryData(Target target) {
        Integer targetId = this.targetIdByTarget.get(target);
        if (targetId != null) {
            return (QueryData)this.queryDataByTarget.get(targetId.intValue());
        }
        return this.queryCache.getQueryData(target);
    }

    public void releaseTarget(int targetId) {
        this.persistence.runTransaction("Release target", LocalStore$$Lambda$9.lambdaFactory$(this, targetId));
    }

    public QueryResult executeQuery(Query query, boolean usePreviousResults) {
        QueryData queryData = this.getQueryData(query.toTarget());
        SnapshotVersion lastLimboFreeSnapshotVersion = SnapshotVersion.NONE;
        ImmutableSortedSet<DocumentKey> remoteKeys = DocumentKey.emptyKeySet();
        if (queryData != null) {
            lastLimboFreeSnapshotVersion = queryData.getLastLimboFreeSnapshotVersion();
            remoteKeys = this.queryCache.getMatchingKeysForTargetId(queryData.getTargetId());
        }
        ImmutableSortedMap<DocumentKey, Document> documents = this.queryEngine.getDocumentsMatchingQuery(query, usePreviousResults ? lastLimboFreeSnapshotVersion : SnapshotVersion.NONE, usePreviousResults ? remoteKeys : DocumentKey.emptyKeySet());
        return new QueryResult(documents, remoteKeys);
    }

    public ImmutableSortedSet<DocumentKey> getRemoteDocumentKeys(int targetId) {
        return this.queryCache.getMatchingKeysForTargetId(targetId);
    }

    private void applyWriteToRemoteDocuments(MutationBatchResult batchResult) {
        MutationBatch batch = batchResult.getBatch();
        Set<DocumentKey> docKeys = batch.getKeys();
        for (DocumentKey docKey : docKeys) {
            MaybeDocument remoteDoc;
            MaybeDocument doc = remoteDoc = this.remoteDocuments.get(docKey);
            SnapshotVersion ackVersion = (SnapshotVersion)batchResult.getDocVersions().get((Object)docKey);
            Assert.hardAssert(ackVersion != null, "docVersions should contain every doc in the write.", new Object[0]);
            if (doc != null && doc.getVersion().compareTo(ackVersion) >= 0) continue;
            if ((doc = batch.applyToRemoteDocument(docKey, doc, batchResult)) == null) {
                Assert.hardAssert(remoteDoc == null, "Mutation batch %s applied to document %s resulted in null.", batch, remoteDoc);
                continue;
            }
            this.remoteDocuments.add(doc, batchResult.getCommitVersion());
        }
        this.mutationQueue.removeMutationBatch(batch);
    }

    public LruGarbageCollector.Results collectGarbage(LruGarbageCollector garbageCollector) {
        return (LruGarbageCollector.Results)this.persistence.runTransaction("Collect garbage", LocalStore$$Lambda$10.lambdaFactory$(this, garbageCollector));
    }

    static /* synthetic */ LruGarbageCollector.Results lambda$collectGarbage$9(LocalStore this_, LruGarbageCollector garbageCollector) {
        return garbageCollector.collect(this_.queryDataByTarget);
    }

    static /* synthetic */ void lambda$releaseTarget$8(LocalStore this_, int targetId) {
        QueryData queryData = (QueryData)this_.queryDataByTarget.get(targetId);
        Assert.hardAssert(queryData != null, "Tried to release nonexistent target: %s", targetId);
        ImmutableSortedSet<DocumentKey> removedReferences = this_.localViewReferences.removeReferencesForId(targetId);
        for (DocumentKey key : removedReferences) {
            this_.persistence.getReferenceDelegate().removeReference(key);
        }
        this_.persistence.getReferenceDelegate().removeTarget(queryData);
        this_.queryDataByTarget.remove(targetId);
        this_.targetIdByTarget.remove(queryData.getTarget());
    }

    static /* synthetic */ void lambda$allocateTarget$7(LocalStore this_, AllocateQueryHolder holder, Target target) {
        holder.targetId = this_.targetIdGenerator.nextId();
        holder.cached = new QueryData(target, holder.targetId, this_.persistence.getReferenceDelegate().getCurrentSequenceNumber(), QueryPurpose.LISTEN);
        this_.queryCache.addQueryData(holder.cached);
    }

    static /* synthetic */ void lambda$notifyLocalViewChanges$6(LocalStore this_, List viewChanges) {
        for (LocalViewChanges viewChange : viewChanges) {
            int targetId = viewChange.getTargetId();
            this_.localViewReferences.addReferences(viewChange.getAdded(), targetId);
            ImmutableSortedSet<DocumentKey> removed = viewChange.getRemoved();
            for (DocumentKey key : removed) {
                this_.persistence.getReferenceDelegate().removeReference(key);
            }
            this_.localViewReferences.removeReferences(removed, targetId);
            if (viewChange.isFromCache()) continue;
            QueryData queryData = (QueryData)this_.queryDataByTarget.get(targetId);
            Assert.hardAssert(queryData != null, "Can't set limbo-free snapshot version for unknown target: %s", targetId);
            SnapshotVersion lastLimboFreeSnapshotVersion = queryData.getSnapshotVersion();
            QueryData updatedQueryData = queryData.withLastLimboFreeSnapshotVersion(lastLimboFreeSnapshotVersion);
            this_.queryDataByTarget.put(targetId, (Object)updatedQueryData);
        }
    }

    static /* synthetic */ ImmutableSortedMap lambda$applyRemoteEvent$5(LocalStore this_, RemoteEvent remoteEvent, SnapshotVersion remoteVersion) {
        Map<Integer, TargetChange> targetChanges = remoteEvent.getTargetChanges();
        long sequenceNumber = this_.persistence.getReferenceDelegate().getCurrentSequenceNumber();
        for (Map.Entry<Integer, TargetChange> entry : targetChanges.entrySet()) {
            Integer boxedTargetId = entry.getKey();
            int targetId = boxedTargetId;
            TargetChange change = entry.getValue();
            QueryData queryData = (QueryData)this_.queryDataByTarget.get(targetId);
            if (queryData == null) continue;
            this_.queryCache.removeMatchingKeys(change.getRemovedDocuments(), targetId);
            this_.queryCache.addMatchingKeys(change.getAddedDocuments(), targetId);
            ByteString resumeToken = change.getResumeToken();
            if (resumeToken.isEmpty()) continue;
            QueryData newQueryData = queryData.withResumeToken(resumeToken, remoteEvent.getSnapshotVersion()).withSequenceNumber(sequenceNumber);
            this_.queryDataByTarget.put(targetId, (Object)newQueryData);
            if (!LocalStore.shouldPersistQueryData(queryData, newQueryData, change)) continue;
            this_.queryCache.updateQueryData(newQueryData);
        }
        HashMap<DocumentKey, MaybeDocument> changedDocs = new HashMap<DocumentKey, MaybeDocument>();
        Map<DocumentKey, MaybeDocument> documentUpdates = remoteEvent.getDocumentUpdates();
        Set<DocumentKey> limboDocuments = remoteEvent.getResolvedLimboDocuments();
        Map<DocumentKey, MaybeDocument> existingDocs = this_.remoteDocuments.getAll(documentUpdates.keySet());
        for (Map.Entry entry : documentUpdates.entrySet()) {
            DocumentKey key = (DocumentKey)entry.getKey();
            MaybeDocument doc = (MaybeDocument)entry.getValue();
            MaybeDocument existingDoc = existingDocs.get(key);
            if (doc instanceof NoDocument && doc.getVersion().equals(SnapshotVersion.NONE)) {
                this_.remoteDocuments.remove(doc.getKey());
                changedDocs.put(key, doc);
            } else if (existingDoc == null || doc.getVersion().compareTo(existingDoc.getVersion()) > 0 || doc.getVersion().compareTo(existingDoc.getVersion()) == 0 && existingDoc.hasPendingWrites()) {
                Assert.hardAssert(!SnapshotVersion.NONE.equals(remoteEvent.getSnapshotVersion()), "Cannot add a document when the remote version is zero", new Object[0]);
                this_.remoteDocuments.add(doc, remoteEvent.getSnapshotVersion());
                changedDocs.put(key, doc);
            } else {
                Logger.debug("LocalStore", "Ignoring outdated watch update for %s.Current version: %s  Watch version: %s", key, existingDoc.getVersion(), doc.getVersion());
            }
            if (!limboDocuments.contains(key)) continue;
            this_.persistence.getReferenceDelegate().updateLimboDocument(key);
        }
        SnapshotVersion lastRemoteVersion = this_.queryCache.getLastRemoteSnapshotVersion();
        if (!remoteVersion.equals(SnapshotVersion.NONE)) {
            Assert.hardAssert(remoteVersion.compareTo(lastRemoteVersion) >= 0, "Watch stream reverted to previous snapshot?? (%s < %s)", remoteVersion, lastRemoteVersion);
            this_.queryCache.setLastRemoteSnapshotVersion(remoteVersion);
        }
        return this_.localDocuments.getLocalViewOfDocuments(changedDocs);
    }

    static /* synthetic */ void lambda$setLastStreamToken$4(LocalStore this_, ByteString streamToken) {
        this_.mutationQueue.setLastStreamToken(streamToken);
    }

    static /* synthetic */ ImmutableSortedMap lambda$rejectBatch$3(LocalStore this_, int batchId) {
        MutationBatch toReject = this_.mutationQueue.lookupMutationBatch(batchId);
        Assert.hardAssert(toReject != null, "Attempt to reject nonexistent batch!", new Object[0]);
        this_.mutationQueue.removeMutationBatch(toReject);
        this_.mutationQueue.performConsistencyCheck();
        return this_.localDocuments.getDocuments(toReject.getKeys());
    }

    static /* synthetic */ ImmutableSortedMap lambda$acknowledgeBatch$2(LocalStore this_, MutationBatchResult batchResult) {
        MutationBatch batch = batchResult.getBatch();
        this_.mutationQueue.acknowledgeBatch(batch, batchResult.getStreamToken());
        this_.applyWriteToRemoteDocuments(batchResult);
        this_.mutationQueue.performConsistencyCheck();
        return this_.localDocuments.getDocuments(batch.getKeys());
    }

    static /* synthetic */ LocalWriteResult lambda$writeLocally$1(LocalStore this_, Set keys, List mutations, Timestamp localWriteTime) {
        ImmutableSortedMap<DocumentKey, MaybeDocument> existingDocuments = this_.localDocuments.getDocuments(keys);
        ArrayList<Mutation> baseMutations = new ArrayList<Mutation>();
        for (Mutation mutation : mutations) {
            ObjectValue baseValue = mutation.extractBaseValue((MaybeDocument)existingDocuments.get((Object)mutation.getKey()));
            if (baseValue == null) continue;
            baseMutations.add(new PatchMutation(mutation.getKey(), baseValue, baseValue.getFieldMask(), Precondition.exists(true)));
        }
        MutationBatch batch = this_.mutationQueue.addMutationBatch(localWriteTime, baseMutations, mutations);
        ImmutableSortedMap<DocumentKey, MaybeDocument> changedDocuments = batch.applyToLocalDocumentSet(existingDocuments);
        return new LocalWriteResult(batch.getBatchId(), changedDocuments);
    }

    static /* synthetic */ void lambda$startMutationQueue$0(LocalStore this_) {
        this_.mutationQueue.start();
    }

    private static class AllocateQueryHolder {
        QueryData cached;
        int targetId;

        private AllocateQueryHolder() {
        }
    }
}

