/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.MemoryPersistence;
import com.google.firebase.firestore.local.QueryCache;
import com.google.firebase.firestore.local.QueryData;
import com.google.firebase.firestore.local.ReferenceDelegate;
import com.google.firebase.firestore.local.ReferenceSet;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.util.Consumer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class MemoryQueryCache
implements QueryCache {
    private final Map<Target, QueryData> targets = new HashMap<Target, QueryData>();
    private final ReferenceSet references = new ReferenceSet();
    private int highestTargetId;
    private SnapshotVersion lastRemoteSnapshotVersion = SnapshotVersion.NONE;
    private long highestSequenceNumber = 0L;
    private final MemoryPersistence persistence;

    MemoryQueryCache(MemoryPersistence persistence) {
        this.persistence = persistence;
    }

    @Override
    public int getHighestTargetId() {
        return this.highestTargetId;
    }

    @Override
    public long getTargetCount() {
        return this.targets.size();
    }

    @Override
    public void forEachTarget(Consumer<QueryData> consumer) {
        for (QueryData queryData : this.targets.values()) {
            consumer.accept(queryData);
        }
    }

    @Override
    public long getHighestListenSequenceNumber() {
        return this.highestSequenceNumber;
    }

    @Override
    public SnapshotVersion getLastRemoteSnapshotVersion() {
        return this.lastRemoteSnapshotVersion;
    }

    @Override
    public void setLastRemoteSnapshotVersion(SnapshotVersion snapshotVersion) {
        this.lastRemoteSnapshotVersion = snapshotVersion;
    }

    @Override
    public void addQueryData(QueryData queryData) {
        this.targets.put(queryData.getTarget(), queryData);
        int targetId = queryData.getTargetId();
        if (targetId > this.highestTargetId) {
            this.highestTargetId = targetId;
        }
        if (queryData.getSequenceNumber() > this.highestSequenceNumber) {
            this.highestSequenceNumber = queryData.getSequenceNumber();
        }
    }

    @Override
    public void updateQueryData(QueryData queryData) {
        this.addQueryData(queryData);
    }

    @Override
    public void removeQueryData(QueryData queryData) {
        this.targets.remove(queryData.getTarget());
        this.references.removeReferencesForId(queryData.getTargetId());
    }

    int removeQueries(long upperBound, SparseArray<?> activeTargetIds) {
        int removed = 0;
        Iterator<Map.Entry<Target, QueryData>> it = this.targets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Target, QueryData> entry = it.next();
            int targetId = entry.getValue().getTargetId();
            long sequenceNumber = entry.getValue().getSequenceNumber();
            if (sequenceNumber > upperBound || activeTargetIds.get(targetId) != null) continue;
            it.remove();
            this.removeMatchingKeysForTargetId(targetId);
            ++removed;
        }
        return removed;
    }

    @Override
    @Nullable
    public QueryData getQueryData(Target target) {
        return this.targets.get(target);
    }

    @Override
    public void addMatchingKeys(ImmutableSortedSet<DocumentKey> keys, int targetId) {
        this.references.addReferences(keys, targetId);
        ReferenceDelegate referenceDelegate = this.persistence.getReferenceDelegate();
        for (DocumentKey key : keys) {
            referenceDelegate.addReference(key);
        }
    }

    @Override
    public void removeMatchingKeys(ImmutableSortedSet<DocumentKey> keys, int targetId) {
        this.references.removeReferences(keys, targetId);
        ReferenceDelegate referenceDelegate = this.persistence.getReferenceDelegate();
        for (DocumentKey key : keys) {
            referenceDelegate.removeReference(key);
        }
    }

    private void removeMatchingKeysForTargetId(int targetId) {
        this.references.removeReferencesForId(targetId);
    }

    @Override
    public ImmutableSortedSet<DocumentKey> getMatchingKeysForTargetId(int targetId) {
        return this.references.referencesForId(targetId);
    }

    @Override
    public boolean containsKey(DocumentKey key) {
        return this.references.containsKey(key);
    }

    long getByteSize(LocalSerializer serializer) {
        long count = 0L;
        for (Map.Entry<Target, QueryData> entry : this.targets.entrySet()) {
            count += (long)serializer.encodeQueryData(entry.getValue()).getSerializedSize();
        }
        return count;
    }
}

