/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.base.Preconditions;
import com.google.firebase.firestore.DocumentChange;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.Query;
import com.google.firebase.firestore.QueryDocumentSnapshot;
import com.google.firebase.firestore.SnapshotMetadata;
import com.google.firebase.firestore.core.ViewSnapshot;
import com.google.firebase.firestore.model.Document;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class QuerySnapshot
implements Iterable<QueryDocumentSnapshot> {
    private final Query originalQuery;
    private final ViewSnapshot snapshot;
    private final FirebaseFirestore firestore;
    private List<DocumentChange> cachedChanges;
    private MetadataChanges cachedChangesMetadataState;
    private final SnapshotMetadata metadata;

    QuerySnapshot(Query originalQuery, ViewSnapshot snapshot, FirebaseFirestore firestore) {
        this.originalQuery = (Query)Preconditions.checkNotNull((Object)originalQuery);
        this.snapshot = (ViewSnapshot)Preconditions.checkNotNull((Object)snapshot);
        this.firestore = (FirebaseFirestore)Preconditions.checkNotNull((Object)firestore);
        this.metadata = new SnapshotMetadata(snapshot.hasPendingWrites(), snapshot.isFromCache());
    }

    @NonNull
    public Query getQuery() {
        return this.originalQuery;
    }

    @NonNull
    public SnapshotMetadata getMetadata() {
        return this.metadata;
    }

    @NonNull
    public List<DocumentChange> getDocumentChanges() {
        return this.getDocumentChanges(MetadataChanges.EXCLUDE);
    }

    @NonNull
    public List<DocumentChange> getDocumentChanges(@NonNull MetadataChanges metadataChanges) {
        if (MetadataChanges.INCLUDE.equals((Object)metadataChanges) && this.snapshot.excludesMetadataChanges()) {
            throw new IllegalArgumentException("To include metadata changes with your document changes, you must also pass MetadataChanges.INCLUDE to addSnapshotListener().");
        }
        if (this.cachedChanges == null || this.cachedChangesMetadataState != metadataChanges) {
            this.cachedChanges = Collections.unmodifiableList(DocumentChange.changesFromSnapshot(this.firestore, metadataChanges, this.snapshot));
            this.cachedChangesMetadataState = metadataChanges;
        }
        return this.cachedChanges;
    }

    @NonNull
    public List<DocumentSnapshot> getDocuments() {
        ArrayList<DocumentSnapshot> res = new ArrayList<DocumentSnapshot>(this.snapshot.getDocuments().size());
        for (Document doc : this.snapshot.getDocuments()) {
            res.add(this.convertDocument(doc));
        }
        return res;
    }

    public boolean isEmpty() {
        return this.snapshot.getDocuments().isEmpty();
    }

    public int size() {
        return this.snapshot.getDocuments().size();
    }

    @Override
    @NonNull
    public Iterator<QueryDocumentSnapshot> iterator() {
        return new QuerySnapshotIterator(this.snapshot.getDocuments().iterator());
    }

    @NonNull
    public <T> List<T> toObjects(@NonNull Class<T> clazz) {
        return this.toObjects(clazz, DocumentSnapshot.ServerTimestampBehavior.DEFAULT);
    }

    @NonNull
    public <T> List<T> toObjects(@NonNull Class<T> clazz, @NonNull DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior) {
        Preconditions.checkNotNull(clazz, (Object)"Provided POJO type must not be null.");
        ArrayList<T> res = new ArrayList<T>();
        for (DocumentSnapshot d : this) {
            res.add(d.toObject(clazz, serverTimestampBehavior));
        }
        return res;
    }

    private QueryDocumentSnapshot convertDocument(Document document) {
        return QueryDocumentSnapshot.fromDocument(this.firestore, document, this.snapshot.isFromCache(), this.snapshot.getMutatedKeys().contains((Object)document.getKey()));
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QuerySnapshot)) {
            return false;
        }
        QuerySnapshot other = (QuerySnapshot)obj;
        return this.firestore.equals(other.firestore) && this.originalQuery.equals(other.originalQuery) && this.snapshot.equals(other.snapshot) && this.metadata.equals(other.metadata);
    }

    public int hashCode() {
        int hash = this.firestore.hashCode();
        hash = hash * 31 + this.originalQuery.hashCode();
        hash = hash * 31 + this.snapshot.hashCode();
        hash = hash * 31 + this.metadata.hashCode();
        return hash;
    }

    private class QuerySnapshotIterator
    implements Iterator<QueryDocumentSnapshot> {
        private final Iterator<Document> it;

        QuerySnapshotIterator(Iterator<Document> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public QueryDocumentSnapshot next() {
            return QuerySnapshot.this.convertDocument(this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("QuerySnapshot does not support remove().");
        }
    }
}

