/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.RestrictTo;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.model.DatabaseId;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.ServerTimestamps;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Logger;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class UserDataWriter {
    private final FirebaseFirestore firestore;
    private final boolean timestampsInSnapshots;
    private final DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior;

    UserDataWriter(FirebaseFirestore firestore, boolean timestampsInSnapshots, DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior) {
        this.firestore = firestore;
        this.timestampsInSnapshots = timestampsInSnapshots;
        this.serverTimestampBehavior = serverTimestampBehavior;
    }

    Object convertValue(Value value) {
        switch (Values.typeOrder(value)) {
            case 10: {
                return this.convertObject(value.getMapValue().getFieldsMap());
            }
            case 9: {
                return this.convertArray(value.getArrayValue());
            }
            case 7: {
                return this.convertReference(value);
            }
            case 3: {
                return this.convertTimestamp(value.getTimestampValue());
            }
            case 4: {
                return this.convertServerTimestamp(value);
            }
            case 0: {
                return null;
            }
            case 1: {
                return value.getBooleanValue();
            }
            case 2: {
                return value.getValueTypeCase().equals((Object)Value.ValueTypeCase.INTEGER_VALUE) ? (Number)value.getIntegerValue() : (Number)value.getDoubleValue();
            }
            case 5: {
                return value.getStringValue();
            }
            case 6: {
                return Blob.fromByteString(value.getBytesValue());
            }
            case 8: {
                return new GeoPoint(value.getGeoPointValue().getLatitude(), value.getGeoPointValue().getLongitude());
            }
        }
        throw Assert.fail("Unknown value type: " + (Object)((Object)value.getValueTypeCase()), new Object[0]);
    }

    Map<String, Object> convertObject(Map<String, Value> mapValue) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Value> entry : mapValue.entrySet()) {
            result.put(entry.getKey(), this.convertValue(entry.getValue()));
        }
        return result;
    }

    private Object convertServerTimestamp(Value serverTimestampValue) {
        switch (this.serverTimestampBehavior) {
            case PREVIOUS: {
                Value previousValue = ServerTimestamps.getPreviousValue(serverTimestampValue);
                if (previousValue == null) {
                    return null;
                }
                return this.convertValue(previousValue);
            }
            case ESTIMATE: {
                return this.convertTimestamp(ServerTimestamps.getLocalWriteTime(serverTimestampValue));
            }
        }
        return null;
    }

    private Object convertTimestamp(com.google.protobuf.Timestamp value) {
        Timestamp timestamp = new Timestamp(value.getSeconds(), value.getNanos());
        if (this.timestampsInSnapshots) {
            return timestamp;
        }
        return timestamp.toDate();
    }

    private List<Object> convertArray(ArrayValue arrayValue) {
        ArrayList<Object> result = new ArrayList<Object>(arrayValue.getValuesCount());
        for (Value v : arrayValue.getValuesList()) {
            result.add(this.convertValue(v));
        }
        return result;
    }

    private Object convertReference(Value value) {
        DatabaseId refDatabase = DatabaseId.fromName(value.getReferenceValue());
        DocumentKey key = DocumentKey.fromName(value.getReferenceValue());
        DatabaseId database = this.firestore.getDatabaseId();
        if (!refDatabase.equals(database)) {
            Logger.warn("DocumentSnapshot", "Document %s contains a document reference within a different database (%s/%s) which is not supported. It will be treated as a reference in the current database (%s/%s) instead.", key.getPath(), refDatabase.getProjectId(), refDatabase.getDatabaseId(), database.getProjectId(), database.getDatabaseId());
        }
        return new DocumentReference(key, this.firestore);
    }
}

