/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.auth;

import android.annotation.SuppressLint;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.internal.IdTokenListener;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.auth.FirebaseAuthCredentialsProvider$$Lambda$1;
import com.google.firebase.firestore.auth.FirebaseAuthCredentialsProvider$$Lambda$2;
import com.google.firebase.firestore.auth.FirebaseAuthCredentialsProvider$$Lambda$3;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Listener;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.inject.Deferred;
import com.google.firebase.inject.Provider;
import com.google.firebase.internal.InternalTokenResult;

public final class FirebaseAuthCredentialsProvider
extends CredentialsProvider {
    private static final String LOG_TAG = "FirebaseAuthCredentialsProvider";
    private final IdTokenListener idTokenListener = FirebaseAuthCredentialsProvider$$Lambda$1.lambdaFactory$(this);
    @Nullable
    @GuardedBy(value="this")
    private InternalAuthProvider internalAuthProvider;
    @Nullable
    @GuardedBy(value="this")
    private Listener<User> changeListener;
    @GuardedBy(value="this")
    private int tokenCounter;
    @GuardedBy(value="this")
    private boolean forceRefresh;

    @SuppressLint(value={"ProviderAssignment"})
    public FirebaseAuthCredentialsProvider(Deferred<InternalAuthProvider> deferredAuthProvider) {
        deferredAuthProvider.whenAvailable(FirebaseAuthCredentialsProvider$$Lambda$2.lambdaFactory$(this));
    }

    @Override
    public synchronized Task<String> getToken() {
        if (this.internalAuthProvider == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("auth is not available"));
        }
        Task res = this.internalAuthProvider.getAccessToken(this.forceRefresh);
        this.forceRefresh = false;
        int savedCounter = this.tokenCounter;
        return res.continueWithTask(Executors.DIRECT_EXECUTOR, FirebaseAuthCredentialsProvider$$Lambda$3.lambdaFactory$(this, savedCounter));
    }

    @Override
    public synchronized void invalidateToken() {
        this.forceRefresh = true;
    }

    @Override
    public synchronized void setChangeListener(@NonNull Listener<User> changeListener) {
        this.changeListener = changeListener;
        changeListener.onValue(this.getUser());
    }

    @Override
    public synchronized void removeChangeListener() {
        this.changeListener = null;
        if (this.internalAuthProvider != null) {
            this.internalAuthProvider.removeIdTokenListener(this.idTokenListener);
        }
    }

    private synchronized void onIdTokenChanged() {
        ++this.tokenCounter;
        if (this.changeListener != null) {
            this.changeListener.onValue(this.getUser());
        }
    }

    private synchronized User getUser() {
        String uid = this.internalAuthProvider == null ? null : this.internalAuthProvider.getUid();
        return uid != null ? new User(uid) : User.UNAUTHENTICATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ Task lambda$getToken$2(FirebaseAuthCredentialsProvider this_, int savedCounter, Task task) throws Exception {
        FirebaseAuthCredentialsProvider firebaseAuthCredentialsProvider = this_;
        synchronized (firebaseAuthCredentialsProvider) {
            if (savedCounter != this_.tokenCounter) {
                Logger.debug(LOG_TAG, "getToken aborted due to token change", new Object[0]);
                return this_.getToken();
            }
            if (task.isSuccessful()) {
                return Tasks.forResult((Object)((GetTokenResult)task.getResult()).getToken());
            }
            return Tasks.forException((Exception)task.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void lambda$new$1(FirebaseAuthCredentialsProvider this_, Provider provider) {
        FirebaseAuthCredentialsProvider firebaseAuthCredentialsProvider = this_;
        synchronized (firebaseAuthCredentialsProvider) {
            this_.internalAuthProvider = (InternalAuthProvider)provider.get();
            this_.onIdTokenChanged();
            this_.internalAuthProvider.addIdTokenListener(this_.idTokenListener);
        }
    }

    static /* synthetic */ void lambda$new$0(FirebaseAuthCredentialsProvider this_, InternalTokenResult result) {
        this_.onIdTokenChanged();
    }
}

