/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import androidx.annotation.NonNull;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.util.Assert;

public final class DatabaseId
implements Comparable<DatabaseId> {
    public static final String DEFAULT_DATABASE_ID = "(default)";
    private final String projectId;
    private final String databaseId;

    public static DatabaseId forProject(String projectId) {
        return DatabaseId.forDatabase(projectId, DEFAULT_DATABASE_ID);
    }

    public static DatabaseId forDatabase(String projectId, String databaseId) {
        return new DatabaseId(projectId, databaseId);
    }

    private DatabaseId(String projectId, String databaseId) {
        this.projectId = projectId;
        this.databaseId = databaseId;
    }

    public static DatabaseId fromName(String name) {
        ResourcePath resourceName = ResourcePath.fromString(name);
        Assert.hardAssert(resourceName.length() >= 3 && resourceName.getSegment(0).equals("projects") && resourceName.getSegment(2).equals("databases"), "Tried to parse an invalid resource name: %s", resourceName);
        return new DatabaseId(resourceName.getSegment(1), resourceName.getSegment(3));
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String toString() {
        return "DatabaseId(" + this.projectId + ", " + this.databaseId + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseId that = (DatabaseId)o;
        return this.projectId.equals(that.projectId) && this.databaseId.equals(that.databaseId);
    }

    public int hashCode() {
        int result = this.projectId.hashCode();
        result = 31 * result + this.databaseId.hashCode();
        return result;
    }

    @Override
    public int compareTo(@NonNull DatabaseId other) {
        int cmp = this.projectId.compareTo(other.projectId);
        return cmp != 0 ? cmp : this.databaseId.compareTo(other.databaseId);
    }
}

