/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.index;

import com.google.firebase.firestore.index.IntMath;
import com.google.protobuf.ByteString;
import java.math.RoundingMode;
import java.util.Arrays;

public class OrderedCodeWriter {
    public static final byte ESCAPE1 = 0;
    public static final byte NULL_BYTE = -1;
    public static final byte SEPARATOR = 1;
    public static final byte ESCAPE2 = -1;
    public static final byte INFINITY = -1;
    public static final byte FF_BYTE = 0;
    public static final long DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    public static final long DOUBLE_ALL_BITS = -1L;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final byte[][] LENGTH_TO_HEADER_BITS = new byte[][]{{0, 0}, {-128, 0}, {-64, 0}, {-32, 0}, {-16, 0}, {-8, 0}, {-4, 0}, {-2, 0}, {-1, 0}, {-1, -128}, {-1, -64}};
    private byte[] buffer = new byte[1024];
    private int position = 0;

    public void writeBytesAscending(ByteString value) {
        for (int i = 0; i < value.size(); ++i) {
            this.writeByteAscending(value.byteAt(i));
        }
        this.writeSeparatorAscending();
    }

    public void writeBytesDescending(ByteString value) {
        for (int i = 0; i < value.size(); ++i) {
            this.writeByteDescending(value.byteAt(i));
        }
        this.writeSeparatorDescending();
    }

    public void writeUtf8Ascending(CharSequence sequence) {
        int utf16Length = sequence.length();
        for (int i = 0; i < utf16Length; ++i) {
            char c = sequence.charAt(i);
            if (c < '\u0080') {
                this.writeByteAscending((byte)c);
                continue;
            }
            if (c < '\u0800') {
                this.writeByteAscending((byte)(0x3C0 | c >>> 6));
                this.writeByteAscending((byte)(0x80 | 0x3F & c));
                continue;
            }
            if (c < '\ud800' || '\udfff' < c) {
                this.writeByteAscending((byte)(0x1E0 | c >>> 12));
                this.writeByteAscending((byte)(0x80 | 0x3F & c >>> 6));
                this.writeByteAscending((byte)(0x80 | 0x3F & c));
                continue;
            }
            int codePoint = Character.codePointAt(sequence, i);
            ++i;
            this.writeByteAscending((byte)(0xF0 | codePoint >>> 18));
            this.writeByteAscending((byte)(0x80 | 0x3F & codePoint >>> 12));
            this.writeByteAscending((byte)(0x80 | 0x3F & codePoint >>> 6));
            this.writeByteAscending((byte)(0x80 | 0x3F & codePoint));
        }
        this.writeSeparatorAscending();
    }

    public void writeUtf8Descending(CharSequence sequence) {
        int utf16Length = sequence.length();
        for (int i = 0; i < utf16Length; ++i) {
            char c = sequence.charAt(i);
            if (c < '\u0080') {
                this.writeByteDescending((byte)c);
                continue;
            }
            if (c < '\u0800') {
                this.writeByteDescending((byte)(0x3C0 | c >>> 6));
                this.writeByteDescending((byte)(0x80 | 0x3F & c));
                continue;
            }
            if (c < '\ud800' || '\udfff' < c) {
                this.writeByteDescending((byte)(0x1E0 | c >>> 12));
                this.writeByteDescending((byte)(0x80 | 0x3F & c >>> 6));
                this.writeByteDescending((byte)(0x80 | 0x3F & c));
                continue;
            }
            int codePoint = Character.codePointAt(sequence, i);
            ++i;
            this.writeByteDescending((byte)(0xF0 | codePoint >>> 18));
            this.writeByteDescending((byte)(0x80 | 0x3F & codePoint >>> 12));
            this.writeByteDescending((byte)(0x80 | 0x3F & codePoint >>> 6));
            this.writeByteDescending((byte)(0x80 | 0x3F & codePoint));
        }
        this.writeSeparatorDescending();
    }

    public void writeUnsignedLongAscending(long value) {
        int len = this.unsignedNumLength(value);
        this.ensureAvailable(1 + len);
        this.buffer[this.position++] = (byte)len;
        for (int i = this.position + len - 1; i >= this.position; --i) {
            this.buffer[i] = (byte)(value & 0xFFL);
            value >>>= 8;
        }
        this.position += len;
    }

    public void writeUnsignedLongDescending(long value) {
        int len = this.unsignedNumLength(value);
        this.ensureAvailable(1 + len);
        this.buffer[this.position++] = (byte)(~len);
        for (int i = this.position + len - 1; i >= this.position; --i) {
            this.buffer[i] = (byte)(value & 0xFFL ^ 0xFFFFFFFFFFFFFFFFL);
            value >>>= 8;
        }
        this.position += len;
    }

    public void writeSignedLongAscending(long value) {
        long val;
        long l = val = value < 0L ? value ^ 0xFFFFFFFFFFFFFFFFL : value;
        if (val < 64L) {
            this.ensureAvailable(1);
            this.buffer[this.position++] = (byte)((long)LENGTH_TO_HEADER_BITS[1][0] ^ value);
            return;
        }
        int len = this.signedNumLength(val);
        this.ensureAvailable(len);
        if (len < 2) {
            throw new AssertionError((Object)String.format("Invalid length (%d) returned by signedNumLength", len));
        }
        int signByte = value < 0L ? -1 : 0;
        int startIndex = this.position;
        if (len == 10) {
            startIndex += 2;
            this.buffer[this.position] = signByte;
            this.buffer[this.position + 1] = signByte;
        } else if (len == 9) {
            ++startIndex;
            this.buffer[this.position] = signByte;
        }
        long x = value;
        for (int i = len - 1 + this.position; i >= startIndex; --i) {
            this.buffer[i] = (byte)(x & 0xFFL);
            x >>= 8;
        }
        int n = this.position;
        this.buffer[n] = (byte)(this.buffer[n] ^ LENGTH_TO_HEADER_BITS[len][0]);
        int n2 = this.position + 1;
        this.buffer[n2] = (byte)(this.buffer[n2] ^ LENGTH_TO_HEADER_BITS[len][1]);
        this.position += len;
    }

    public void writeSignedLongDescending(long value) {
        this.writeSignedLongAscending(value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void writeDoubleAscending(double val) {
        long v;
        this.writeUnsignedLongAscending(v ^= (v = Double.doubleToLongBits(val)) < 0L ? -1L : Long.MIN_VALUE);
    }

    public void writeDoubleDescending(double val) {
        long v;
        this.writeUnsignedLongDescending(v ^= (v = Double.doubleToLongBits(val)) < 0L ? -1L : Long.MIN_VALUE);
    }

    public void reset() {
        this.position = 0;
    }

    public byte[] encodedBytes() {
        return Arrays.copyOf(this.buffer, this.position);
    }

    private void writeByteAscending(byte b) {
        if (b == 0) {
            this.writeEscapedByteAscending((byte)0);
            this.writeEscapedByteAscending((byte)-1);
        } else if (b == -1) {
            this.writeEscapedByteAscending((byte)-1);
            this.writeEscapedByteAscending((byte)0);
        } else {
            this.writeEscapedByteAscending(b);
        }
    }

    private void writeByteDescending(byte b) {
        if (b == 0) {
            this.writeEscapedByteDescending((byte)0);
            this.writeEscapedByteDescending((byte)-1);
        } else if (b == -1) {
            this.writeEscapedByteDescending((byte)-1);
            this.writeEscapedByteDescending((byte)0);
        } else {
            this.writeEscapedByteDescending(b);
        }
    }

    private void writeSeparatorAscending() {
        this.writeEscapedByteAscending((byte)0);
        this.writeEscapedByteAscending((byte)1);
    }

    private void writeSeparatorDescending() {
        this.writeEscapedByteDescending((byte)0);
        this.writeEscapedByteDescending((byte)1);
    }

    private void writeEscapedByteAscending(byte b) {
        this.ensureAvailable(1);
        this.buffer[this.position++] = b;
    }

    private void writeEscapedByteDescending(byte b) {
        this.ensureAvailable(1);
        this.buffer[this.position++] = ~b;
    }

    private void ensureAvailable(int bytes) {
        int minCapacity = bytes + this.position;
        if (minCapacity <= this.buffer.length) {
            return;
        }
        int newLength = this.buffer.length * 2;
        if (newLength < minCapacity) {
            newLength = minCapacity;
        }
        this.buffer = Arrays.copyOf(this.buffer, newLength);
    }

    private int signedNumLength(long n) {
        if (n < 0L) {
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        int numBits = 64 - Long.numberOfLeadingZeros(n);
        int bitsPerEncodedByte = 7;
        return IntMath.divide(++numBits, bitsPerEncodedByte, RoundingMode.UP);
    }

    private int unsignedNumLength(long value) {
        int numBits = 64 - Long.numberOfLeadingZeros(value);
        return IntMath.divide(numBits, 8, RoundingMode.UP);
    }

    public void seed(byte[] encodedBytes) {
        this.ensureAvailable(encodedBytes.length);
        for (byte b : encodedBytes) {
            this.buffer[this.position++] = b;
        }
    }
}

