/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import com.google.firebase.firestore.core.Bound;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.index.FirestoreIndexValueWriter;
import com.google.firebase.firestore.index.IndexByteEncoder;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.MemoryIndexManager;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.TargetIndexMatcher;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Util;
import com.google.firestore.admin.v1.Index;
import com.google.firestore.v1.Value;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class SQLiteIndexManager
implements IndexManager {
    private static final String TAG = SQLiteIndexManager.class.getSimpleName();
    private final MemoryIndexManager.MemoryCollectionParentIndex collectionParentsCache = new MemoryIndexManager.MemoryCollectionParentIndex();
    private final SQLitePersistence db;
    private final LocalSerializer serializer;

    SQLiteIndexManager(SQLitePersistence persistence, LocalSerializer serializer) {
        this.db = persistence;
        this.serializer = serializer;
    }

    @Override
    public void addToCollectionParentIndex(ResourcePath collectionPath) {
        Assert.hardAssert(collectionPath.length() % 2 == 1, "Expected a collection path.", new Object[0]);
        if (this.collectionParentsCache.add(collectionPath)) {
            String collectionId = collectionPath.getLastSegment();
            ResourcePath parentPath = (ResourcePath)collectionPath.popLast();
            this.db.execute("INSERT OR REPLACE INTO collection_parents (collection_id, parent) VALUES (?, ?)", collectionId, EncodedPath.encode(parentPath));
        }
    }

    @Override
    public List<ResourcePath> getCollectionParents(String collectionId) {
        ArrayList<ResourcePath> parentPaths = new ArrayList<ResourcePath>();
        this.db.query("SELECT parent FROM collection_parents WHERE collection_id = ?").binding(collectionId).forEach(row -> parentPaths.add(EncodedPath.decodeResourcePath(row.getString(0))));
        return parentPaths;
    }

    @Override
    public void addFieldIndex(FieldIndex index) {
        int currentMax = (Integer)this.db.query("SELECT MAX(index_id) FROM index_configuration").firstValue(input -> input.isNull(0) ? 0 : input.getInt(0));
        this.db.execute("INSERT OR IGNORE INTO index_configuration (index_id, collection_group, index_proto, active, update_time_seconds, update_time_nanos) VALUES(?, ?, ?, ?, ?, ?)", currentMax + 1, index.getCollectionGroup(), this.encodeFieldIndex(index), true, index.getVersion().getTimestamp().getSeconds(), index.getVersion().getTimestamp().getNanoseconds());
    }

    @Override
    public void addIndexEntries(Document document) {
        DocumentKey documentKey = document.getKey();
        String collectionGroup = documentKey.getCollectionGroup();
        this.db.query("SELECT index_id, index_proto, update_time_seconds, update_time_nanos FROM index_configuration WHERE collection_group = ? AND active = 1").binding(collectionGroup).forEach(row -> {
            try {
                Object[] encodeValues;
                int indexId = row.getInt(0);
                FieldIndex fieldIndex = this.serializer.decodeFieldIndex(collectionGroup, row.getInt(0), Index.parseFrom(row.getBlob(1)), row.getInt(2), row.getInt(3));
                List<Value> values = this.extractFieldValue(document, fieldIndex);
                if (values == null) {
                    return;
                }
                if (Logger.isDebugEnabled()) {
                    Logger.debug(TAG, "Adding index values for document '%s' to index '%s'", documentKey, fieldIndex);
                }
                for (Object encoded : encodeValues = this.encodeDocumentValues(fieldIndex, values)) {
                    this.db.execute("INSERT OR IGNORE INTO index_entries (index_id, index_value, document_name) VALUES(?, ?, ?)", indexId, encoded, documentKey.toString());
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw Assert.fail("Invalid index: " + (Object)((Object)e), new Object[0]);
            }
        });
    }

    @Nullable
    private List<Value> extractFieldValue(Document document, FieldIndex fieldIndex) {
        ArrayList<Value> values = new ArrayList<Value>();
        for (FieldIndex.Segment segment : fieldIndex) {
            Value field = document.getField(segment.getFieldPath());
            if (field == null) {
                return null;
            }
            values.add(field);
        }
        return values;
    }

    @Override
    @Nullable
    public Set<DocumentKey> getDocumentsMatchingTarget(Target target) {
        SQLitePersistence.Query query;
        String lowerBoundOp;
        FieldIndex fieldIndex = this.getMatchingIndex(target);
        if (fieldIndex == null) {
            return null;
        }
        Bound lowerBound = target.getLowerBound(fieldIndex);
        Bound upperBound = target.getUpperBound(fieldIndex);
        if (Logger.isDebugEnabled()) {
            Logger.debug(TAG, "Using index '%s' to execute '%s' (Lower bound: %s, Upper bound: %s)", fieldIndex, target, lowerBound, upperBound);
        }
        HashSet<DocumentKey> result = new HashSet<DocumentKey>();
        Object[] lowerBoundValues = this.encodeTargetValues(fieldIndex, target, lowerBound.getPosition());
        String string = lowerBoundOp = lowerBound.isInclusive() ? ">=" : ">";
        if (upperBound != null) {
            Object[] upperBoundValues = this.encodeTargetValues(fieldIndex, target, upperBound.getPosition());
            String upperBoundOp = upperBound.isInclusive() ? "<=" : "<";
            query = this.generateQuery(fieldIndex.getIndexId(), lowerBoundValues, lowerBoundOp, upperBoundValues, upperBoundOp);
        } else {
            query = this.generateQuery(fieldIndex.getIndexId(), lowerBoundValues, lowerBoundOp);
        }
        query.forEach(row -> result.add(DocumentKey.fromPath(ResourcePath.fromString(row.getString(0)))));
        Logger.debug(TAG, "Index scan returned %s documents", result.size());
        return result;
    }

    private SQLitePersistence.Query generateQuery(int indexId, Object[] bounds, String op) {
        String statement = String.format("SELECT document_name FROM index_entries WHERE index_id = ? AND index_value %s ?", op);
        String sql = Util.repeatSequence(statement, bounds.length, " UNION ");
        Object[] bingArgs = new Object[bounds.length * 2];
        for (int i = 0; i < bounds.length; ++i) {
            bingArgs[i * 2] = indexId;
            bingArgs[i * 2 + 1] = bounds[i];
        }
        return this.db.query(sql).binding(bingArgs);
    }

    private SQLitePersistence.Query generateQuery(int indexId, Object[] lowerBounds, String lowerBoundOp, Object[] upperBounds, String upperBoundOp) {
        String statement = String.format("SELECT document_name FROM index_entries WHERE index_id = ? AND index_value %s ? AND index_value %s ?", lowerBoundOp, upperBoundOp);
        String sql = Util.repeatSequence(statement, lowerBounds.length * upperBounds.length, " UNION ");
        Object[] bingArgs = new Object[lowerBounds.length * upperBounds.length * 3];
        int i = 0;
        for (Object value1 : lowerBounds) {
            for (Object value2 : upperBounds) {
                bingArgs[i++] = indexId;
                bingArgs[i++] = value1;
                bingArgs[i++] = value2;
            }
        }
        return this.db.query(sql).binding(bingArgs);
    }

    @Nullable
    private FieldIndex getMatchingIndex(Target target) {
        TargetIndexMatcher targetIndexMatcher = new TargetIndexMatcher(target);
        String collectionGroup = target.getCollectionGroup() != null ? target.getCollectionGroup() : target.getPath().getLastSegment();
        ArrayList activeIndices = new ArrayList();
        this.db.query("SELECT index_id, index_proto, update_time_seconds, update_time_nanos FROM index_configuration WHERE collection_group = ? AND active = 1").binding(collectionGroup).forEach(row -> {
            try {
                FieldIndex fieldIndex = this.serializer.decodeFieldIndex(collectionGroup, row.getInt(0), Index.parseFrom(row.getBlob(1)), row.getInt(2), row.getInt(3));
                boolean matches = targetIndexMatcher.servedByIndex(fieldIndex);
                if (matches) {
                    activeIndices.add(fieldIndex);
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw Assert.fail("Failed to decode index: " + (Object)((Object)e), new Object[0]);
            }
        });
        if (activeIndices.isEmpty()) {
            return null;
        }
        return (FieldIndex)Collections.max(activeIndices, (l, r) -> Integer.compare(l.segmentCount(), r.segmentCount()));
    }

    private Object[] encodeDocumentValues(FieldIndex fieldIndex, List<Value> values) {
        List<IndexByteEncoder> encoders = new ArrayList<IndexByteEncoder>();
        encoders.add(new IndexByteEncoder());
        for (int i = 0; i < fieldIndex.segmentCount(); ++i) {
            FieldIndex.Segment segment = fieldIndex.getSegment(i);
            Value value = values.get(i);
            for (IndexByteEncoder encoder : encoders) {
                if (segment.getKind() == FieldIndex.Segment.Kind.CONTAINS) {
                    encoders = this.expandIndexValues(encoders, value);
                    continue;
                }
                Assert.hardAssert(segment.getKind() == FieldIndex.Segment.Kind.ORDERED, "Only ORDERED and CONTAINS are supported", new Object[0]);
                FirestoreIndexValueWriter.INSTANCE.writeIndexValue(value, encoder);
            }
        }
        return this.getEncodedBytes(encoders);
    }

    private Object[] encodeTargetValues(FieldIndex fieldIndex, Target target, List<Value> values) {
        List<IndexByteEncoder> encoders = new ArrayList<IndexByteEncoder>();
        encoders.add(new IndexByteEncoder());
        for (int i = 0; i < fieldIndex.segmentCount(); ++i) {
            FieldIndex.Segment segment = fieldIndex.getSegment(i);
            Value value = values.get(i);
            for (IndexByteEncoder encoder : encoders) {
                if (this.isMultiValueFilter(target, segment.getFieldPath())) {
                    encoders = this.expandIndexValues(encoders, value);
                    continue;
                }
                FirestoreIndexValueWriter.INSTANCE.writeIndexValue(value, encoder);
            }
        }
        return this.getEncodedBytes(encoders);
    }

    private Object[] getEncodedBytes(List<IndexByteEncoder> encoders) {
        Object[] result = new Object[encoders.size()];
        for (int i = 0; i < encoders.size(); ++i) {
            result[i] = encoders.get(i).getEncodedBytes();
        }
        return result;
    }

    private List<IndexByteEncoder> expandIndexValues(List<IndexByteEncoder> encoders, Value value) {
        ArrayList<IndexByteEncoder> prefixes = new ArrayList<IndexByteEncoder>(encoders);
        ArrayList<IndexByteEncoder> results = new ArrayList<IndexByteEncoder>();
        for (Value arrayElement : value.getArrayValue().getValuesList()) {
            for (IndexByteEncoder prefix : prefixes) {
                IndexByteEncoder clonedEncoder = new IndexByteEncoder();
                clonedEncoder.seed(prefix.getEncodedBytes());
                FirestoreIndexValueWriter.INSTANCE.writeIndexValue(arrayElement, clonedEncoder);
                results.add(clonedEncoder);
            }
        }
        return results;
    }

    private boolean isMultiValueFilter(Target target, FieldPath fieldPath) {
        for (Filter filter : target.getFilters()) {
            if (!filter.getField().equals(fieldPath)) continue;
            switch (((FieldFilter)filter).getOperator()) {
                case ARRAY_CONTAINS_ANY: 
                case NOT_IN: 
                case IN: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private byte[] encodeFieldIndex(FieldIndex fieldIndex) {
        return this.serializer.encodeFieldIndex(fieldIndex).toByteArray();
    }

    public List<FieldIndex> getFieldIndexes() {
        ArrayList<FieldIndex> allIndexes = new ArrayList<FieldIndex>();
        this.db.query("SELECT index_id, collection_group, index_proto, update_time_seconds, update_time_nanos FROM index_configuration WHERE active = 1").forEach(row -> {
            try {
                allIndexes.add(this.serializer.decodeFieldIndex(row.getString(1), row.getInt(0), Index.parseFrom(row.getBlob(2)), row.getInt(3), row.getInt(4)));
            }
            catch (InvalidProtocolBufferException e) {
                throw Assert.fail("Failed to decode index: " + (Object)((Object)e), new Object[0]);
            }
        });
        return allIndexes;
    }
}

