/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.bundle;

import androidx.annotation.Nullable;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.LoadBundleTaskProgress;
import com.google.firebase.firestore.bundle.BundleCallback;
import com.google.firebase.firestore.bundle.BundleDocument;
import com.google.firebase.firestore.bundle.BundleElement;
import com.google.firebase.firestore.bundle.BundleMetadata;
import com.google.firebase.firestore.bundle.BundledDocumentMetadata;
import com.google.firebase.firestore.bundle.NamedQuery;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentCollections;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BundleLoader {
    private final BundleCallback bundleCallback;
    private final BundleMetadata bundleMetadata;
    private final List<NamedQuery> queries;
    private final Map<DocumentKey, BundledDocumentMetadata> documentsMetadata;
    private ImmutableSortedMap<DocumentKey, MutableDocument> documents;
    private long bytesLoaded;
    @Nullable
    private BundledDocumentMetadata currentMetadata;

    public BundleLoader(BundleCallback bundleCallback, BundleMetadata bundleMetadata) {
        this.bundleCallback = bundleCallback;
        this.bundleMetadata = bundleMetadata;
        this.queries = new ArrayList<NamedQuery>();
        this.documents = DocumentCollections.emptyMutableDocumentMap();
        this.documentsMetadata = new HashMap<DocumentKey, BundledDocumentMetadata>();
    }

    @Nullable
    public LoadBundleTaskProgress addElement(BundleElement bundleElement, long byteSize) {
        Preconditions.checkArgument(!(bundleElement instanceof BundleMetadata), "Unexpected bundle metadata element.", new Object[0]);
        int beforeDocumentCount = this.documents.size();
        if (bundleElement instanceof NamedQuery) {
            this.queries.add((NamedQuery)bundleElement);
        } else if (bundleElement instanceof BundledDocumentMetadata) {
            BundledDocumentMetadata bundledDocumentMetadata = (BundledDocumentMetadata)bundleElement;
            this.documentsMetadata.put(bundledDocumentMetadata.getKey(), bundledDocumentMetadata);
            this.currentMetadata = bundledDocumentMetadata;
            if (!((BundledDocumentMetadata)bundleElement).exists()) {
                this.documents = this.documents.insert((Object)bundledDocumentMetadata.getKey(), (Object)MutableDocument.newNoDocument(bundledDocumentMetadata.getKey(), bundledDocumentMetadata.getReadTime()).setReadTime(bundledDocumentMetadata.getReadTime()));
                this.currentMetadata = null;
            }
        } else if (bundleElement instanceof BundleDocument) {
            BundleDocument bundleDocument = (BundleDocument)bundleElement;
            if (this.currentMetadata == null || !bundleDocument.getKey().equals(this.currentMetadata.getKey())) {
                throw new IllegalArgumentException("The document being added does not match the stored metadata.");
            }
            this.documents = this.documents.insert((Object)bundleDocument.getKey(), (Object)bundleDocument.getDocument().setReadTime(this.currentMetadata.getReadTime()));
            this.currentMetadata = null;
        }
        this.bytesLoaded += byteSize;
        return beforeDocumentCount != this.documents.size() ? new LoadBundleTaskProgress(this.documents.size(), this.bundleMetadata.getTotalDocuments(), this.bytesLoaded, this.bundleMetadata.getTotalBytes(), null, LoadBundleTaskProgress.TaskState.RUNNING) : null;
    }

    public ImmutableSortedMap<DocumentKey, Document> applyChanges() {
        Preconditions.checkArgument(this.currentMetadata == null, "Bundled documents end with a document metadata element instead of a document.", new Object[0]);
        Preconditions.checkArgument(this.bundleMetadata.getBundleId() != null, "Bundle ID must be set", new Object[0]);
        Preconditions.checkArgument(this.documents.size() == this.bundleMetadata.getTotalDocuments(), "Expected %s documents, but loaded %s.", this.bundleMetadata.getTotalDocuments(), this.documents.size());
        ImmutableSortedMap<DocumentKey, Document> changes = this.bundleCallback.applyBundledDocuments(this.documents, this.bundleMetadata.getBundleId());
        Map<String, ImmutableSortedSet<DocumentKey>> queryDocumentMap = this.getQueryDocumentMapping();
        for (NamedQuery namedQuery : this.queries) {
            this.bundleCallback.saveNamedQuery(namedQuery, queryDocumentMap.get(namedQuery.getName()));
        }
        this.bundleCallback.saveBundle(this.bundleMetadata);
        return changes;
    }

    private Map<String, ImmutableSortedSet<DocumentKey>> getQueryDocumentMapping() {
        HashMap<String, ImmutableSortedSet<DocumentKey>> queryDocumentMap = new HashMap<String, ImmutableSortedSet<DocumentKey>>();
        for (NamedQuery namedQuery : this.queries) {
            queryDocumentMap.put(namedQuery.getName(), DocumentKey.emptyKeySet());
        }
        for (BundledDocumentMetadata metadata : this.documentsMetadata.values()) {
            for (String query : metadata.getQueries()) {
                ImmutableSortedSet matchingKeys = (ImmutableSortedSet)queryDocumentMap.get(query);
                queryDocumentMap.put(query, (ImmutableSortedSet<DocumentKey>)matchingKeys.insert((Object)metadata.getKey()));
            }
        }
        return queryDocumentMap;
    }
}

