/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.core.UserData;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Preconditions;
import com.google.firebase.firestore.util.Util;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class Transaction {
    private final com.google.firebase.firestore.core.Transaction transaction;
    private final FirebaseFirestore firestore;

    Transaction(com.google.firebase.firestore.core.Transaction transaction, FirebaseFirestore firestore) {
        this.transaction = Preconditions.checkNotNull(transaction);
        this.firestore = Preconditions.checkNotNull(firestore);
    }

    @NonNull
    public Transaction set(@NonNull DocumentReference documentRef, @NonNull Object data) {
        return this.set(documentRef, data, SetOptions.OVERWRITE);
    }

    @NonNull
    public Transaction set(@NonNull DocumentReference documentRef, @NonNull Object data, @NonNull SetOptions options) {
        this.firestore.validateReference(documentRef);
        Preconditions.checkNotNull(data, "Provided data must not be null.");
        Preconditions.checkNotNull(options, "Provided options must not be null.");
        UserData.ParsedSetData parsed = options.isMerge() ? this.firestore.getUserDataReader().parseMergeData(data, options.getFieldMask()) : this.firestore.getUserDataReader().parseSetData(data);
        this.transaction.set(documentRef.getKey(), parsed);
        return this;
    }

    @NonNull
    public Transaction update(@NonNull DocumentReference documentRef, @NonNull Map<String, Object> data) {
        UserData.ParsedUpdateData parsedData = this.firestore.getUserDataReader().parseUpdateData(data);
        return this.update(documentRef, parsedData);
    }

    @NonNull
    public Transaction update(@NonNull DocumentReference documentRef, @NonNull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        UserData.ParsedUpdateData parsedData = this.firestore.getUserDataReader().parseUpdateData(Util.collectUpdateArguments(1, field, value, moreFieldsAndValues));
        return this.update(documentRef, parsedData);
    }

    @NonNull
    public Transaction update(@NonNull DocumentReference documentRef, @NonNull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        UserData.ParsedUpdateData parsedData = this.firestore.getUserDataReader().parseUpdateData(Util.collectUpdateArguments(1, fieldPath, value, moreFieldsAndValues));
        return this.update(documentRef, parsedData);
    }

    private Transaction update(@NonNull DocumentReference documentRef, @NonNull UserData.ParsedUpdateData updateData) {
        this.firestore.validateReference(documentRef);
        this.transaction.update(documentRef.getKey(), updateData);
        return this;
    }

    @NonNull
    public Transaction delete(@NonNull DocumentReference documentRef) {
        this.firestore.validateReference(documentRef);
        this.transaction.delete(documentRef.getKey());
        return this;
    }

    private Task<DocumentSnapshot> getAsync(DocumentReference documentRef) {
        return this.transaction.lookup(Collections.singletonList(documentRef.getKey())).continueWith(Executors.DIRECT_EXECUTOR, task -> {
            if (!task.isSuccessful()) {
                throw task.getException();
            }
            List docs = (List)task.getResult();
            if (docs.size() != 1) {
                throw Assert.fail("Mismatch in docs returned from document lookup.", new Object[0]);
            }
            MutableDocument doc = (MutableDocument)docs.get(0);
            if (doc.isFoundDocument()) {
                return DocumentSnapshot.fromDocument(this.firestore, doc, false, false);
            }
            if (doc.isNoDocument()) {
                return DocumentSnapshot.fromNoDocument(this.firestore, doc.getKey(), false);
            }
            throw Assert.fail("BatchGetDocumentsRequest returned unexpected document type: " + doc.getClass().getCanonicalName(), new Object[0]);
        });
    }

    @NonNull
    public DocumentSnapshot get(@NonNull DocumentReference documentRef) throws FirebaseFirestoreException {
        this.firestore.validateReference(documentRef);
        try {
            return (DocumentSnapshot)Tasks.await(this.getAsync(documentRef));
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FirebaseFirestoreException) {
                throw (FirebaseFirestoreException)((Object)ee.getCause());
            }
            throw new RuntimeException(ee.getCause());
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public static interface Function<TResult> {
        @Nullable
        public TResult apply(@NonNull Transaction var1) throws FirebaseFirestoreException;
    }
}

