/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.auth;

import android.annotation.SuppressLint;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.internal.IdTokenListener;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Listener;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.inject.Deferred;

public final class FirebaseAuthCredentialsProvider
extends CredentialsProvider<User> {
    private static final String LOG_TAG = "FirebaseAuthCredentialsProvider";
    private final IdTokenListener idTokenListener = result -> this.onIdTokenChanged();
    @Nullable
    @GuardedBy(value="this")
    private InternalAuthProvider internalAuthProvider;
    @Nullable
    @GuardedBy(value="this")
    private Listener<User> changeListener;
    @GuardedBy(value="this")
    private int tokenCounter;
    @GuardedBy(value="this")
    private boolean forceRefresh;

    @SuppressLint(value={"ProviderAssignment"})
    public FirebaseAuthCredentialsProvider(Deferred<InternalAuthProvider> deferredAuthProvider) {
        deferredAuthProvider.whenAvailable(provider -> {
            FirebaseAuthCredentialsProvider firebaseAuthCredentialsProvider = this;
            synchronized (firebaseAuthCredentialsProvider) {
                this.internalAuthProvider = (InternalAuthProvider)provider.get();
                this.onIdTokenChanged();
                this.internalAuthProvider.addIdTokenListener(this.idTokenListener);
            }
        });
    }

    @Override
    public synchronized Task<String> getToken() {
        if (this.internalAuthProvider == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("auth is not available"));
        }
        Task res = this.internalAuthProvider.getAccessToken(this.forceRefresh);
        this.forceRefresh = false;
        int savedCounter = this.tokenCounter;
        return res.continueWithTask(Executors.DIRECT_EXECUTOR, task -> {
            FirebaseAuthCredentialsProvider firebaseAuthCredentialsProvider = this;
            synchronized (firebaseAuthCredentialsProvider) {
                if (savedCounter != this.tokenCounter) {
                    Logger.debug(LOG_TAG, "getToken aborted due to token change", new Object[0]);
                    return this.getToken();
                }
                if (task.isSuccessful()) {
                    return Tasks.forResult((Object)((GetTokenResult)task.getResult()).getToken());
                }
                return Tasks.forException((Exception)task.getException());
            }
        });
    }

    @Override
    public synchronized void invalidateToken() {
        this.forceRefresh = true;
    }

    @Override
    public synchronized void setChangeListener(@NonNull Listener<User> changeListener) {
        this.changeListener = changeListener;
        changeListener.onValue(this.getUser());
    }

    @Override
    public synchronized void removeChangeListener() {
        this.changeListener = null;
        if (this.internalAuthProvider != null) {
            this.internalAuthProvider.removeIdTokenListener(this.idTokenListener);
        }
    }

    private synchronized void onIdTokenChanged() {
        ++this.tokenCounter;
        if (this.changeListener != null) {
            this.changeListener.onValue(this.getUser());
        }
    }

    private synchronized User getUser() {
        String uid = this.internalAuthProvider == null ? null : this.internalAuthProvider.getUid();
        return uid != null ? new User(uid) : User.UNAUTHENTICATED;
    }
}

