/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.util.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompositeFilter
extends Filter {
    private final List<Filter> filters;
    private final Operator operator;
    private List<FieldFilter> memoizedFlattenedFilters;

    public CompositeFilter(List<Filter> filters, Operator operator) {
        this.filters = new ArrayList<Filter>(filters);
        this.operator = operator;
    }

    @Override
    public List<Filter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public List<FieldFilter> getFlattenedFilters() {
        if (this.memoizedFlattenedFilters != null) {
            return Collections.unmodifiableList(this.memoizedFlattenedFilters);
        }
        this.memoizedFlattenedFilters = new ArrayList<FieldFilter>();
        for (Filter subfilter : this.filters) {
            this.memoizedFlattenedFilters.addAll(subfilter.getFlattenedFilters());
        }
        return Collections.unmodifiableList(this.memoizedFlattenedFilters);
    }

    @Override
    public FieldPath getFirstInequalityField() {
        FieldFilter found = this.findFirstMatchingFilter(f -> f.isInequality());
        if (found != null) {
            return found.getField();
        }
        return null;
    }

    public boolean isConjunction() {
        return this.operator == Operator.AND;
    }

    public boolean isDisjunction() {
        return this.operator == Operator.OR;
    }

    public boolean isFlatConjunction() {
        return this.isFlat() && this.isConjunction();
    }

    public boolean isFlat() {
        for (Filter filter : this.filters) {
            if (!(filter instanceof CompositeFilter)) continue;
            return false;
        }
        return true;
    }

    public CompositeFilter withAddedFilters(List<Filter> otherFilters) {
        ArrayList<Filter> mergedFilters = new ArrayList<Filter>(this.filters);
        mergedFilters.addAll(otherFilters);
        return new CompositeFilter(mergedFilters, this.operator);
    }

    @Nullable
    private FieldFilter findFirstMatchingFilter(Function<FieldFilter, Boolean> condition) {
        for (FieldFilter filter : this.getFlattenedFilters()) {
            if (!condition.apply(filter).booleanValue()) continue;
            return filter;
        }
        return null;
    }

    @Override
    public boolean matches(Document doc) {
        if (this.isConjunction()) {
            for (Filter filter : this.filters) {
                if (filter.matches(doc)) continue;
                return false;
            }
            return true;
        }
        for (Filter filter : this.filters) {
            if (!filter.matches(doc)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCanonicalId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.operator.toString() + "(");
        builder.append(TextUtils.join((CharSequence)",", this.filters));
        builder.append(")");
        return builder.toString();
    }

    public String toString() {
        return this.getCanonicalId();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CompositeFilter)) {
            return false;
        }
        CompositeFilter other = (CompositeFilter)o;
        return this.operator == other.operator && this.filters.equals(other.filters);
    }

    public int hashCode() {
        int result = 37;
        result = 31 * result + this.operator.hashCode();
        result = 31 * result + this.filters.hashCode();
        return result;
    }

    public static enum Operator {
        AND("and"),
        OR("or");

        private final String text;

        private Operator(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

