/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.protobuf.ByteString;

public final class TargetChange {
    private final ByteString resumeToken;
    private final boolean current;
    private final ImmutableSortedSet<DocumentKey> addedDocuments;
    private final ImmutableSortedSet<DocumentKey> modifiedDocuments;
    private final ImmutableSortedSet<DocumentKey> removedDocuments;

    public static TargetChange createSynthesizedTargetChangeForCurrentChange(boolean isCurrent) {
        return new TargetChange(ByteString.EMPTY, isCurrent, DocumentKey.emptyKeySet(), DocumentKey.emptyKeySet(), DocumentKey.emptyKeySet());
    }

    public TargetChange(ByteString resumeToken, boolean current, ImmutableSortedSet<DocumentKey> addedDocuments, ImmutableSortedSet<DocumentKey> modifiedDocuments, ImmutableSortedSet<DocumentKey> removedDocuments) {
        this.resumeToken = resumeToken;
        this.current = current;
        this.addedDocuments = addedDocuments;
        this.modifiedDocuments = modifiedDocuments;
        this.removedDocuments = removedDocuments;
    }

    public ByteString getResumeToken() {
        return this.resumeToken;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public ImmutableSortedSet<DocumentKey> getAddedDocuments() {
        return this.addedDocuments;
    }

    public ImmutableSortedSet<DocumentKey> getModifiedDocuments() {
        return this.modifiedDocuments;
    }

    public ImmutableSortedSet<DocumentKey> getRemovedDocuments() {
        return this.removedDocuments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetChange that = (TargetChange)o;
        if (this.current != that.current) {
            return false;
        }
        if (!this.resumeToken.equals((Object)that.resumeToken)) {
            return false;
        }
        if (!this.addedDocuments.equals(that.addedDocuments)) {
            return false;
        }
        if (!this.modifiedDocuments.equals(that.modifiedDocuments)) {
            return false;
        }
        return this.removedDocuments.equals(that.removedDocuments);
    }

    public int hashCode() {
        int result = this.resumeToken.hashCode();
        result = 31 * result + (this.current ? 1 : 0);
        result = 31 * result + this.addedDocuments.hashCode();
        result = 31 * result + this.modifiedDocuments.hashCode();
        result = 31 * result + this.removedDocuments.hashCode();
        return result;
    }
}

