/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.util;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Continuation;
import com.google.cloud.datastore.core.number.NumberComparisonHelper;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.util.Consumer;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;

public class Util {
    private static final int AUTO_ID_LENGTH = 20;
    private static final String AUTO_ID_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final Random rand = new SecureRandom();
    private static final Continuation<Void, Void> VOID_ERROR_TRANSFORMER = task -> {
        if (task.isSuccessful()) {
            return (Void)task.getResult();
        }
        Exception e = Util.convertStatusException(task.getException());
        if (e instanceof FirebaseFirestoreException) {
            throw e;
        }
        throw new FirebaseFirestoreException(e.getMessage(), FirebaseFirestoreException.Code.UNKNOWN, e);
    };

    public static String autoId() {
        StringBuilder builder = new StringBuilder();
        int maxRandom = AUTO_ID_ALPHABET.length();
        for (int i = 0; i < 20; ++i) {
            builder.append(AUTO_ID_ALPHABET.charAt(rand.nextInt(maxRandom)));
        }
        return builder.toString();
    }

    public static int compareBooleans(boolean b1, boolean b2) {
        if (b1 == b2) {
            return 0;
        }
        if (b1) {
            return 1;
        }
        return -1;
    }

    public static int compareIntegers(int i1, int i2) {
        if (i1 < i2) {
            return -1;
        }
        if (i1 > i2) {
            return 1;
        }
        return 0;
    }

    public static int compareLongs(long i1, long i2) {
        return NumberComparisonHelper.compareLongs(i1, i2);
    }

    public static int compareDoubles(double i1, double i2) {
        return NumberComparisonHelper.firestoreCompareDoubles(i1, i2);
    }

    public static int compareMixed(double doubleValue, long longValue) {
        return NumberComparisonHelper.firestoreCompareDoubleWithLong(doubleValue, longValue);
    }

    public static <T extends Comparable<T>> Comparator<T> comparator() {
        return Comparable::compareTo;
    }

    public static FirebaseFirestoreException exceptionFromStatus(Status error) {
        StatusException statusException = error.asException();
        return new FirebaseFirestoreException(statusException.getMessage(), FirebaseFirestoreException.Code.fromValue(error.getCode().value()), (Throwable)statusException);
    }

    private static Exception convertStatusException(Exception e) {
        if (e instanceof StatusException) {
            StatusException statusException = (StatusException)e;
            return Util.exceptionFromStatus(statusException.getStatus());
        }
        if (e instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)e;
            return Util.exceptionFromStatus(statusRuntimeException.getStatus());
        }
        return e;
    }

    public static Exception convertThrowableToException(Throwable t) {
        if (t instanceof Exception) {
            return Util.convertStatusException((Exception)t);
        }
        return new Exception(t);
    }

    public static Continuation<Void, Void> voidErrorTransformer() {
        return VOID_ERROR_TRANSFORMER;
    }

    public static List<Object> collectUpdateArguments(int fieldPathOffset, Object field, Object val, Object ... fieldsAndValues) {
        if (fieldsAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("Missing value in call to update().  There must be an even number of arguments that alternate between field names and values");
        }
        ArrayList<Object> argumentList = new ArrayList<Object>();
        argumentList.add(field);
        argumentList.add(val);
        Collections.addAll(argumentList, fieldsAndValues);
        for (int i = 0; i < argumentList.size(); i += 2) {
            Object fieldPath = argumentList.get(i);
            if (fieldPath instanceof String || fieldPath instanceof FieldPath) continue;
            throw new IllegalArgumentException("Excepted field name at argument position " + (i + fieldPathOffset + 1) + " but got " + fieldPath + " in call to update.  The arguments to update should alternate between field names and values");
        }
        return argumentList;
    }

    public static String toDebugString(ByteString bytes) {
        int size = bytes.size();
        StringBuilder result = new StringBuilder(2 * size);
        for (int i = 0; i < size; ++i) {
            int value = bytes.byteAt(i) & 0xFF;
            result.append(Character.forDigit(value >>> 4, 16));
            result.append(Character.forDigit(value & 0xF, 16));
        }
        return result.toString();
    }

    public static String typeName(@Nullable Object obj) {
        return obj == null ? "null" : obj.getClass().getName();
    }

    public static void crashMainThread(RuntimeException exception) {
        new Handler(Looper.getMainLooper()).post(() -> {
            throw exception;
        });
    }

    public static int compareByteArrays(byte[] left, byte[] right) {
        int size = Math.min(left.length, right.length);
        for (int i = 0; i < size; ++i) {
            int thisByte = left[i] & 0xFF;
            int otherByte = right[i] & 0xFF;
            if (thisByte < otherByte) {
                return -1;
            }
            if (thisByte <= otherByte) continue;
            return 1;
        }
        return Util.compareIntegers(left.length, right.length);
    }

    public static int compareByteStrings(ByteString left, ByteString right) {
        int size = Math.min(left.size(), right.size());
        for (int i = 0; i < size; ++i) {
            int otherByte;
            int thisByte = left.byteAt(i) & 0xFF;
            if (thisByte < (otherByte = right.byteAt(i) & 0xFF)) {
                return -1;
            }
            if (thisByte <= otherByte) continue;
            return 1;
        }
        return Util.compareIntegers(left.size(), right.size());
    }

    public static StringBuilder repeatSequence(CharSequence sequence, int count, CharSequence delimiter) {
        StringBuilder sb = new StringBuilder();
        if (count != 0) {
            sb.append(sequence);
            for (int i = 1; i < count; ++i) {
                sb.append(delimiter);
                sb.append(sequence);
            }
        }
        return sb;
    }

    public static <T> void diffCollections(Collection<T> before, Collection<T> after, Comparator<T> comparator, Consumer<T> onAdd, Consumer<T> onRemove) {
        ArrayList<T> beforeEntries = new ArrayList<T>(before);
        Collections.sort(beforeEntries, comparator);
        ArrayList<T> afterEntries = new ArrayList<T>(after);
        Collections.sort(afterEntries, comparator);
        Util.diffCollections(beforeEntries.iterator(), afterEntries.iterator(), comparator, onAdd, onRemove);
    }

    public static <T extends Comparable<T>> void diffCollections(SortedSet<T> before, SortedSet<T> after, Consumer<T> onAdd, Consumer<T> onRemove) {
        Util.diffCollections(before.iterator(), after.iterator(), before.comparator() != null ? before.comparator() : (l, r) -> l.compareTo(r), onAdd, onRemove);
    }

    private static <T> void diffCollections(Iterator<T> beforeSorted, Iterator<T> afterSorted, Comparator<? super T> comparator, Consumer<T> onAdd, Consumer<T> onRemove) {
        T beforeValue = Util.advanceIterator(beforeSorted);
        T afterValue = Util.advanceIterator(afterSorted);
        while (beforeValue != null || afterValue != null) {
            boolean added = false;
            boolean removed = false;
            if (beforeValue != null && afterValue != null) {
                int cmp = comparator.compare(beforeValue, afterValue);
                if (cmp < 0) {
                    removed = true;
                } else if (cmp > 0) {
                    added = true;
                }
            } else if (beforeValue != null) {
                removed = true;
            } else {
                added = true;
            }
            if (added) {
                onAdd.accept(afterValue);
                afterValue = Util.advanceIterator(afterSorted);
                continue;
            }
            if (removed) {
                onRemove.accept(beforeValue);
                beforeValue = Util.advanceIterator(beforeSorted);
                continue;
            }
            beforeValue = Util.advanceIterator(beforeSorted);
            afterValue = Util.advanceIterator(afterSorted);
        }
    }

    @Nullable
    private static <T> T advanceIterator(Iterator<T> it) {
        return it.hasNext() ? (T)it.next() : null;
    }

    public static <K, V> Iterable<V> values(Iterable<Map.Entry<K, V>> map) {
        return () -> {
            final Iterator iterator = map.iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)iterator.next()).getValue();
                }
            };
        };
    }

    public static <K, V> Map<K, V> firstNEntries(Map<K, V> data, int n, Comparator<V> comp) {
        if (data.size() <= n) {
            return data;
        }
        ArrayList<Map.Entry<K, V>> sortedValues = new ArrayList<Map.Entry<K, V>>(data.entrySet());
        Collections.sort(sortedValues, (l, r) -> comp.compare(l.getValue(), r.getValue()));
        HashMap result = new HashMap();
        for (int i = 0; i < n; ++i) {
            result.put(((Map.Entry)sortedValues.get(i)).getKey(), ((Map.Entry)sortedValues.get(i)).getValue());
        }
        return result;
    }
}

