/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.auto.value.AutoValue;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.remote.AutoValue_TestingHooks_ExistenceFilterBloomFilterInfo;
import com.google.firebase.firestore.remote.AutoValue_TestingHooks_ExistenceFilterMismatchInfo;
import com.google.firebase.firestore.remote.ExistenceFilter;
import com.google.firebase.firestore.util.Preconditions;
import com.google.firestore.v1.BloomFilter;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
final class TestingHooks {
    private static final TestingHooks instance = new TestingHooks();
    private final CopyOnWriteArrayList<AtomicReference<ExistenceFilterMismatchListener>> existenceFilterMismatchListeners = new CopyOnWriteArrayList();

    private TestingHooks() {
    }

    @NonNull
    static TestingHooks getInstance() {
        return instance;
    }

    void notifyOnExistenceFilterMismatch(@NonNull ExistenceFilterMismatchInfo info) {
        for (AtomicReference<ExistenceFilterMismatchListener> listenerRef : this.existenceFilterMismatchListeners) {
            ExistenceFilterMismatchListener listener = listenerRef.get();
            if (listener == null) continue;
            listener.onExistenceFilterMismatch(info);
        }
    }

    ListenerRegistration addExistenceFilterMismatchListener(@NonNull ExistenceFilterMismatchListener listener) {
        Preconditions.checkNotNull(listener, "a null listener is not allowed");
        AtomicReference<ExistenceFilterMismatchListener> listenerRef = new AtomicReference<ExistenceFilterMismatchListener>(listener);
        this.existenceFilterMismatchListeners.add(listenerRef);
        return () -> {
            listenerRef.set(null);
            this.existenceFilterMismatchListeners.remove(listenerRef);
        };
    }

    @AutoValue
    static abstract class ExistenceFilterBloomFilterInfo {
        ExistenceFilterBloomFilterInfo() {
        }

        static ExistenceFilterBloomFilterInfo create(boolean applied, int hashCount, int bitmapLength, int padding) {
            return new AutoValue_TestingHooks_ExistenceFilterBloomFilterInfo(applied, hashCount, bitmapLength, padding);
        }

        abstract boolean applied();

        abstract int hashCount();

        abstract int bitmapLength();

        abstract int padding();

        static ExistenceFilterBloomFilterInfo from(boolean bloomFilterApplied, ExistenceFilter existenceFilter) {
            BloomFilter unchangedNames = existenceFilter.getUnchangedNames();
            if (unchangedNames == null) {
                return null;
            }
            return ExistenceFilterBloomFilterInfo.create(bloomFilterApplied, unchangedNames.getHashCount(), unchangedNames.getBits().getBitmap().size(), unchangedNames.getBits().getPadding());
        }
    }

    @AutoValue
    static abstract class ExistenceFilterMismatchInfo {
        ExistenceFilterMismatchInfo() {
        }

        static ExistenceFilterMismatchInfo create(int localCacheCount, int existenceFilterCount, @Nullable ExistenceFilterBloomFilterInfo bloomFilter) {
            return new AutoValue_TestingHooks_ExistenceFilterMismatchInfo(localCacheCount, existenceFilterCount, bloomFilter);
        }

        abstract int localCacheCount();

        abstract int existenceFilterCount();

        @Nullable
        abstract ExistenceFilterBloomFilterInfo bloomFilter();

        static ExistenceFilterMismatchInfo from(boolean bloomFilterApplied, int localCacheCount, ExistenceFilter existenceFilter) {
            return ExistenceFilterMismatchInfo.create(localCacheCount, existenceFilter.getCount(), ExistenceFilterBloomFilterInfo.from(bloomFilterApplied, existenceFilter));
        }
    }

    static interface ExistenceFilterMismatchListener {
        @AnyThread
        public void onExistenceFilterMismatch(@NonNull ExistenceFilterMismatchInfo var1);
    }
}

