/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations;

import android.text.TextUtils;
import com.google.firebase.installations.local.PersistedInstallationEntry;
import java.util.concurrent.TimeUnit;

class Utils {
    public static final long AUTH_TOKEN_EXPIRATION_BUFFER_IN_SECS = TimeUnit.HOURS.toSeconds(1L);

    Utils() {
    }

    public boolean isAuthTokenExpired(PersistedInstallationEntry entry) {
        if (TextUtils.isEmpty((CharSequence)entry.getAuthToken())) {
            return true;
        }
        return entry.getTokenCreationEpochInSecs() + entry.getExpiresInSecs() < this.currentTimeInSecs() + AUTH_TOKEN_EXPIRATION_BUFFER_IN_SECS;
    }

    public long currentTimeInSecs() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }
}

