/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzc;
import com.google.firebase.messaging.zzd;
import java.util.Map;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="RemoteMessageCreator")
public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzd();
    @SafeParcelable.Field(id=2)
    Bundle zzdh;
    private Map<String, String> zzdi;
    private Notification zzdj;

    @SafeParcelable.Constructor
    public RemoteMessage(@SafeParcelable.Param(id=2) Bundle bundle) {
        this.zzdh = bundle;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RemoteMessage remoteMessage = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)2, (Bundle)remoteMessage.zzdh, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final String getFrom() {
        return this.zzdh.getString("from");
    }

    @Nullable
    public final String getTo() {
        return this.zzdh.getString("google.to");
    }

    public final Map<String, String> getData() {
        if (this.zzdi == null) {
            this.zzdi = new ArrayMap();
            for (String string2 : this.zzdh.keySet()) {
                Object object = this.zzdh.get(string2);
                if (!(object instanceof String)) continue;
                String string3 = (String)object;
                if (string2.startsWith("google.") || string2.startsWith("gcm.") || string2.equals("from") || string2.equals("message_type") || string2.equals("collapse_key")) continue;
                this.zzdi.put(string2, string3);
            }
        }
        return this.zzdi;
    }

    @Nullable
    public final String getCollapseKey() {
        return this.zzdh.getString("collapse_key");
    }

    @Nullable
    public final String getMessageId() {
        String string2 = this.zzdh.getString("google.message_id");
        if (string2 == null) {
            string2 = this.zzdh.getString("message_id");
        }
        return string2;
    }

    @Nullable
    public final String getMessageType() {
        return this.zzdh.getString("message_type");
    }

    public final long getSentTime() {
        Object object = this.zzdh.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string2).length()).append("Invalid sent time: ").append(string2).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Object object = this.zzdh.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string2).length()).append("Invalid TTL: ").append(string2).toString());
            }
        }
        return 0;
    }

    @Nullable
    public final Notification getNotification() {
        if (this.zzdj == null && zza.zzf(this.zzdh)) {
            this.zzdj = new Notification(this.zzdh, null);
        }
        return this.zzdj;
    }

    public static class Notification {
        private final String zzdk;
        private final String zzdl;
        private final String[] zzdm;
        private final String zzdn;
        private final String zzdo;
        private final String[] zzdp;
        private final String zzdq;
        private final String zzdr;
        private final String tag;
        private final String zzds;
        private final String zzdt;
        private final Uri zzdu;

        private Notification(Bundle bundle) {
            this.zzdk = zza.zza(bundle, "gcm.n.title");
            this.zzdl = zza.zzb(bundle, "gcm.n.title");
            this.zzdm = Notification.zze(bundle, "gcm.n.title");
            this.zzdn = zza.zza(bundle, "gcm.n.body");
            this.zzdo = zza.zzb(bundle, "gcm.n.body");
            this.zzdp = Notification.zze(bundle, "gcm.n.body");
            this.zzdq = zza.zza(bundle, "gcm.n.icon");
            this.zzdr = zza.zzi(bundle);
            this.tag = zza.zza(bundle, "gcm.n.tag");
            this.zzds = zza.zza(bundle, "gcm.n.color");
            this.zzdt = zza.zza(bundle, "gcm.n.click_action");
            this.zzdu = zza.zzg(bundle);
        }

        private static String[] zze(Bundle bundle, String string2) {
            Object[] objectArray = zza.zzc(bundle, string2);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.zzdk;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zzdl;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zzdm;
        }

        @Nullable
        public String getBody() {
            return this.zzdn;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zzdo;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zzdp;
        }

        @Nullable
        public String getIcon() {
            return this.zzdq;
        }

        @Nullable
        public String getSound() {
            return this.zzdr;
        }

        @Nullable
        public String getTag() {
            return this.tag;
        }

        @Nullable
        public String getColor() {
            return this.zzds;
        }

        @Nullable
        public String getClickAction() {
            return this.zzdt;
        }

        @Nullable
        public Uri getLink() {
            return this.zzdu;
        }

        /* synthetic */ Notification(Bundle bundle, zzc zzc2) {
            this(bundle);
        }
    }

    public static class Builder {
        private final Bundle zzdh = new Bundle();
        private final Map<String, String> zzdi = new ArrayMap();

        public Builder(String string2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = String.valueOf(string2);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid to: ".concat(string3) : new String("Invalid to: "));
            }
            this.zzdh.putString("google.to", string2);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzdi.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.zzdh);
            this.zzdh.remove("from");
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string2, String string3) {
            this.zzdi.put(string2, string3);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzdi.clear();
            this.zzdi.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzdi.clear();
            return this;
        }

        public Builder setMessageId(String string2) {
            this.zzdh.putString("google.message_id", string2);
            return this;
        }

        public Builder setMessageType(String string2) {
            this.zzdh.putString("message_type", string2);
            return this;
        }

        public Builder setTtl(@IntRange(from=0L, to=86400L) int n) {
            this.zzdh.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string2) {
            this.zzdh.putString("collapse_key", string2);
            return this;
        }
    }
}

