/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.messaging.zzk;

@KeepForSdk
public class MessagingAnalytics {
    @KeepForSdk
    public static void logNotificationReceived(Intent intent) {
        MessagingAnalytics.zza("_nr", intent);
    }

    @KeepForSdk
    public static void logNotificationOpen(Intent intent) {
        Intent intent2 = intent;
        if (intent2 != null) {
            String string = intent2.getStringExtra("google.c.a.tc");
            if ("1".equals(string)) {
                AnalyticsConnector analyticsConnector = (AnalyticsConnector)FirebaseApp.getInstance().get(AnalyticsConnector.class);
                if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                    Log.d((String)"FirebaseMessaging", (String)"Received event with track-conversion=true. Setting user property and reengagement event");
                }
                if (analyticsConnector != null) {
                    String string2 = intent2.getStringExtra("google.c.a.c_id");
                    analyticsConnector.setUserProperty("fcm", "_ln", (Object)string2);
                    Bundle bundle = new Bundle();
                    bundle.putString("source", "Firebase");
                    bundle.putString("medium", "notification");
                    bundle.putString("campaign", string2);
                    analyticsConnector.logEvent("fcm", "_cmp", bundle);
                } else {
                    Log.w((String)"FirebaseMessaging", (String)"Unable to set user property for conversion tracking:  analytics library is missing");
                }
            } else if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)"Received event with track-conversion=false. Do not set user property");
            }
        }
        MessagingAnalytics.zza("_no", intent);
    }

    @KeepForSdk
    public static void logNotificationDismiss(Intent intent) {
        MessagingAnalytics.zza("_nd", intent);
    }

    @KeepForSdk
    public static void logNotificationForeground(Intent intent) {
        MessagingAnalytics.zza("_nf", intent);
    }

    @KeepForSdk
    public static boolean shouldUploadMetrics(Intent intent) {
        if (intent == null) {
            return false;
        }
        if ("com.google.firebase.messaging.RECEIVE_DIRECT_BOOT".equals(intent.getAction())) {
            return false;
        }
        return "1".equals(intent.getStringExtra("google.c.a.e"));
    }

    private static void zza(String string, Intent intent) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        Bundle bundle = new Bundle();
        String string8 = intent.getStringExtra("google.c.a.c_id");
        if (string8 != null) {
            bundle.putString("_nmid", string8);
        }
        if ((string7 = intent.getStringExtra("google.c.a.c_l")) != null) {
            bundle.putString("_nmn", string7);
        }
        if (!TextUtils.isEmpty((CharSequence)(string6 = intent.getStringExtra("google.c.a.m_l")))) {
            bundle.putString("label", string6);
        }
        if (!TextUtils.isEmpty((CharSequence)(string5 = intent.getStringExtra("google.c.a.m_c")))) {
            bundle.putString("message_channel", string5);
        }
        if ((string4 = (string3 = intent.getStringExtra("from")) != null && string3.startsWith("/topics/") ? string3 : null) != null) {
            bundle.putString("_nt", string4);
        }
        if (intent.hasExtra("google.c.a.ts")) {
            try {
                string2 = intent.getStringExtra("google.c.a.ts");
                bundle.putInt("_nmt", Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)"FirebaseMessaging", (String)"Error while parsing timestamp in GCM event", (Throwable)numberFormatException);
            }
        }
        if (intent.hasExtra("google.c.a.udt")) {
            try {
                string2 = intent.getStringExtra("google.c.a.udt");
                bundle.putInt("_ndt", Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)"FirebaseMessaging", (String)"Error while parsing use_device_time in GCM event", (Throwable)numberFormatException);
            }
        }
        if ("_nr".equals(string) || "_nf".equals(string)) {
            bundle.putString("_nmc", intent.getExtras() != null && zzk.zza(intent.getExtras()) ? "display" : "data");
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            string2 = String.valueOf(bundle);
            Log.d((String)"FirebaseMessaging", (String)new StringBuilder(22 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Sending event=").append(string).append(" params=").append(string2).toString());
        }
        if ((string2 = (AnalyticsConnector)FirebaseApp.getInstance().get(AnalyticsConnector.class)) != null) {
            string2.logEvent("fcm", string, bundle);
            return;
        }
        Log.w((String)"FirebaseMessaging", (String)"Unable to log event: analytics library is missing");
    }
}

