/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.cloudmessaging.CloudMessage;
import com.google.android.gms.cloudmessaging.CloudMessagingReceiver;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.messaging.FcmBroadcastProcessor;
import com.google.firebase.messaging.MessagingAnalytics;
import java.util.concurrent.ExecutionException;

public final class FirebaseInstanceIdReceiver
extends CloudMessagingReceiver {
    @WorkerThread
    protected final int onMessageReceive(@NonNull Context context, @NonNull CloudMessage cloudMessage) {
        try {
            Object object = new FcmBroadcastProcessor(context);
            int n = (Integer)Tasks.await(((FcmBroadcastProcessor)object).process(cloudMessage.getIntent()));
            return n;
        }
        catch (InterruptedException | ExecutionException exception) {
            Log.e((String)"FirebaseMessaging", (String)"Failed to send message to service.", (Throwable)exception);
            return 500;
        }
    }

    @WorkerThread
    protected final void onNotificationDismissed(@NonNull Context context, @NonNull Bundle bundle) {
        FirebaseInstanceIdReceiver firebaseInstanceIdReceiver = new Intent("com.google.firebase.messaging.NOTIFICATION_DISMISS");
        if (MessagingAnalytics.shouldUploadScionMetrics((Intent)(firebaseInstanceIdReceiver = firebaseInstanceIdReceiver.putExtras(bundle)))) {
            MessagingAnalytics.logNotificationDismiss((Intent)firebaseInstanceIdReceiver);
            return;
        }
    }
}

