/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.TransportFactory;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.Event;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.internal.FirebaseInstanceIdInternal;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.messaging.FcmBroadcastProcessor;
import com.google.firebase.messaging.FcmExecutors;
import com.google.firebase.messaging.FcmLifecycleCallbacks;
import com.google.firebase.messaging.FirebaseMessaging$$ExternalSyntheticLambda0;
import com.google.firebase.messaging.FirebaseMessaging$$ExternalSyntheticLambda1;
import com.google.firebase.messaging.FirebaseMessaging$$ExternalSyntheticLambda10;
import com.google.firebase.messaging.FirebaseMessaging$$ExternalSyntheticLambda11;
import com.google.firebase.messaging.FirebaseMessaging$$ExternalSyntheticLambda2;
import com.google.firebase.messaging.FirebaseMessaging$$ExternalSyntheticLambda3;
import com.google.firebase.messaging.FirebaseMessaging$$ExternalSyntheticLambda4;
import com.google.firebase.messaging.FirebaseMessaging$$ExternalSyntheticLambda5;
import com.google.firebase.messaging.FirebaseMessaging$$ExternalSyntheticLambda6;
import com.google.firebase.messaging.FirebaseMessaging$$ExternalSyntheticLambda7;
import com.google.firebase.messaging.FirebaseMessaging$$ExternalSyntheticLambda8;
import com.google.firebase.messaging.FirebaseMessaging$$ExternalSyntheticLambda9;
import com.google.firebase.messaging.FirebaseMessaging$AutoInit$$ExternalSyntheticLambda0;
import com.google.firebase.messaging.GmsRpc;
import com.google.firebase.messaging.MessagingAnalytics;
import com.google.firebase.messaging.Metadata;
import com.google.firebase.messaging.ProxyNotificationInitializer;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.RequestDeduplicator;
import com.google.firebase.messaging.Store;
import com.google.firebase.messaging.SyncTask;
import com.google.firebase.messaging.TopicsSubscriber;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FirebaseMessaging {
    @Deprecated
    @NonNull
    public static final String INSTANCE_ID_SCOPE = "FCM";
    private static final long MAX_DELAY_SEC = TimeUnit.HOURS.toSeconds(8L);
    @GuardedBy(value="FirebaseMessaging.class")
    private static Store store;
    @Nullable
    @SuppressLint(value={"FirebaseUnknownNullness"})
    @VisibleForTesting
    static TransportFactory transportFactory;
    @GuardedBy(value="FirebaseMessaging.class")
    @VisibleForTesting
    static ScheduledExecutorService syncExecutor;
    private final FirebaseApp firebaseApp;
    @Nullable
    private final FirebaseInstanceIdInternal iid;
    private final FirebaseInstallationsApi fis;
    private final Context context;
    private final GmsRpc gmsRpc;
    private final RequestDeduplicator requestDeduplicator;
    private final AutoInit autoInit;
    private final Executor fileIoExecutor;
    private final Executor taskExecutor;
    private final Task<TopicsSubscriber> topicsSubscriberTask;
    private final Metadata metadata;
    @GuardedBy(value="this")
    private boolean syncScheduledOrRunning;
    private final Application.ActivityLifecycleCallbacks lifecycleCallbacks;

    Context getApplicationContext() {
        return this.context;
    }

    @Nullable
    public static TransportFactory getTransportFactory() {
        return transportFactory;
    }

    @NonNull
    public Task<Void> deleteToken() {
        if (this.iid != null) {
            TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
            Executor executor = this.fileIoExecutor;
            FirebaseMessaging$$ExternalSyntheticLambda8 firebaseMessaging$$ExternalSyntheticLambda8 = new FirebaseMessaging$$ExternalSyntheticLambda8(this, taskCompletionSource);
            executor.execute(firebaseMessaging$$ExternalSyntheticLambda8);
            return taskCompletionSource.getTask();
        }
        if (this.getTokenWithoutTriggeringSync() == null) {
            return Tasks.forResult(null);
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        ExecutorService executorService = FcmExecutors.newNetworkIOExecutor();
        FirebaseMessaging$$ExternalSyntheticLambda9 firebaseMessaging$$ExternalSyntheticLambda9 = new FirebaseMessaging$$ExternalSyntheticLambda9(this, taskCompletionSource);
        executorService.execute(firebaseMessaging$$ExternalSyntheticLambda9);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<String> getToken() {
        FirebaseInstanceIdInternal firebaseInstanceIdInternal = this.iid;
        if (firebaseInstanceIdInternal != null) {
            return firebaseInstanceIdInternal.getTokenTask();
        }
        firebaseInstanceIdInternal = new TaskCompletionSource();
        Executor executor = this.fileIoExecutor;
        FirebaseMessaging$$ExternalSyntheticLambda10 firebaseMessaging$$ExternalSyntheticLambda10 = new FirebaseMessaging$$ExternalSyntheticLambda10(this, (TaskCompletionSource)firebaseInstanceIdInternal);
        executor.execute(firebaseMessaging$$ExternalSyntheticLambda10);
        return firebaseInstanceIdInternal.getTask();
    }

    /* synthetic */ Task lambda$blockingGetToken$8$com-google-firebase-messaging-FirebaseMessaging(String string, Store.Token token, String string2) throws Exception {
        FirebaseMessaging.getStore(this.context).saveToken(this.getSubtype(), string, string2, this.metadata.getAppVersionCode());
        if (token == null || !string2.equals(token.token)) {
            this.invokeOnTokenRefresh(string2);
        }
        return Tasks.forResult((Object)string2);
    }

    /* synthetic */ Task lambda$blockingGetToken$9$com-google-firebase-messaging-FirebaseMessaging(String string, Store.Token token) {
        Task<String> task = this.gmsRpc;
        task = task.getToken();
        FirebaseMessaging$$ExternalSyntheticLambda11 firebaseMessaging$$ExternalSyntheticLambda11 = FirebaseMessaging$$ExternalSyntheticLambda11.INSTANCE;
        FirebaseMessaging$$ExternalSyntheticLambda1 firebaseMessaging$$ExternalSyntheticLambda1 = new FirebaseMessaging$$ExternalSyntheticLambda1(this, string, token);
        return task.onSuccessTask((Executor)firebaseMessaging$$ExternalSyntheticLambda11, (SuccessContinuation)firebaseMessaging$$ExternalSyntheticLambda1);
    }

    static /* synthetic */ Task lambda$subscribeToTopic$6(String string, TopicsSubscriber topicsSubscriber) throws Exception {
        return topicsSubscriber.subscribeToTopic(string);
    }

    static /* synthetic */ Task lambda$unsubscribeFromTopic$7(String string, TopicsSubscriber topicsSubscriber) throws Exception {
        return topicsSubscriber.unsubscribeFromTopic(string);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> setNotificationDelegationEnabled(boolean enable) {
        void var1_1;
        return ProxyNotificationInitializer.setEnableProxyNotification(this.fileIoExecutor, this.context, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> subscribeToTopic(@NonNull String topic) {
        void var1_1;
        Task<TopicsSubscriber> this_ = this_.topicsSubscriberTask;
        FirebaseMessaging$$ExternalSyntheticLambda2 firebaseMessaging$$ExternalSyntheticLambda2 = new FirebaseMessaging$$ExternalSyntheticLambda2((String)var1_1);
        return this_.onSuccessTask((SuccessContinuation)firebaseMessaging$$ExternalSyntheticLambda2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> unsubscribeFromTopic(@NonNull String topic) {
        void var1_1;
        Task<TopicsSubscriber> this_ = this_.topicsSubscriberTask;
        FirebaseMessaging$$ExternalSyntheticLambda3 firebaseMessaging$$ExternalSyntheticLambda3 = new FirebaseMessaging$$ExternalSyntheticLambda3((String)var1_1);
        return this_.onSuccessTask((SuccessContinuation)firebaseMessaging$$ExternalSyntheticLambda3);
    }

    @NonNull
    public static synchronized FirebaseMessaging getInstance() {
        return FirebaseMessaging.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    @NonNull
    static synchronized FirebaseMessaging getInstance(@NonNull FirebaseApp firebaseApp) {
        Object object = (FirebaseMessaging)firebaseApp.get(FirebaseMessaging.class);
        Preconditions.checkNotNull((Object)object, (Object)"Firebase Messaging component is not present");
        return object;
    }

    @Nullable
    @VisibleForTesting
    Store.Token getTokenWithoutTriggeringSync() {
        return FirebaseMessaging.getStore(this.context).getToken(this.getSubtype(), Metadata.getDefaultSenderId(this.firebaseApp));
    }

    @NonNull
    private static synchronized Store getStore(Context context) {
        if (store == null) {
            Store store;
            FirebaseMessaging.store = store = new Store(context);
        }
        return store;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String blockingGetToken() throws IOException {
        Object object;
        Object object2 = object.iid;
        if (object2 != null) {
            try {
                return (String)Tasks.await((Task)object2.getTokenTask());
            }
            catch (InterruptedException | ExecutionException exception) {
                object2 = new IOException(exception);
                throw object2;
            }
        }
        object2 = object.getTokenWithoutTriggeringSync();
        if (!object.tokenNeedsRefresh((Store.Token)object2)) {
            return object2.token;
        }
        String string = Metadata.getDefaultSenderId(object.firebaseApp);
        RequestDeduplicator requestDeduplicator = object.requestDeduplicator;
        FirebaseMessaging$$ExternalSyntheticLambda5 firebaseMessaging$$ExternalSyntheticLambda5 = new FirebaseMessaging$$ExternalSyntheticLambda5((FirebaseMessaging)object, string, (Store.Token)object2);
        object = requestDeduplicator.getOrStartGetTokenRequest(string, firebaseMessaging$$ExternalSyntheticLambda5);
        try {
            return (String)Tasks.await(object);
        }
        catch (InterruptedException | ExecutionException exception) {
            object2 = new IOException(exception);
            throw object2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSubtype() {
        if (!"[DEFAULT]".equals(((FirebaseMessaging)this).firebaseApp.getName())) return ((FirebaseMessaging)this).firebaseApp.getPersistenceKey();
        return "";
    }

    public static /* synthetic */ void $r8$lambda$iw3kunv9-hQO8R-88V1J4aIyLI8(@NonNull FirebaseMessaging firebaseMessaging, @NonNull String string) {
        firebaseMessaging.invokeOnTokenRefresh(string);
    }

    FirebaseMessaging(FirebaseApp firebaseApp, @Nullable FirebaseInstanceIdInternal firebaseInstanceIdInternal, Provider<UserAgentPublisher> provider, Provider<HeartBeatInfo> provider2, FirebaseInstallationsApi firebaseInstallationsApi, @Nullable TransportFactory transportFactory, Subscriber subscriber) {
        Metadata metadata = new Metadata(firebaseApp.getApplicationContext());
        this(firebaseApp, firebaseInstanceIdInternal, provider, provider2, firebaseInstallationsApi, transportFactory, subscriber, metadata);
    }

    FirebaseMessaging(FirebaseApp firebaseApp, @Nullable FirebaseInstanceIdInternal firebaseInstanceIdInternal, Provider<UserAgentPublisher> provider, Provider<HeartBeatInfo> provider2, FirebaseInstallationsApi firebaseInstallationsApi, @Nullable TransportFactory transportFactory, Subscriber subscriber, Metadata metadata) {
        GmsRpc gmsRpc = new GmsRpc(firebaseApp, metadata, provider, provider2, firebaseInstallationsApi);
        this(firebaseApp, firebaseInstanceIdInternal, firebaseInstallationsApi, transportFactory, subscriber, metadata, gmsRpc, FcmExecutors.newTaskExecutor(), FcmExecutors.newInitExecutor());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    FirebaseMessaging(FirebaseApp object, @Nullable FirebaseInstanceIdInternal object2, FirebaseInstallationsApi object3, @Nullable TransportFactory object4, Subscriber subscriber, Metadata metadata, GmsRpc gmsRpc, Executor executor, Executor executor2) {
        void var9_19;
        void var7_17;
        void var8_18;
        void var6_16;
        void var5_15;
        Object object5;
        void var2_10;
        StringBuilder stringBuilder;
        this.syncScheduledOrRunning = false;
        transportFactory = stringBuilder;
        this.firebaseApp = object;
        this.iid = var2_10;
        this.fis = object5;
        object5 = new AutoInit((Subscriber)var5_15);
        this.autoInit = object5;
        this.context = object.getApplicationContext();
        object5 = new FcmLifecycleCallbacks();
        this.lifecycleCallbacks = object5;
        this.metadata = var6_16;
        this.taskExecutor = var8_18;
        this.gmsRpc = var7_17;
        this.requestDeduplicator = object5 = new RequestDeduplicator((Executor)var8_18);
        this.fileIoExecutor = var9_19;
        Context context = object.getApplicationContext();
        if (context instanceof Application) {
            ((Application)context).registerActivityLifecycleCallbacks(this.lifecycleCallbacks);
        } else {
            String string = String.valueOf(context);
            object5 = String.valueOf(string);
            int n = ((String)object5).length();
            stringBuilder = new StringBuilder(n + 125);
            stringBuilder.append("Context ");
            stringBuilder.append(string);
            stringBuilder.append(" was not an application, can't register for lifecycle callbacks. Some notification events may be dropped as a result.");
            Log.w((String)"FirebaseMessaging", (String)stringBuilder.toString());
        }
        if (var2_10 != null) {
            FirebaseMessaging$$ExternalSyntheticLambda4 firebaseMessaging$$ExternalSyntheticLambda4 = new FirebaseMessaging$$ExternalSyntheticLambda4(this);
            var2_10.addNewTokenListener((FirebaseInstanceIdInternal.NewTokenListener)firebaseMessaging$$ExternalSyntheticLambda4);
        }
        FirebaseMessaging$$ExternalSyntheticLambda6 firebaseMessaging$$ExternalSyntheticLambda6 = new FirebaseMessaging$$ExternalSyntheticLambda6(this);
        var9_19.execute(firebaseMessaging$$ExternalSyntheticLambda6);
        Task<TopicsSubscriber> task = this.topicsSubscriberTask = TopicsSubscriber.createInstance(this, (Metadata)var6_16, (GmsRpc)var7_17, this.context, FcmExecutors.newTopicsSyncExecutor());
        FirebaseMessaging$$ExternalSyntheticLambda0 firebaseMessaging$$ExternalSyntheticLambda0 = new FirebaseMessaging$$ExternalSyntheticLambda0(this);
        task.addOnSuccessListener((Executor)var9_19, (OnSuccessListener)firebaseMessaging$$ExternalSyntheticLambda0);
        FirebaseMessaging$$ExternalSyntheticLambda7 firebaseMessaging$$ExternalSyntheticLambda7 = new FirebaseMessaging$$ExternalSyntheticLambda7(this);
        var9_19.execute(firebaseMessaging$$ExternalSyntheticLambda7);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void enqueueTaskWithDelaySeconds(Runnable runnable, long l) {
        Class<FirebaseMessaging> clazz = FirebaseMessaging.class;
        synchronized (clazz) {
            ScheduledExecutorService scheduledExecutorService = syncExecutor;
            if (scheduledExecutorService == null) {
                NamedThreadFactory namedThreadFactory = new NamedThreadFactory("TAG");
                syncExecutor = scheduledExecutorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)namedThreadFactory);
            }
            syncExecutor.schedule(runnable, l, TimeUnit.SECONDS);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void invokeOnTokenRefresh(String object) {
        Object object2;
        if (!"[DEFAULT]".equals(this.firebaseApp.getName())) {
            return;
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            object2 = String.valueOf(this.firebaseApp.getName());
            String string = "Invoking onNewToken for app: ";
            object2 = ((String)object2).length() != 0 ? string.concat((String)object2) : new String(string);
            Log.d((String)"FirebaseMessaging", (String)object2);
        }
        object2 = new Intent("com.google.firebase.messaging.NEW_TOKEN");
        object2.putExtra("token", (String)object);
        object = new FcmBroadcastProcessor(this.context);
        ((FcmBroadcastProcessor)object).process((Intent)object2);
    }

    /* synthetic */ void lambda$deleteToken$4$com-google-firebase-messaging-FirebaseMessaging(TaskCompletionSource taskCompletionSource) {
        try {
            this.iid.deleteToken(Metadata.getDefaultSenderId(this.firebaseApp), INSTANCE_ID_SCOPE);
            taskCompletionSource.setResult(null);
            return;
        }
        catch (Exception exception) {
            taskCompletionSource.setException(exception);
            return;
        }
    }

    /* synthetic */ void lambda$deleteToken$5$com-google-firebase-messaging-FirebaseMessaging(TaskCompletionSource taskCompletionSource) {
        try {
            Tasks.await(this.gmsRpc.deleteToken());
            FirebaseMessaging.getStore(this.context).deleteToken(this.getSubtype(), Metadata.getDefaultSenderId(this.firebaseApp));
            taskCompletionSource.setResult(null);
            return;
        }
        catch (Exception exception) {
            taskCompletionSource.setException(exception);
            return;
        }
    }

    /* synthetic */ void lambda$getToken$3$com-google-firebase-messaging-FirebaseMessaging(TaskCompletionSource taskCompletionSource) {
        try {
            taskCompletionSource.setResult((Object)this.blockingGetToken());
            return;
        }
        catch (Exception exception) {
            taskCompletionSource.setException(exception);
            return;
        }
    }

    /* synthetic */ void lambda$new$0$com-google-firebase-messaging-FirebaseMessaging() {
        if (this.isAutoInitEnabled()) {
            this.startSyncIfNecessary();
            return;
        }
    }

    /* synthetic */ void lambda$new$1$com-google-firebase-messaging-FirebaseMessaging(TopicsSubscriber topicsSubscriber) {
        if (this.isAutoInitEnabled()) {
            topicsSubscriber.startTopicsSyncIfNecessary();
            return;
        }
    }

    /* synthetic */ void lambda$new$2$com-google-firebase-messaging-FirebaseMessaging() {
        ProxyNotificationInitializer.initialize(this.context);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void send(@NonNull RemoteMessage message) {
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)message.getTo())) {
            Object object = new IllegalArgumentException("Missing 'to'");
            throw object;
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        Intent intent2 = new Intent();
        intent2.setPackage("com.google.example.invalidpackage");
        Context context = ((FirebaseMessaging)object).context;
        int n = Build.VERSION.SDK_INT >= 23 ? 0x4000000 : 0;
        intent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)n));
        intent.setPackage("com.google.android.gms");
        var1_1.populateSendMessageIntent(intent);
        ((FirebaseMessaging)object).context.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoInitEnabled(boolean enable) {
        void var1_1;
        this.autoInit.setEnabled((boolean)var1_1);
    }

    public void setDeliveryMetricsExportToBigQuery(boolean enable) {
        MessagingAnalytics.setDeliveryMetricsExportToBigQuery(enable);
    }

    synchronized void setSyncScheduledOrRunning(boolean bl) {
        this.syncScheduledOrRunning = bl;
    }

    private synchronized void startSync() {
        if (!this.syncScheduledOrRunning) {
            this.syncWithDelaySecondsInternal(0L);
            return;
        }
    }

    private void startSyncIfNecessary() {
        FirebaseInstanceIdInternal firebaseInstanceIdInternal = this.iid;
        if (firebaseInstanceIdInternal != null) {
            firebaseInstanceIdInternal.getToken();
            return;
        }
        if (this.tokenNeedsRefresh(this.getTokenWithoutTriggeringSync())) {
            this.startSync();
            return;
        }
    }

    synchronized void syncWithDelaySecondsInternal(long l) {
        long l2 = Math.max(30L, l + l);
        long l3 = MAX_DELAY_SEC;
        l2 = Math.min(l2, l3);
        SyncTask syncTask = new SyncTask(this, l2);
        this.enqueueTaskWithDelaySeconds(syncTask, l);
        this.syncScheduledOrRunning = true;
    }

    @NonNull
    public boolean deliveryMetricsExportToBigQueryEnabled() {
        return MessagingAnalytics.deliveryMetricsExportToBigQueryEnabled();
    }

    public boolean isAutoInitEnabled() {
        return this.autoInit.isEnabled();
    }

    @VisibleForTesting
    boolean isGmsCorePresent() {
        return this.metadata.isGmscorePresent();
    }

    public boolean isNotificationDelegationEnabled() {
        return ProxyNotificationInitializer.isProxyNotificationEnabled(this.context);
    }

    @VisibleForTesting
    boolean tokenNeedsRefresh(@Nullable Store.Token token) {
        return token == null || token.needsRefresh(this.metadata.getAppVersionCode());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AutoInit {
        private final Subscriber subscriber;
        @GuardedBy(value="this")
        private boolean initialized;
        @GuardedBy(value="this")
        @Nullable
        private EventHandler<DataCollectionDefaultChange> dataCollectionDefaultChangeEventHandler;
        @GuardedBy(value="this")
        @Nullable
        private Boolean autoInitEnabled;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        private Boolean readEnabled() {
            Object object = ((AutoInit)object).FirebaseMessaging.this.firebaseApp.getApplicationContext();
            SharedPreferences sharedPreferences = object.getSharedPreferences("com.google.firebase.messaging", 0);
            if (sharedPreferences.contains("auto_init")) {
                return sharedPreferences.getBoolean("auto_init", false);
            }
            try {
                sharedPreferences = object.getPackageManager();
                if (sharedPreferences == null) return null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
            object = sharedPreferences.getApplicationInfo(object.getPackageName(), 128);
            if (object == null) return null;
            sharedPreferences = ((ApplicationInfo)object).metaData;
            if (sharedPreferences == null) return null;
            boolean bl = ((ApplicationInfo)object).metaData.containsKey("firebase_messaging_auto_init_enabled");
            if (!bl) return null;
            return ((ApplicationInfo)object).metaData.getBoolean("firebase_messaging_auto_init_enabled");
        }

        AutoInit(Subscriber subscriber) {
            this.subscriber = subscriber;
        }

        synchronized void initialize() {
            if (this.initialized) {
                return;
            }
            this.autoInitEnabled = this.readEnabled();
            if (this.autoInitEnabled == null) {
                FirebaseMessaging$AutoInit$$ExternalSyntheticLambda0 firebaseMessaging$AutoInit$$ExternalSyntheticLambda0;
                this.dataCollectionDefaultChangeEventHandler = firebaseMessaging$AutoInit$$ExternalSyntheticLambda0 = new FirebaseMessaging$AutoInit$$ExternalSyntheticLambda0(this);
                this.subscriber.subscribe(DataCollectionDefaultChange.class, this.dataCollectionDefaultChangeEventHandler);
            }
            this.initialized = true;
        }

        /* synthetic */ void lambda$initialize$0$com-google-firebase-messaging-FirebaseMessaging$AutoInit(Event event) {
            if (this.isEnabled()) {
                FirebaseMessaging.this.startSyncIfNecessary();
                return;
            }
        }

        synchronized void setEnabled(boolean bl) {
            this.initialize();
            SharedPreferences.Editor editor = this.dataCollectionDefaultChangeEventHandler;
            if (editor != null) {
                this.subscriber.unsubscribe(DataCollectionDefaultChange.class, editor);
                this.dataCollectionDefaultChangeEventHandler = null;
            }
            editor = FirebaseMessaging.this.firebaseApp.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
            editor.putBoolean("auto_init", bl);
            editor.apply();
            if (bl) {
                FirebaseMessaging.this.startSyncIfNecessary();
            }
            this.autoInitEnabled = bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        synchronized boolean isEnabled() {
            this.initialize();
            Boolean bl = this.autoInitEnabled;
            if (bl == null) return FirebaseMessaging.this.firebaseApp.isDataCollectionDefaultEnabled();
            return bl;
        }
    }
}

