/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ImageDownload
implements Closeable {
    private static final int MAX_IMAGE_SIZE_BYTES = 0x100000;
    private final URL url;
    @Nullable
    private volatile Future<?> future;
    @Nullable
    private Task<Bitmap> task;

    @Nullable
    public static ImageDownload create(String imageUrl) {
        if (TextUtils.isEmpty((CharSequence)imageUrl)) {
            return null;
        }
        try {
            return new ImageDownload(new URL(imageUrl));
        }
        catch (MalformedURLException e) {
            Log.w((String)"FirebaseMessaging", (String)("Not downloading image, bad URL: " + imageUrl));
            return null;
        }
    }

    private ImageDownload(URL url) {
        this.url = url;
    }

    public void start(ExecutorService executor) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.future = executor.submit(() -> {
            try {
                Bitmap bitmap = this.blockingDownload();
                taskCompletionSource.setResult((Object)bitmap);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        this.task = taskCompletionSource.getTask();
    }

    public Task<Bitmap> getTask() {
        return (Task)Preconditions.checkNotNull(this.task);
    }

    public Bitmap blockingDownload() throws IOException {
        byte[] imageBytes;
        Bitmap bitmap;
        if (Log.isLoggable((String)"FirebaseMessaging", (int)4)) {
            Log.i((String)"FirebaseMessaging", (String)("Starting download of: " + this.url));
        }
        if ((bitmap = BitmapFactory.decodeByteArray((byte[])(imageBytes = this.blockingDownloadBytes()), (int)0, (int)imageBytes.length)) == null) {
            throw new IOException("Failed to decode image: " + this.url);
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)("Successfully downloaded image: " + this.url));
        }
        return bitmap;
    }

    private byte[] blockingDownloadBytes() throws IOException {
        byte[] bytes;
        URLConnection connection = this.url.openConnection();
        int contentLength = connection.getContentLength();
        if (contentLength > 0x100000) {
            throw new IOException("Content-Length exceeds max size of 1048576");
        }
        try (InputStream connectionInputStream = connection.getInputStream();){
            bytes = ByteStreams.toByteArray((InputStream)ByteStreams.limit((InputStream)connectionInputStream, (long)0x100001L));
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)2)) {
            Log.v((String)"FirebaseMessaging", (String)("Downloaded " + bytes.length + " bytes from " + this.url));
        }
        if (bytes.length > 0x100000) {
            throw new IOException("Image exceeds max size of 1048576");
        }
        return bytes;
    }

    @Override
    public void close() {
        this.future.cancel(true);
    }
}

