/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.res.Resources;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Arrays;
import java.util.MissingFormatArgumentException;
import org.json.JSONArray;
import org.json.JSONException;

public class NotificationParams {
    private static final int COLOR_TRANSPARENT_IN_HEX = -16777216;
    private static final int EMPTY_JSON_ARRAY_LENGTH = 1;
    private static final int VISIBILITY_MIN = -1;
    private static final int VISIBILITY_MAX = 1;
    private static final String TAG = "NotificationParams";
    @NonNull
    private final Bundle data;

    public NotificationParams(@NonNull Bundle data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.data = new Bundle(data);
    }

    @Nullable
    Integer getNotificationCount() {
        Integer notificationCount = this.getInteger("gcm.n.notification_count");
        if (notificationCount == null) {
            return null;
        }
        if (notificationCount < 0) {
            Log.w((String)"FirebaseMessaging", (String)("notificationCount is invalid: " + notificationCount + ". Skipping setting notificationCount."));
            return null;
        }
        return notificationCount;
    }

    @Nullable
    Integer getNotificationPriority() {
        Integer notificationPriority = this.getInteger("gcm.n.notification_priority");
        if (notificationPriority == null) {
            return null;
        }
        if (notificationPriority < -2 || notificationPriority > 2) {
            Log.w((String)"FirebaseMessaging", (String)("notificationPriority is invalid " + notificationPriority + ". Skipping setting notificationPriority."));
            return null;
        }
        return notificationPriority;
    }

    Integer getVisibility() {
        Integer visibility = this.getInteger("gcm.n.visibility");
        if (visibility == null) {
            return null;
        }
        if (visibility < -1 || visibility > 1) {
            Log.w((String)TAG, (String)("visibility is invalid: " + visibility + ". Skipping setting visibility."));
            return null;
        }
        return visibility;
    }

    public String getString(String key) {
        return this.data.getString(this.normalizePrefix(key));
    }

    private String normalizePrefix(String key) {
        String keyWithOldPrefix;
        if (!this.data.containsKey(key) && key.startsWith("gcm.n.") && this.data.containsKey(keyWithOldPrefix = NotificationParams.keyWithOldPrefix(key))) {
            return keyWithOldPrefix;
        }
        return key;
    }

    public boolean getBoolean(String key) {
        String value = this.getString(key);
        return "1".equals(value) || Boolean.parseBoolean(value);
    }

    public Integer getInteger(String key) {
        String value = this.getString(key);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)("Couldn't parse value of " + NotificationParams.userFriendlyKey(key) + "(" + value + ") into an int"));
            }
        }
        return null;
    }

    public Long getLong(String key) {
        String value = this.getString(key);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)("Couldn't parse value of " + NotificationParams.userFriendlyKey(key) + "(" + value + ") into a long"));
            }
        }
        return null;
    }

    @Nullable
    public String getLocalizationResourceForKey(String key) {
        return this.getString(key + "_loc_key");
    }

    @Nullable
    public Object[] getLocalizationArgsForKey(String key) {
        JSONArray jsonArray = this.getJSONArray(key + "_loc_args");
        if (jsonArray == null) {
            return null;
        }
        Object[] args = new String[jsonArray.length()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = jsonArray.optString(i);
        }
        return args;
    }

    @Nullable
    public JSONArray getJSONArray(String key) {
        String json = this.getString(key);
        if (!TextUtils.isEmpty((CharSequence)json)) {
            try {
                return new JSONArray(json);
            }
            catch (JSONException e) {
                Log.w((String)TAG, (String)("Malformed JSON for key " + NotificationParams.userFriendlyKey(key) + ": " + json + ", falling back to default"));
            }
        }
        return null;
    }

    private static String userFriendlyKey(String key) {
        if (key.startsWith("gcm.n.")) {
            return key.substring("gcm.n.".length());
        }
        return key;
    }

    @Nullable
    public Uri getLink() {
        String link = this.getString("gcm.n.link_android");
        if (TextUtils.isEmpty((CharSequence)link)) {
            link = this.getString("gcm.n.link");
        }
        if (!TextUtils.isEmpty((CharSequence)link)) {
            return Uri.parse((String)link);
        }
        return null;
    }

    @Nullable
    public String getSoundResourceName() {
        String sound = this.getString("gcm.n.sound2");
        if (TextUtils.isEmpty((CharSequence)sound)) {
            sound = this.getString("gcm.n.sound");
        }
        return sound;
    }

    @Nullable
    public long[] getVibrateTimings() {
        JSONArray jsonArray = this.getJSONArray("gcm.n.vibrate_timings");
        if (jsonArray == null) {
            return null;
        }
        try {
            if (jsonArray.length() <= 1) {
                throw new JSONException("vibrateTimings have invalid length");
            }
            long[] result = new long[jsonArray.length()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = jsonArray.optLong(i);
            }
            return result;
        }
        catch (NumberFormatException | JSONException e) {
            Log.w((String)TAG, (String)("User defined vibrateTimings is invalid: " + jsonArray + ". Skipping setting vibrateTimings."));
            return null;
        }
    }

    @Nullable
    int[] getLightSettings() {
        JSONArray lightSettings = this.getJSONArray("gcm.n.light_settings");
        if (lightSettings == null) {
            return null;
        }
        int[] result = new int[3];
        try {
            if (lightSettings.length() != 3) {
                throw new JSONException("lightSettings don't have all three fields");
            }
            result[0] = NotificationParams.getLightColor(lightSettings.optString(0));
            result[1] = lightSettings.optInt(1);
            result[2] = lightSettings.optInt(2);
            return result;
        }
        catch (JSONException e) {
            Log.w((String)TAG, (String)("LightSettings is invalid: " + lightSettings + ". Skipping setting LightSettings"));
        }
        catch (IllegalArgumentException e) {
            Log.w((String)TAG, (String)("LightSettings is invalid: " + lightSettings + ". " + e.getMessage() + ". Skipping setting LightSettings"));
        }
        return null;
    }

    public Bundle paramsWithReservedKeysRemoved() {
        Bundle cleanedData = new Bundle(this.data);
        for (String key : this.data.keySet()) {
            if (!NotificationParams.isReservedKey(key)) continue;
            cleanedData.remove(key);
        }
        return cleanedData;
    }

    public Bundle paramsForAnalyticsIntent() {
        Bundle analyticsBundle = new Bundle(this.data);
        for (String key : this.data.keySet()) {
            if (NotificationParams.isAnalyticsKey(key)) continue;
            analyticsBundle.remove(key);
        }
        return analyticsBundle;
    }

    @Nullable
    public String getLocalizedString(Resources resources, String packageName, String key) {
        String resourceKey = this.getLocalizationResourceForKey(key);
        if (TextUtils.isEmpty((CharSequence)resourceKey)) {
            return null;
        }
        int id = resources.getIdentifier(resourceKey, "string", packageName);
        if (id == 0) {
            Log.w((String)TAG, (String)(NotificationParams.userFriendlyKey(key + "_loc_key") + " resource not found: " + key + " Default value will be used."));
            return null;
        }
        Object[] args = this.getLocalizationArgsForKey(key);
        if (args == null) {
            return resources.getString(id);
        }
        try {
            return resources.getString(id, args);
        }
        catch (MissingFormatArgumentException e) {
            Log.w((String)TAG, (String)("Missing format argument for " + NotificationParams.userFriendlyKey(key) + ": " + Arrays.toString(args) + " Default value will be used."), (Throwable)e);
            return null;
        }
    }

    public String getPossiblyLocalizedString(Resources resources, String packageName, String key) {
        String unlocalized = this.getString(key);
        if (!TextUtils.isEmpty((CharSequence)unlocalized)) {
            return unlocalized;
        }
        return this.getLocalizedString(resources, packageName, key);
    }

    public boolean hasImage() {
        return !TextUtils.isEmpty((CharSequence)this.getString("gcm.n.image"));
    }

    public String getNotificationChannelId() {
        return this.getString("gcm.n.android_channel_id");
    }

    private static boolean isAnalyticsKey(String key) {
        return key.startsWith("google.c.a.") || key.equals("from");
    }

    private static boolean isReservedKey(String key) {
        return key.startsWith("google.c.") || key.startsWith("gcm.n.") || key.startsWith("gcm.notification.");
    }

    private static int getLightColor(String color) {
        int result = Color.parseColor((String)color);
        if (result == -16777216) {
            throw new IllegalArgumentException("Transparent color is invalid");
        }
        return result;
    }

    public boolean isNotification() {
        return this.getBoolean("gcm.n.e");
    }

    public static boolean isNotification(Bundle data) {
        return "1".equals(data.getString("gcm.n.e")) || "1".equals(data.getString(NotificationParams.keyWithOldPrefix("gcm.n.e")));
    }

    private static String keyWithOldPrefix(String key) {
        if (!key.startsWith("gcm.n.")) {
            return key;
        }
        return key.replace("gcm.n.", "gcm.notification.");
    }
}

