/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.google.firebase.messaging.MessagingAnalytics;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

class FcmLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private final Set<Intent> seenIntents = Collections.newSetFromMap(new WeakHashMap());

    FcmLifecycleCallbacks() {
    }

    @SuppressLint(value={"ThreadPoolCreation"})
    public void onActivityCreated(Activity createdActivity, Bundle instanceState) {
        Intent startingIntent = createdActivity.getIntent();
        if (startingIntent == null || !this.seenIntents.add(startingIntent)) {
            return;
        }
        if (Build.VERSION.SDK_INT <= 25) {
            new Handler(Looper.getMainLooper()).post(() -> this.logNotificationOpen(startingIntent));
        } else {
            this.logNotificationOpen(startingIntent);
        }
    }

    public void onActivityPaused(Activity pausedActivity) {
        if (pausedActivity.isFinishing()) {
            this.seenIntents.remove(pausedActivity.getIntent());
        }
    }

    public void onActivityDestroyed(Activity destroyedActivity) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    private void logNotificationOpen(Intent startingIntent) {
        Bundle analyticsData = null;
        try {
            Bundle extras = startingIntent.getExtras();
            if (extras != null) {
                analyticsData = extras.getBundle("gcm.n.analytics_data");
            }
        }
        catch (RuntimeException e) {
            Log.w((String)"FirebaseMessaging", (String)"Failed trying to get analytics data from Intent extras.", (Throwable)e);
        }
        if (MessagingAnalytics.shouldUploadScionMetrics(analyticsData)) {
            MessagingAnalytics.logNotificationOpen(analyticsData);
        }
    }
}

