/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.firebase.messaging.SharedPreferencesQueue;
import com.google.firebase.messaging.TopicOperation;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;

final class TopicsStore {
    @VisibleForTesting
    static final String PREFERENCES = "com.google.android.gms.appid";
    @VisibleForTesting
    static final String KEY_TOPIC_OPERATIONS_QUEUE = "topic_operation_queue";
    private static final String DIVIDER_QUEUE_OPERATIONS = ",";
    @GuardedBy(value="TopicsStore.class")
    private static WeakReference<TopicsStore> topicsStoreWeakReference;
    private final SharedPreferences sharedPreferences;
    private SharedPreferencesQueue topicOperationsQueue;
    private final Executor syncExecutor;

    private TopicsStore(SharedPreferences sharedPrefs, Executor executor) {
        this.syncExecutor = executor;
        this.sharedPreferences = sharedPrefs;
    }

    @WorkerThread
    private synchronized void initStore() {
        this.topicOperationsQueue = SharedPreferencesQueue.createInstance(this.sharedPreferences, KEY_TOPIC_OPERATIONS_QUEUE, DIVIDER_QUEUE_OPERATIONS, this.syncExecutor);
    }

    @WorkerThread
    public static synchronized TopicsStore getInstance(Context context, Executor executor) {
        TopicsStore store = null;
        if (topicsStoreWeakReference != null) {
            store = (TopicsStore)topicsStoreWeakReference.get();
        }
        if (store == null) {
            SharedPreferences sharedPrefs = context.getSharedPreferences(PREFERENCES, 0);
            store = new TopicsStore(sharedPrefs, executor);
            store.initStore();
            topicsStoreWeakReference = new WeakReference<TopicsStore>(store);
        }
        return store;
    }

    @VisibleForTesting
    static synchronized void clearCaches() {
        if (topicsStoreWeakReference != null) {
            topicsStoreWeakReference.clear();
        }
    }

    @Nullable
    synchronized TopicOperation getNextTopicOperation() {
        String entry = this.topicOperationsQueue.peek();
        return TopicOperation.from(entry);
    }

    synchronized boolean addTopicOperation(TopicOperation topicOperation) {
        return this.topicOperationsQueue.add(topicOperation.serialize());
    }

    synchronized boolean removeTopicOperation(TopicOperation topicOperation) {
        return this.topicOperationsQueue.remove(topicOperation.serialize());
    }

    @Nullable
    synchronized TopicOperation pollTopicOperation() {
        try {
            return TopicOperation.from(this.topicOperationsQueue.remove());
        }
        catch (NoSuchElementException e) {
            Log.e((String)"FirebaseMessaging", (String)"Polling operation queue failed");
            return null;
        }
    }

    @NonNull
    synchronized List<TopicOperation> getOperations() {
        List<String> items = this.topicOperationsQueue.toList();
        ArrayList<TopicOperation> operations = new ArrayList<TopicOperation>(items.size());
        for (String item : items) {
            operations.add(TopicOperation.from(item));
        }
        return operations;
    }

    synchronized void clearTopicOperations() {
        this.topicOperationsQueue.clear();
    }
}

