// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: firebase/perf/v1/perf_metric.proto

package com.google.firebase.perf.v1;

/**
 * <pre>
 * Metric which represents the latency, bandwidth consumption and other details
 * about a network request captured by the firebase sdk.
 * Next tag: 14
 * </pre>
 *
 * Protobuf type {@code firebase.perf.v1.NetworkRequestMetric}
 */
public  final class NetworkRequestMetric extends
    com.google.protobuf.GeneratedMessageLite<
        NetworkRequestMetric, NetworkRequestMetric.Builder> implements
    // @@protoc_insertion_point(message_implements:firebase.perf.v1.NetworkRequestMetric)
    NetworkRequestMetricOrBuilder {
  private NetworkRequestMetric() {
    url_ = "";
    responseContentType_ = "";
    perfSessions_ = emptyProtobufList();
  }
  /**
   * <pre>
   * Supported HTTP methods for aggregating network requests. All network
   * requests that can not be classified into the 9 methods below should be set
   * to HTTP_METHOD_UNKNOWN.
   * </pre>
   *
   * Protobuf enum {@code firebase.perf.v1.NetworkRequestMetric.HttpMethod}
   */
  public enum HttpMethod
      implements com.google.protobuf.Internal.EnumLite {
    /**
     * <code>HTTP_METHOD_UNKNOWN = 0;</code>
     */
    HTTP_METHOD_UNKNOWN(0),
    /**
     * <code>GET = 1;</code>
     */
    GET(1),
    /**
     * <code>PUT = 2;</code>
     */
    PUT(2),
    /**
     * <code>POST = 3;</code>
     */
    POST(3),
    /**
     * <code>DELETE = 4;</code>
     */
    DELETE(4),
    /**
     * <code>HEAD = 5;</code>
     */
    HEAD(5),
    /**
     * <code>PATCH = 6;</code>
     */
    PATCH(6),
    /**
     * <code>OPTIONS = 7;</code>
     */
    OPTIONS(7),
    /**
     * <code>TRACE = 8;</code>
     */
    TRACE(8),
    /**
     * <code>CONNECT = 9;</code>
     */
    CONNECT(9),
    ;

    /**
     * <code>HTTP_METHOD_UNKNOWN = 0;</code>
     */
    public static final int HTTP_METHOD_UNKNOWN_VALUE = 0;
    /**
     * <code>GET = 1;</code>
     */
    public static final int GET_VALUE = 1;
    /**
     * <code>PUT = 2;</code>
     */
    public static final int PUT_VALUE = 2;
    /**
     * <code>POST = 3;</code>
     */
    public static final int POST_VALUE = 3;
    /**
     * <code>DELETE = 4;</code>
     */
    public static final int DELETE_VALUE = 4;
    /**
     * <code>HEAD = 5;</code>
     */
    public static final int HEAD_VALUE = 5;
    /**
     * <code>PATCH = 6;</code>
     */
    public static final int PATCH_VALUE = 6;
    /**
     * <code>OPTIONS = 7;</code>
     */
    public static final int OPTIONS_VALUE = 7;
    /**
     * <code>TRACE = 8;</code>
     */
    public static final int TRACE_VALUE = 8;
    /**
     * <code>CONNECT = 9;</code>
     */
    public static final int CONNECT_VALUE = 9;


    @java.lang.Override
    public final int getNumber() {
      return value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HttpMethod valueOf(int value) {
      return forNumber(value);
    }

    public static HttpMethod forNumber(int value) {
      switch (value) {
        case 0: return HTTP_METHOD_UNKNOWN;
        case 1: return GET;
        case 2: return PUT;
        case 3: return POST;
        case 4: return DELETE;
        case 5: return HEAD;
        case 6: return PATCH;
        case 7: return OPTIONS;
        case 8: return TRACE;
        case 9: return CONNECT;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<HttpMethod>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        HttpMethod> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<HttpMethod>() {
            @java.lang.Override
            public HttpMethod findValueByNumber(int number) {
              return HttpMethod.forNumber(number);
            }
          };

    public static com.google.protobuf.Internal.EnumVerifier 
        internalGetVerifier() {
      return HttpMethodVerifier.INSTANCE;
    }

    private static final class HttpMethodVerifier implements 
         com.google.protobuf.Internal.EnumVerifier { 
            static final com.google.protobuf.Internal.EnumVerifier           INSTANCE = new HttpMethodVerifier();
            @java.lang.Override
            public boolean isInRange(int number) {
              return HttpMethod.forNumber(number) != null;
            }
          };

    private final int value;

    private HttpMethod(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:firebase.perf.v1.NetworkRequestMetric.HttpMethod)
  }

  /**
   * <pre>
   * Info about the type of client error during network call.
   * </pre>
   *
   * Protobuf enum {@code firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason}
   */
  public enum NetworkClientErrorReason
      implements com.google.protobuf.Internal.EnumLite {
    /**
     * <pre>
     * Unspecified Network Client Error Reason.
     * </pre>
     *
     * <code>NETWORK_CLIENT_ERROR_REASON_UNKNOWN = 0;</code>
     */
    NETWORK_CLIENT_ERROR_REASON_UNKNOWN(0),
    /**
     * <pre>
     * No attempt made to classify the error.
     * </pre>
     *
     * <code>GENERIC_CLIENT_ERROR = 1;</code>
     */
    GENERIC_CLIENT_ERROR(1),
    ;

    /**
     * <pre>
     * Unspecified Network Client Error Reason.
     * </pre>
     *
     * <code>NETWORK_CLIENT_ERROR_REASON_UNKNOWN = 0;</code>
     */
    public static final int NETWORK_CLIENT_ERROR_REASON_UNKNOWN_VALUE = 0;
    /**
     * <pre>
     * No attempt made to classify the error.
     * </pre>
     *
     * <code>GENERIC_CLIENT_ERROR = 1;</code>
     */
    public static final int GENERIC_CLIENT_ERROR_VALUE = 1;


    @java.lang.Override
    public final int getNumber() {
      return value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NetworkClientErrorReason valueOf(int value) {
      return forNumber(value);
    }

    public static NetworkClientErrorReason forNumber(int value) {
      switch (value) {
        case 0: return NETWORK_CLIENT_ERROR_REASON_UNKNOWN;
        case 1: return GENERIC_CLIENT_ERROR;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NetworkClientErrorReason>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        NetworkClientErrorReason> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<NetworkClientErrorReason>() {
            @java.lang.Override
            public NetworkClientErrorReason findValueByNumber(int number) {
              return NetworkClientErrorReason.forNumber(number);
            }
          };

    public static com.google.protobuf.Internal.EnumVerifier 
        internalGetVerifier() {
      return NetworkClientErrorReasonVerifier.INSTANCE;
    }

    private static final class NetworkClientErrorReasonVerifier implements 
         com.google.protobuf.Internal.EnumVerifier { 
            static final com.google.protobuf.Internal.EnumVerifier           INSTANCE = new NetworkClientErrorReasonVerifier();
            @java.lang.Override
            public boolean isInRange(int number) {
              return NetworkClientErrorReason.forNumber(number) != null;
            }
          };

    private final int value;

    private NetworkClientErrorReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason)
  }

  private int bitField0_;
  public static final int URL_FIELD_NUMBER = 1;
  private java.lang.String url_;
  /**
   * <pre>
   * The parameterless url to which the network request was made. The sdk will
   * redact the unnecessary components of the URL and only log the components
   * which are useful. For a url of the form
   * scheme://host[:port]/path[?params][#fragment], the sdk should only log
   * scheme://host[:port]/path
   * Example:
   * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
   * Logged Url: https://wwww.google.com/maps/cities
   * </pre>
   *
   * <code>optional string url = 1;</code>
   * @return Whether the url field is set.
   */
  @java.lang.Override
  public boolean hasUrl() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * The parameterless url to which the network request was made. The sdk will
   * redact the unnecessary components of the URL and only log the components
   * which are useful. For a url of the form
   * scheme://host[:port]/path[?params][#fragment], the sdk should only log
   * scheme://host[:port]/path
   * Example:
   * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
   * Logged Url: https://wwww.google.com/maps/cities
   * </pre>
   *
   * <code>optional string url = 1;</code>
   * @return The url.
   */
  @java.lang.Override
  public java.lang.String getUrl() {
    return url_;
  }
  /**
   * <pre>
   * The parameterless url to which the network request was made. The sdk will
   * redact the unnecessary components of the URL and only log the components
   * which are useful. For a url of the form
   * scheme://host[:port]/path[?params][#fragment], the sdk should only log
   * scheme://host[:port]/path
   * Example:
   * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
   * Logged Url: https://wwww.google.com/maps/cities
   * </pre>
   *
   * <code>optional string url = 1;</code>
   * @return The bytes for url.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getUrlBytes() {
    return com.google.protobuf.ByteString.copyFromUtf8(url_);
  }
  /**
   * <pre>
   * The parameterless url to which the network request was made. The sdk will
   * redact the unnecessary components of the URL and only log the components
   * which are useful. For a url of the form
   * scheme://host[:port]/path[?params][#fragment], the sdk should only log
   * scheme://host[:port]/path
   * Example:
   * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
   * Logged Url: https://wwww.google.com/maps/cities
   * </pre>
   *
   * <code>optional string url = 1;</code>
   * @param value The url to set.
   */
  private void setUrl(
      java.lang.String value) {
    java.lang.Class<?> valueClass = value.getClass();
  bitField0_ |= 0x00000001;
    url_ = value;
  }
  /**
   * <pre>
   * The parameterless url to which the network request was made. The sdk will
   * redact the unnecessary components of the URL and only log the components
   * which are useful. For a url of the form
   * scheme://host[:port]/path[?params][#fragment], the sdk should only log
   * scheme://host[:port]/path
   * Example:
   * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
   * Logged Url: https://wwww.google.com/maps/cities
   * </pre>
   *
   * <code>optional string url = 1;</code>
   */
  private void clearUrl() {
    bitField0_ = (bitField0_ & ~0x00000001);
    url_ = getDefaultInstance().getUrl();
  }
  /**
   * <pre>
   * The parameterless url to which the network request was made. The sdk will
   * redact the unnecessary components of the URL and only log the components
   * which are useful. For a url of the form
   * scheme://host[:port]/path[?params][#fragment], the sdk should only log
   * scheme://host[:port]/path
   * Example:
   * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
   * Logged Url: https://wwww.google.com/maps/cities
   * </pre>
   *
   * <code>optional string url = 1;</code>
   * @param value The bytes for url to set.
   */
  private void setUrlBytes(
      com.google.protobuf.ByteString value) {
    url_ = value.toStringUtf8();
    bitField0_ |= 0x00000001;
  }

  public static final int HTTP_METHOD_FIELD_NUMBER = 2;
  private int httpMethod_;
  /**
   * <pre>
   * The HTTP verb for the network request. Common values include GET,
   * PUT, POST and DELETE
   * </pre>
   *
   * <code>optional .firebase.perf.v1.NetworkRequestMetric.HttpMethod http_method = 2;</code>
   * @return Whether the httpMethod field is set.
   */
  @java.lang.Override
  public boolean hasHttpMethod() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * The HTTP verb for the network request. Common values include GET,
   * PUT, POST and DELETE
   * </pre>
   *
   * <code>optional .firebase.perf.v1.NetworkRequestMetric.HttpMethod http_method = 2;</code>
   * @return The httpMethod.
   */
  @java.lang.Override
  public com.google.firebase.perf.v1.NetworkRequestMetric.HttpMethod getHttpMethod() {
    com.google.firebase.perf.v1.NetworkRequestMetric.HttpMethod result = com.google.firebase.perf.v1.NetworkRequestMetric.HttpMethod.forNumber(httpMethod_);
    return result == null ? com.google.firebase.perf.v1.NetworkRequestMetric.HttpMethod.HTTP_METHOD_UNKNOWN : result;
  }
  /**
   * <pre>
   * The HTTP verb for the network request. Common values include GET,
   * PUT, POST and DELETE
   * </pre>
   *
   * <code>optional .firebase.perf.v1.NetworkRequestMetric.HttpMethod http_method = 2;</code>
   * @param value The httpMethod to set.
   */
  private void setHttpMethod(com.google.firebase.perf.v1.NetworkRequestMetric.HttpMethod value) {
    httpMethod_ = value.getNumber();
    bitField0_ |= 0x00000002;
  }
  /**
   * <pre>
   * The HTTP verb for the network request. Common values include GET,
   * PUT, POST and DELETE
   * </pre>
   *
   * <code>optional .firebase.perf.v1.NetworkRequestMetric.HttpMethod http_method = 2;</code>
   */
  private void clearHttpMethod() {
    bitField0_ = (bitField0_ & ~0x00000002);
    httpMethod_ = 0;
  }

  public static final int REQUEST_PAYLOAD_BYTES_FIELD_NUMBER = 3;
  private long requestPayloadBytes_;
  /**
   * <pre>
   * The size of the payload in the request.
   * </pre>
   *
   * <code>optional int64 request_payload_bytes = 3;</code>
   * @return Whether the requestPayloadBytes field is set.
   */
  @java.lang.Override
  public boolean hasRequestPayloadBytes() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * The size of the payload in the request.
   * </pre>
   *
   * <code>optional int64 request_payload_bytes = 3;</code>
   * @return The requestPayloadBytes.
   */
  @java.lang.Override
  public long getRequestPayloadBytes() {
    return requestPayloadBytes_;
  }
  /**
   * <pre>
   * The size of the payload in the request.
   * </pre>
   *
   * <code>optional int64 request_payload_bytes = 3;</code>
   * @param value The requestPayloadBytes to set.
   */
  private void setRequestPayloadBytes(long value) {
    bitField0_ |= 0x00000004;
    requestPayloadBytes_ = value;
  }
  /**
   * <pre>
   * The size of the payload in the request.
   * </pre>
   *
   * <code>optional int64 request_payload_bytes = 3;</code>
   */
  private void clearRequestPayloadBytes() {
    bitField0_ = (bitField0_ & ~0x00000004);
    requestPayloadBytes_ = 0L;
  }

  public static final int RESPONSE_PAYLOAD_BYTES_FIELD_NUMBER = 4;
  private long responsePayloadBytes_;
  /**
   * <pre>
   * The size of the payload in the response.
   * </pre>
   *
   * <code>optional int64 response_payload_bytes = 4;</code>
   * @return Whether the responsePayloadBytes field is set.
   */
  @java.lang.Override
  public boolean hasResponsePayloadBytes() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * The size of the payload in the response.
   * </pre>
   *
   * <code>optional int64 response_payload_bytes = 4;</code>
   * @return The responsePayloadBytes.
   */
  @java.lang.Override
  public long getResponsePayloadBytes() {
    return responsePayloadBytes_;
  }
  /**
   * <pre>
   * The size of the payload in the response.
   * </pre>
   *
   * <code>optional int64 response_payload_bytes = 4;</code>
   * @param value The responsePayloadBytes to set.
   */
  private void setResponsePayloadBytes(long value) {
    bitField0_ |= 0x00000008;
    responsePayloadBytes_ = value;
  }
  /**
   * <pre>
   * The size of the payload in the response.
   * </pre>
   *
   * <code>optional int64 response_payload_bytes = 4;</code>
   */
  private void clearResponsePayloadBytes() {
    bitField0_ = (bitField0_ & ~0x00000008);
    responsePayloadBytes_ = 0L;
  }

  public static final int NETWORK_CLIENT_ERROR_REASON_FIELD_NUMBER = 11;
  private int networkClientErrorReason_;
  /**
   * <pre>
   * The client error received from the networking library.
   * Do not record a client error if we have HTTP response code available.
   * </pre>
   *
   * <code>optional .firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason network_client_error_reason = 11;</code>
   * @return Whether the networkClientErrorReason field is set.
   */
  @java.lang.Override
  public boolean hasNetworkClientErrorReason() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * The client error received from the networking library.
   * Do not record a client error if we have HTTP response code available.
   * </pre>
   *
   * <code>optional .firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason network_client_error_reason = 11;</code>
   * @return The networkClientErrorReason.
   */
  @java.lang.Override
  public com.google.firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason getNetworkClientErrorReason() {
    com.google.firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason result = com.google.firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason.forNumber(networkClientErrorReason_);
    return result == null ? com.google.firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason.NETWORK_CLIENT_ERROR_REASON_UNKNOWN : result;
  }
  /**
   * <pre>
   * The client error received from the networking library.
   * Do not record a client error if we have HTTP response code available.
   * </pre>
   *
   * <code>optional .firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason network_client_error_reason = 11;</code>
   * @param value The networkClientErrorReason to set.
   */
  private void setNetworkClientErrorReason(com.google.firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason value) {
    networkClientErrorReason_ = value.getNumber();
    bitField0_ |= 0x00000010;
  }
  /**
   * <pre>
   * The client error received from the networking library.
   * Do not record a client error if we have HTTP response code available.
   * </pre>
   *
   * <code>optional .firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason network_client_error_reason = 11;</code>
   */
  private void clearNetworkClientErrorReason() {
    bitField0_ = (bitField0_ & ~0x00000010);
    networkClientErrorReason_ = 0;
  }

  public static final int HTTP_RESPONSE_CODE_FIELD_NUMBER = 5;
  private int httpResponseCode_;
  /**
   * <pre>
   * The Http response code received from the server.
   * </pre>
   *
   * <code>optional int32 http_response_code = 5;</code>
   * @return Whether the httpResponseCode field is set.
   */
  @java.lang.Override
  public boolean hasHttpResponseCode() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * The Http response code received from the server.
   * </pre>
   *
   * <code>optional int32 http_response_code = 5;</code>
   * @return The httpResponseCode.
   */
  @java.lang.Override
  public int getHttpResponseCode() {
    return httpResponseCode_;
  }
  /**
   * <pre>
   * The Http response code received from the server.
   * </pre>
   *
   * <code>optional int32 http_response_code = 5;</code>
   * @param value The httpResponseCode to set.
   */
  private void setHttpResponseCode(int value) {
    bitField0_ |= 0x00000020;
    httpResponseCode_ = value;
  }
  /**
   * <pre>
   * The Http response code received from the server.
   * </pre>
   *
   * <code>optional int32 http_response_code = 5;</code>
   */
  private void clearHttpResponseCode() {
    bitField0_ = (bitField0_ & ~0x00000020);
    httpResponseCode_ = 0;
  }

  public static final int RESPONSE_CONTENT_TYPE_FIELD_NUMBER = 6;
  private java.lang.String responseContentType_;
  /**
   * <pre>
   * The value of the content type header in the response.
   * </pre>
   *
   * <code>optional string response_content_type = 6;</code>
   * @return Whether the responseContentType field is set.
   */
  @java.lang.Override
  public boolean hasResponseContentType() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * The value of the content type header in the response.
   * </pre>
   *
   * <code>optional string response_content_type = 6;</code>
   * @return The responseContentType.
   */
  @java.lang.Override
  public java.lang.String getResponseContentType() {
    return responseContentType_;
  }
  /**
   * <pre>
   * The value of the content type header in the response.
   * </pre>
   *
   * <code>optional string response_content_type = 6;</code>
   * @return The bytes for responseContentType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResponseContentTypeBytes() {
    return com.google.protobuf.ByteString.copyFromUtf8(responseContentType_);
  }
  /**
   * <pre>
   * The value of the content type header in the response.
   * </pre>
   *
   * <code>optional string response_content_type = 6;</code>
   * @param value The responseContentType to set.
   */
  private void setResponseContentType(
      java.lang.String value) {
    java.lang.Class<?> valueClass = value.getClass();
  bitField0_ |= 0x00000040;
    responseContentType_ = value;
  }
  /**
   * <pre>
   * The value of the content type header in the response.
   * </pre>
   *
   * <code>optional string response_content_type = 6;</code>
   */
  private void clearResponseContentType() {
    bitField0_ = (bitField0_ & ~0x00000040);
    responseContentType_ = getDefaultInstance().getResponseContentType();
  }
  /**
   * <pre>
   * The value of the content type header in the response.
   * </pre>
   *
   * <code>optional string response_content_type = 6;</code>
   * @param value The bytes for responseContentType to set.
   */
  private void setResponseContentTypeBytes(
      com.google.protobuf.ByteString value) {
    responseContentType_ = value.toStringUtf8();
    bitField0_ |= 0x00000040;
  }

  public static final int CLIENT_START_TIME_US_FIELD_NUMBER = 7;
  private long clientStartTimeUs_;
  /**
   * <pre>
   * The timestamp in microseconds since epoch when the network request was
   * initiated. This time is recorded using the device clock.
   * </pre>
   *
   * <code>optional int64 client_start_time_us = 7;</code>
   * @return Whether the clientStartTimeUs field is set.
   */
  @java.lang.Override
  public boolean hasClientStartTimeUs() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * The timestamp in microseconds since epoch when the network request was
   * initiated. This time is recorded using the device clock.
   * </pre>
   *
   * <code>optional int64 client_start_time_us = 7;</code>
   * @return The clientStartTimeUs.
   */
  @java.lang.Override
  public long getClientStartTimeUs() {
    return clientStartTimeUs_;
  }
  /**
   * <pre>
   * The timestamp in microseconds since epoch when the network request was
   * initiated. This time is recorded using the device clock.
   * </pre>
   *
   * <code>optional int64 client_start_time_us = 7;</code>
   * @param value The clientStartTimeUs to set.
   */
  private void setClientStartTimeUs(long value) {
    bitField0_ |= 0x00000080;
    clientStartTimeUs_ = value;
  }
  /**
   * <pre>
   * The timestamp in microseconds since epoch when the network request was
   * initiated. This time is recorded using the device clock.
   * </pre>
   *
   * <code>optional int64 client_start_time_us = 7;</code>
   */
  private void clearClientStartTimeUs() {
    bitField0_ = (bitField0_ & ~0x00000080);
    clientStartTimeUs_ = 0L;
  }

  public static final int TIME_TO_REQUEST_COMPLETED_US_FIELD_NUMBER = 8;
  private long timeToRequestCompletedUs_;
  /**
   * <pre>
   * The time in microseconds since the start of the network request and the
   * upload of the last request byte.
   * </pre>
   *
   * <code>optional int64 time_to_request_completed_us = 8;</code>
   * @return Whether the timeToRequestCompletedUs field is set.
   */
  @java.lang.Override
  public boolean hasTimeToRequestCompletedUs() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * The time in microseconds since the start of the network request and the
   * upload of the last request byte.
   * </pre>
   *
   * <code>optional int64 time_to_request_completed_us = 8;</code>
   * @return The timeToRequestCompletedUs.
   */
  @java.lang.Override
  public long getTimeToRequestCompletedUs() {
    return timeToRequestCompletedUs_;
  }
  /**
   * <pre>
   * The time in microseconds since the start of the network request and the
   * upload of the last request byte.
   * </pre>
   *
   * <code>optional int64 time_to_request_completed_us = 8;</code>
   * @param value The timeToRequestCompletedUs to set.
   */
  private void setTimeToRequestCompletedUs(long value) {
    bitField0_ |= 0x00000100;
    timeToRequestCompletedUs_ = value;
  }
  /**
   * <pre>
   * The time in microseconds since the start of the network request and the
   * upload of the last request byte.
   * </pre>
   *
   * <code>optional int64 time_to_request_completed_us = 8;</code>
   */
  private void clearTimeToRequestCompletedUs() {
    bitField0_ = (bitField0_ & ~0x00000100);
    timeToRequestCompletedUs_ = 0L;
  }

  public static final int TIME_TO_RESPONSE_INITIATED_US_FIELD_NUMBER = 9;
  private long timeToResponseInitiatedUs_;
  /**
   * <pre>
   * The time in microseconds between the start of the network request and the
   * receipt of the first byte of the response headers.
   * </pre>
   *
   * <code>optional int64 time_to_response_initiated_us = 9;</code>
   * @return Whether the timeToResponseInitiatedUs field is set.
   */
  @java.lang.Override
  public boolean hasTimeToResponseInitiatedUs() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   * <pre>
   * The time in microseconds between the start of the network request and the
   * receipt of the first byte of the response headers.
   * </pre>
   *
   * <code>optional int64 time_to_response_initiated_us = 9;</code>
   * @return The timeToResponseInitiatedUs.
   */
  @java.lang.Override
  public long getTimeToResponseInitiatedUs() {
    return timeToResponseInitiatedUs_;
  }
  /**
   * <pre>
   * The time in microseconds between the start of the network request and the
   * receipt of the first byte of the response headers.
   * </pre>
   *
   * <code>optional int64 time_to_response_initiated_us = 9;</code>
   * @param value The timeToResponseInitiatedUs to set.
   */
  private void setTimeToResponseInitiatedUs(long value) {
    bitField0_ |= 0x00000200;
    timeToResponseInitiatedUs_ = value;
  }
  /**
   * <pre>
   * The time in microseconds between the start of the network request and the
   * receipt of the first byte of the response headers.
   * </pre>
   *
   * <code>optional int64 time_to_response_initiated_us = 9;</code>
   */
  private void clearTimeToResponseInitiatedUs() {
    bitField0_ = (bitField0_ & ~0x00000200);
    timeToResponseInitiatedUs_ = 0L;
  }

  public static final int TIME_TO_RESPONSE_COMPLETED_US_FIELD_NUMBER = 10;
  private long timeToResponseCompletedUs_;
  /**
   * <pre>
   * The time in microseconds between the start of the network request and the
   * receipt of the last response byte.
   * </pre>
   *
   * <code>optional int64 time_to_response_completed_us = 10;</code>
   * @return Whether the timeToResponseCompletedUs field is set.
   */
  @java.lang.Override
  public boolean hasTimeToResponseCompletedUs() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   * <pre>
   * The time in microseconds between the start of the network request and the
   * receipt of the last response byte.
   * </pre>
   *
   * <code>optional int64 time_to_response_completed_us = 10;</code>
   * @return The timeToResponseCompletedUs.
   */
  @java.lang.Override
  public long getTimeToResponseCompletedUs() {
    return timeToResponseCompletedUs_;
  }
  /**
   * <pre>
   * The time in microseconds between the start of the network request and the
   * receipt of the last response byte.
   * </pre>
   *
   * <code>optional int64 time_to_response_completed_us = 10;</code>
   * @param value The timeToResponseCompletedUs to set.
   */
  private void setTimeToResponseCompletedUs(long value) {
    bitField0_ |= 0x00000400;
    timeToResponseCompletedUs_ = value;
  }
  /**
   * <pre>
   * The time in microseconds between the start of the network request and the
   * receipt of the last response byte.
   * </pre>
   *
   * <code>optional int64 time_to_response_completed_us = 10;</code>
   */
  private void clearTimeToResponseCompletedUs() {
    bitField0_ = (bitField0_ & ~0x00000400);
    timeToResponseCompletedUs_ = 0L;
  }

  public static final int CUSTOM_ATTRIBUTES_FIELD_NUMBER = 12;
  private static final class CustomAttributesDefaultEntryHolder {
    static final com.google.protobuf.MapEntryLite<
        java.lang.String, java.lang.String> defaultEntry =
            com.google.protobuf.MapEntryLite
            .<java.lang.String, java.lang.String>newDefaultInstance(
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.STRING,
                "");
  }
  private com.google.protobuf.MapFieldLite<
      java.lang.String, java.lang.String> customAttributes_ =
          com.google.protobuf.MapFieldLite.emptyMapField();
  private com.google.protobuf.MapFieldLite<java.lang.String, java.lang.String>
  internalGetCustomAttributes() {
    return customAttributes_;
  }
  private com.google.protobuf.MapFieldLite<java.lang.String, java.lang.String>
  internalGetMutableCustomAttributes() {
    if (!customAttributes_.isMutable()) {
      customAttributes_ = customAttributes_.mutableCopy();
    }
    return customAttributes_;
  }
  @java.lang.Override

  public int getCustomAttributesCount() {
    return internalGetCustomAttributes().size();
  }
  /**
   * <pre>
   * A map of network-level custom attribute names to values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
   */
  @java.lang.Override

  public boolean containsCustomAttributes(
      java.lang.String key) {
    java.lang.Class<?> keyClass = key.getClass();
    return internalGetCustomAttributes().containsKey(key);
  }
  /**
   * Use {@link #getCustomAttributesMap()} instead.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getCustomAttributes() {
    return getCustomAttributesMap();
  }
  /**
   * <pre>
   * A map of network-level custom attribute names to values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
   */
  @java.lang.Override

  public java.util.Map<java.lang.String, java.lang.String> getCustomAttributesMap() {
    return java.util.Collections.unmodifiableMap(
        internalGetCustomAttributes());
  }
  /**
   * <pre>
   * A map of network-level custom attribute names to values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
   */
  @java.lang.Override

  public java.lang.String getCustomAttributesOrDefault(
      java.lang.String key,
      java.lang.String defaultValue) {
    java.lang.Class<?> keyClass = key.getClass();
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetCustomAttributes();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * A map of network-level custom attribute names to values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
   */
  @java.lang.Override

  public java.lang.String getCustomAttributesOrThrow(
      java.lang.String key) {
    java.lang.Class<?> keyClass = key.getClass();
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetCustomAttributes();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }
  /**
   * <pre>
   * A map of network-level custom attribute names to values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
   */
  private java.util.Map<java.lang.String, java.lang.String>
  getMutableCustomAttributesMap() {
    return internalGetMutableCustomAttributes();
  }

  public static final int PERF_SESSIONS_FIELD_NUMBER = 13;
  private com.google.protobuf.Internal.ProtobufList<com.google.firebase.perf.v1.PerfSession> perfSessions_;
  /**
   * <pre>
   * Sessions across which the network request spanned. A session lasts
   * from one change in the app state (foreground/background) to the next.
   * Basically every foreground and background session gets it's own session id.
   * A network request may span across multiple such sessions. So we need a list
   * to identify which sessions it spanned across.
   * </pre>
   *
   * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.firebase.perf.v1.PerfSession> getPerfSessionsList() {
    return perfSessions_;
  }
  /**
   * <pre>
   * Sessions across which the network request spanned. A session lasts
   * from one change in the app state (foreground/background) to the next.
   * Basically every foreground and background session gets it's own session id.
   * A network request may span across multiple such sessions. So we need a list
   * to identify which sessions it spanned across.
   * </pre>
   *
   * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
   */
  public java.util.List<? extends com.google.firebase.perf.v1.PerfSessionOrBuilder> 
      getPerfSessionsOrBuilderList() {
    return perfSessions_;
  }
  /**
   * <pre>
   * Sessions across which the network request spanned. A session lasts
   * from one change in the app state (foreground/background) to the next.
   * Basically every foreground and background session gets it's own session id.
   * A network request may span across multiple such sessions. So we need a list
   * to identify which sessions it spanned across.
   * </pre>
   *
   * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
   */
  @java.lang.Override
  public int getPerfSessionsCount() {
    return perfSessions_.size();
  }
  /**
   * <pre>
   * Sessions across which the network request spanned. A session lasts
   * from one change in the app state (foreground/background) to the next.
   * Basically every foreground and background session gets it's own session id.
   * A network request may span across multiple such sessions. So we need a list
   * to identify which sessions it spanned across.
   * </pre>
   *
   * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
   */
  @java.lang.Override
  public com.google.firebase.perf.v1.PerfSession getPerfSessions(int index) {
    return perfSessions_.get(index);
  }
  /**
   * <pre>
   * Sessions across which the network request spanned. A session lasts
   * from one change in the app state (foreground/background) to the next.
   * Basically every foreground and background session gets it's own session id.
   * A network request may span across multiple such sessions. So we need a list
   * to identify which sessions it spanned across.
   * </pre>
   *
   * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
   */
  public com.google.firebase.perf.v1.PerfSessionOrBuilder getPerfSessionsOrBuilder(
      int index) {
    return perfSessions_.get(index);
  }
  private void ensurePerfSessionsIsMutable() {
    com.google.protobuf.Internal.ProtobufList<com.google.firebase.perf.v1.PerfSession> tmp = perfSessions_;
    if (!tmp.isModifiable()) {
      perfSessions_ =
          com.google.protobuf.GeneratedMessageLite.mutableCopy(tmp);
     }
  }

  /**
   * <pre>
   * Sessions across which the network request spanned. A session lasts
   * from one change in the app state (foreground/background) to the next.
   * Basically every foreground and background session gets it's own session id.
   * A network request may span across multiple such sessions. So we need a list
   * to identify which sessions it spanned across.
   * </pre>
   *
   * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
   */
  private void setPerfSessions(
      int index, com.google.firebase.perf.v1.PerfSession value) {
    value.getClass();
  ensurePerfSessionsIsMutable();
    perfSessions_.set(index, value);
  }
  /**
   * <pre>
   * Sessions across which the network request spanned. A session lasts
   * from one change in the app state (foreground/background) to the next.
   * Basically every foreground and background session gets it's own session id.
   * A network request may span across multiple such sessions. So we need a list
   * to identify which sessions it spanned across.
   * </pre>
   *
   * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
   */
  private void addPerfSessions(com.google.firebase.perf.v1.PerfSession value) {
    value.getClass();
  ensurePerfSessionsIsMutable();
    perfSessions_.add(value);
  }
  /**
   * <pre>
   * Sessions across which the network request spanned. A session lasts
   * from one change in the app state (foreground/background) to the next.
   * Basically every foreground and background session gets it's own session id.
   * A network request may span across multiple such sessions. So we need a list
   * to identify which sessions it spanned across.
   * </pre>
   *
   * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
   */
  private void addPerfSessions(
      int index, com.google.firebase.perf.v1.PerfSession value) {
    value.getClass();
  ensurePerfSessionsIsMutable();
    perfSessions_.add(index, value);
  }
  /**
   * <pre>
   * Sessions across which the network request spanned. A session lasts
   * from one change in the app state (foreground/background) to the next.
   * Basically every foreground and background session gets it's own session id.
   * A network request may span across multiple such sessions. So we need a list
   * to identify which sessions it spanned across.
   * </pre>
   *
   * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
   */
  private void addAllPerfSessions(
      java.lang.Iterable<? extends com.google.firebase.perf.v1.PerfSession> values) {
    ensurePerfSessionsIsMutable();
    com.google.protobuf.AbstractMessageLite.addAll(
        values, perfSessions_);
  }
  /**
   * <pre>
   * Sessions across which the network request spanned. A session lasts
   * from one change in the app state (foreground/background) to the next.
   * Basically every foreground and background session gets it's own session id.
   * A network request may span across multiple such sessions. So we need a list
   * to identify which sessions it spanned across.
   * </pre>
   *
   * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
   */
  private void clearPerfSessions() {
    perfSessions_ = emptyProtobufList();
  }
  /**
   * <pre>
   * Sessions across which the network request spanned. A session lasts
   * from one change in the app state (foreground/background) to the next.
   * Basically every foreground and background session gets it's own session id.
   * A network request may span across multiple such sessions. So we need a list
   * to identify which sessions it spanned across.
   * </pre>
   *
   * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
   */
  private void removePerfSessions(int index) {
    ensurePerfSessionsIsMutable();
    perfSessions_.remove(index);
  }

  public static com.google.firebase.perf.v1.NetworkRequestMetric parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, data);
  }
  public static com.google.firebase.perf.v1.NetworkRequestMetric parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, data, extensionRegistry);
  }
  public static com.google.firebase.perf.v1.NetworkRequestMetric parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, data);
  }
  public static com.google.firebase.perf.v1.NetworkRequestMetric parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, data, extensionRegistry);
  }
  public static com.google.firebase.perf.v1.NetworkRequestMetric parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, data);
  }
  public static com.google.firebase.perf.v1.NetworkRequestMetric parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, data, extensionRegistry);
  }
  public static com.google.firebase.perf.v1.NetworkRequestMetric parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, input);
  }
  public static com.google.firebase.perf.v1.NetworkRequestMetric parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, input, extensionRegistry);
  }
  public static com.google.firebase.perf.v1.NetworkRequestMetric parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return parseDelimitedFrom(DEFAULT_INSTANCE, input);
  }
  public static com.google.firebase.perf.v1.NetworkRequestMetric parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return parseDelimitedFrom(DEFAULT_INSTANCE, input, extensionRegistry);
  }
  public static com.google.firebase.perf.v1.NetworkRequestMetric parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, input);
  }
  public static com.google.firebase.perf.v1.NetworkRequestMetric parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, input, extensionRegistry);
  }

  public static Builder newBuilder() {
    return (Builder) DEFAULT_INSTANCE.createBuilder();
  }
  public static Builder newBuilder(com.google.firebase.perf.v1.NetworkRequestMetric prototype) {
    return (Builder) DEFAULT_INSTANCE.createBuilder(prototype);
  }

  /**
   * <pre>
   * Metric which represents the latency, bandwidth consumption and other details
   * about a network request captured by the firebase sdk.
   * Next tag: 14
   * </pre>
   *
   * Protobuf type {@code firebase.perf.v1.NetworkRequestMetric}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageLite.Builder<
        com.google.firebase.perf.v1.NetworkRequestMetric, Builder> implements
      // @@protoc_insertion_point(builder_implements:firebase.perf.v1.NetworkRequestMetric)
      com.google.firebase.perf.v1.NetworkRequestMetricOrBuilder {
    // Construct using com.google.firebase.perf.v1.NetworkRequestMetric.newBuilder()
    private Builder() {
      super(DEFAULT_INSTANCE);
    }


    /**
     * <pre>
     * The parameterless url to which the network request was made. The sdk will
     * redact the unnecessary components of the URL and only log the components
     * which are useful. For a url of the form
     * scheme://host[:port]/path[?params][#fragment], the sdk should only log
     * scheme://host[:port]/path
     * Example:
     * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
     * Logged Url: https://wwww.google.com/maps/cities
     * </pre>
     *
     * <code>optional string url = 1;</code>
     * @return Whether the url field is set.
     */
    @java.lang.Override
    public boolean hasUrl() {
      return instance.hasUrl();
    }
    /**
     * <pre>
     * The parameterless url to which the network request was made. The sdk will
     * redact the unnecessary components of the URL and only log the components
     * which are useful. For a url of the form
     * scheme://host[:port]/path[?params][#fragment], the sdk should only log
     * scheme://host[:port]/path
     * Example:
     * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
     * Logged Url: https://wwww.google.com/maps/cities
     * </pre>
     *
     * <code>optional string url = 1;</code>
     * @return The url.
     */
    @java.lang.Override
    public java.lang.String getUrl() {
      return instance.getUrl();
    }
    /**
     * <pre>
     * The parameterless url to which the network request was made. The sdk will
     * redact the unnecessary components of the URL and only log the components
     * which are useful. For a url of the form
     * scheme://host[:port]/path[?params][#fragment], the sdk should only log
     * scheme://host[:port]/path
     * Example:
     * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
     * Logged Url: https://wwww.google.com/maps/cities
     * </pre>
     *
     * <code>optional string url = 1;</code>
     * @return The bytes for url.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getUrlBytes() {
      return instance.getUrlBytes();
    }
    /**
     * <pre>
     * The parameterless url to which the network request was made. The sdk will
     * redact the unnecessary components of the URL and only log the components
     * which are useful. For a url of the form
     * scheme://host[:port]/path[?params][#fragment], the sdk should only log
     * scheme://host[:port]/path
     * Example:
     * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
     * Logged Url: https://wwww.google.com/maps/cities
     * </pre>
     *
     * <code>optional string url = 1;</code>
     * @param value The url to set.
     * @return This builder for chaining.
     */
    public Builder setUrl(
        java.lang.String value) {
      copyOnWrite();
      instance.setUrl(value);
      return this;
    }
    /**
     * <pre>
     * The parameterless url to which the network request was made. The sdk will
     * redact the unnecessary components of the URL and only log the components
     * which are useful. For a url of the form
     * scheme://host[:port]/path[?params][#fragment], the sdk should only log
     * scheme://host[:port]/path
     * Example:
     * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
     * Logged Url: https://wwww.google.com/maps/cities
     * </pre>
     *
     * <code>optional string url = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearUrl() {
      copyOnWrite();
      instance.clearUrl();
      return this;
    }
    /**
     * <pre>
     * The parameterless url to which the network request was made. The sdk will
     * redact the unnecessary components of the URL and only log the components
     * which are useful. For a url of the form
     * scheme://host[:port]/path[?params][#fragment], the sdk should only log
     * scheme://host[:port]/path
     * Example:
     * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
     * Logged Url: https://wwww.google.com/maps/cities
     * </pre>
     *
     * <code>optional string url = 1;</code>
     * @param value The bytes for url to set.
     * @return This builder for chaining.
     */
    public Builder setUrlBytes(
        com.google.protobuf.ByteString value) {
      copyOnWrite();
      instance.setUrlBytes(value);
      return this;
    }

    /**
     * <pre>
     * The HTTP verb for the network request. Common values include GET,
     * PUT, POST and DELETE
     * </pre>
     *
     * <code>optional .firebase.perf.v1.NetworkRequestMetric.HttpMethod http_method = 2;</code>
     * @return Whether the httpMethod field is set.
     */
    @java.lang.Override
    public boolean hasHttpMethod() {
      return instance.hasHttpMethod();
    }
    /**
     * <pre>
     * The HTTP verb for the network request. Common values include GET,
     * PUT, POST and DELETE
     * </pre>
     *
     * <code>optional .firebase.perf.v1.NetworkRequestMetric.HttpMethod http_method = 2;</code>
     * @return The httpMethod.
     */
    @java.lang.Override
    public com.google.firebase.perf.v1.NetworkRequestMetric.HttpMethod getHttpMethod() {
      return instance.getHttpMethod();
    }
    /**
     * <pre>
     * The HTTP verb for the network request. Common values include GET,
     * PUT, POST and DELETE
     * </pre>
     *
     * <code>optional .firebase.perf.v1.NetworkRequestMetric.HttpMethod http_method = 2;</code>
     * @param value The enum numeric value on the wire for httpMethod to set.
     * @return This builder for chaining.
     */
    public Builder setHttpMethod(com.google.firebase.perf.v1.NetworkRequestMetric.HttpMethod value) {
      copyOnWrite();
      instance.setHttpMethod(value);
      return this;
    }
    /**
     * <pre>
     * The HTTP verb for the network request. Common values include GET,
     * PUT, POST and DELETE
     * </pre>
     *
     * <code>optional .firebase.perf.v1.NetworkRequestMetric.HttpMethod http_method = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearHttpMethod() {
      copyOnWrite();
      instance.clearHttpMethod();
      return this;
    }

    /**
     * <pre>
     * The size of the payload in the request.
     * </pre>
     *
     * <code>optional int64 request_payload_bytes = 3;</code>
     * @return Whether the requestPayloadBytes field is set.
     */
    @java.lang.Override
    public boolean hasRequestPayloadBytes() {
      return instance.hasRequestPayloadBytes();
    }
    /**
     * <pre>
     * The size of the payload in the request.
     * </pre>
     *
     * <code>optional int64 request_payload_bytes = 3;</code>
     * @return The requestPayloadBytes.
     */
    @java.lang.Override
    public long getRequestPayloadBytes() {
      return instance.getRequestPayloadBytes();
    }
    /**
     * <pre>
     * The size of the payload in the request.
     * </pre>
     *
     * <code>optional int64 request_payload_bytes = 3;</code>
     * @param value The requestPayloadBytes to set.
     * @return This builder for chaining.
     */
    public Builder setRequestPayloadBytes(long value) {
      copyOnWrite();
      instance.setRequestPayloadBytes(value);
      return this;
    }
    /**
     * <pre>
     * The size of the payload in the request.
     * </pre>
     *
     * <code>optional int64 request_payload_bytes = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearRequestPayloadBytes() {
      copyOnWrite();
      instance.clearRequestPayloadBytes();
      return this;
    }

    /**
     * <pre>
     * The size of the payload in the response.
     * </pre>
     *
     * <code>optional int64 response_payload_bytes = 4;</code>
     * @return Whether the responsePayloadBytes field is set.
     */
    @java.lang.Override
    public boolean hasResponsePayloadBytes() {
      return instance.hasResponsePayloadBytes();
    }
    /**
     * <pre>
     * The size of the payload in the response.
     * </pre>
     *
     * <code>optional int64 response_payload_bytes = 4;</code>
     * @return The responsePayloadBytes.
     */
    @java.lang.Override
    public long getResponsePayloadBytes() {
      return instance.getResponsePayloadBytes();
    }
    /**
     * <pre>
     * The size of the payload in the response.
     * </pre>
     *
     * <code>optional int64 response_payload_bytes = 4;</code>
     * @param value The responsePayloadBytes to set.
     * @return This builder for chaining.
     */
    public Builder setResponsePayloadBytes(long value) {
      copyOnWrite();
      instance.setResponsePayloadBytes(value);
      return this;
    }
    /**
     * <pre>
     * The size of the payload in the response.
     * </pre>
     *
     * <code>optional int64 response_payload_bytes = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearResponsePayloadBytes() {
      copyOnWrite();
      instance.clearResponsePayloadBytes();
      return this;
    }

    /**
     * <pre>
     * The client error received from the networking library.
     * Do not record a client error if we have HTTP response code available.
     * </pre>
     *
     * <code>optional .firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason network_client_error_reason = 11;</code>
     * @return Whether the networkClientErrorReason field is set.
     */
    @java.lang.Override
    public boolean hasNetworkClientErrorReason() {
      return instance.hasNetworkClientErrorReason();
    }
    /**
     * <pre>
     * The client error received from the networking library.
     * Do not record a client error if we have HTTP response code available.
     * </pre>
     *
     * <code>optional .firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason network_client_error_reason = 11;</code>
     * @return The networkClientErrorReason.
     */
    @java.lang.Override
    public com.google.firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason getNetworkClientErrorReason() {
      return instance.getNetworkClientErrorReason();
    }
    /**
     * <pre>
     * The client error received from the networking library.
     * Do not record a client error if we have HTTP response code available.
     * </pre>
     *
     * <code>optional .firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason network_client_error_reason = 11;</code>
     * @param value The enum numeric value on the wire for networkClientErrorReason to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkClientErrorReason(com.google.firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason value) {
      copyOnWrite();
      instance.setNetworkClientErrorReason(value);
      return this;
    }
    /**
     * <pre>
     * The client error received from the networking library.
     * Do not record a client error if we have HTTP response code available.
     * </pre>
     *
     * <code>optional .firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason network_client_error_reason = 11;</code>
     * @return This builder for chaining.
     */
    public Builder clearNetworkClientErrorReason() {
      copyOnWrite();
      instance.clearNetworkClientErrorReason();
      return this;
    }

    /**
     * <pre>
     * The Http response code received from the server.
     * </pre>
     *
     * <code>optional int32 http_response_code = 5;</code>
     * @return Whether the httpResponseCode field is set.
     */
    @java.lang.Override
    public boolean hasHttpResponseCode() {
      return instance.hasHttpResponseCode();
    }
    /**
     * <pre>
     * The Http response code received from the server.
     * </pre>
     *
     * <code>optional int32 http_response_code = 5;</code>
     * @return The httpResponseCode.
     */
    @java.lang.Override
    public int getHttpResponseCode() {
      return instance.getHttpResponseCode();
    }
    /**
     * <pre>
     * The Http response code received from the server.
     * </pre>
     *
     * <code>optional int32 http_response_code = 5;</code>
     * @param value The httpResponseCode to set.
     * @return This builder for chaining.
     */
    public Builder setHttpResponseCode(int value) {
      copyOnWrite();
      instance.setHttpResponseCode(value);
      return this;
    }
    /**
     * <pre>
     * The Http response code received from the server.
     * </pre>
     *
     * <code>optional int32 http_response_code = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearHttpResponseCode() {
      copyOnWrite();
      instance.clearHttpResponseCode();
      return this;
    }

    /**
     * <pre>
     * The value of the content type header in the response.
     * </pre>
     *
     * <code>optional string response_content_type = 6;</code>
     * @return Whether the responseContentType field is set.
     */
    @java.lang.Override
    public boolean hasResponseContentType() {
      return instance.hasResponseContentType();
    }
    /**
     * <pre>
     * The value of the content type header in the response.
     * </pre>
     *
     * <code>optional string response_content_type = 6;</code>
     * @return The responseContentType.
     */
    @java.lang.Override
    public java.lang.String getResponseContentType() {
      return instance.getResponseContentType();
    }
    /**
     * <pre>
     * The value of the content type header in the response.
     * </pre>
     *
     * <code>optional string response_content_type = 6;</code>
     * @return The bytes for responseContentType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getResponseContentTypeBytes() {
      return instance.getResponseContentTypeBytes();
    }
    /**
     * <pre>
     * The value of the content type header in the response.
     * </pre>
     *
     * <code>optional string response_content_type = 6;</code>
     * @param value The responseContentType to set.
     * @return This builder for chaining.
     */
    public Builder setResponseContentType(
        java.lang.String value) {
      copyOnWrite();
      instance.setResponseContentType(value);
      return this;
    }
    /**
     * <pre>
     * The value of the content type header in the response.
     * </pre>
     *
     * <code>optional string response_content_type = 6;</code>
     * @return This builder for chaining.
     */
    public Builder clearResponseContentType() {
      copyOnWrite();
      instance.clearResponseContentType();
      return this;
    }
    /**
     * <pre>
     * The value of the content type header in the response.
     * </pre>
     *
     * <code>optional string response_content_type = 6;</code>
     * @param value The bytes for responseContentType to set.
     * @return This builder for chaining.
     */
    public Builder setResponseContentTypeBytes(
        com.google.protobuf.ByteString value) {
      copyOnWrite();
      instance.setResponseContentTypeBytes(value);
      return this;
    }

    /**
     * <pre>
     * The timestamp in microseconds since epoch when the network request was
     * initiated. This time is recorded using the device clock.
     * </pre>
     *
     * <code>optional int64 client_start_time_us = 7;</code>
     * @return Whether the clientStartTimeUs field is set.
     */
    @java.lang.Override
    public boolean hasClientStartTimeUs() {
      return instance.hasClientStartTimeUs();
    }
    /**
     * <pre>
     * The timestamp in microseconds since epoch when the network request was
     * initiated. This time is recorded using the device clock.
     * </pre>
     *
     * <code>optional int64 client_start_time_us = 7;</code>
     * @return The clientStartTimeUs.
     */
    @java.lang.Override
    public long getClientStartTimeUs() {
      return instance.getClientStartTimeUs();
    }
    /**
     * <pre>
     * The timestamp in microseconds since epoch when the network request was
     * initiated. This time is recorded using the device clock.
     * </pre>
     *
     * <code>optional int64 client_start_time_us = 7;</code>
     * @param value The clientStartTimeUs to set.
     * @return This builder for chaining.
     */
    public Builder setClientStartTimeUs(long value) {
      copyOnWrite();
      instance.setClientStartTimeUs(value);
      return this;
    }
    /**
     * <pre>
     * The timestamp in microseconds since epoch when the network request was
     * initiated. This time is recorded using the device clock.
     * </pre>
     *
     * <code>optional int64 client_start_time_us = 7;</code>
     * @return This builder for chaining.
     */
    public Builder clearClientStartTimeUs() {
      copyOnWrite();
      instance.clearClientStartTimeUs();
      return this;
    }

    /**
     * <pre>
     * The time in microseconds since the start of the network request and the
     * upload of the last request byte.
     * </pre>
     *
     * <code>optional int64 time_to_request_completed_us = 8;</code>
     * @return Whether the timeToRequestCompletedUs field is set.
     */
    @java.lang.Override
    public boolean hasTimeToRequestCompletedUs() {
      return instance.hasTimeToRequestCompletedUs();
    }
    /**
     * <pre>
     * The time in microseconds since the start of the network request and the
     * upload of the last request byte.
     * </pre>
     *
     * <code>optional int64 time_to_request_completed_us = 8;</code>
     * @return The timeToRequestCompletedUs.
     */
    @java.lang.Override
    public long getTimeToRequestCompletedUs() {
      return instance.getTimeToRequestCompletedUs();
    }
    /**
     * <pre>
     * The time in microseconds since the start of the network request and the
     * upload of the last request byte.
     * </pre>
     *
     * <code>optional int64 time_to_request_completed_us = 8;</code>
     * @param value The timeToRequestCompletedUs to set.
     * @return This builder for chaining.
     */
    public Builder setTimeToRequestCompletedUs(long value) {
      copyOnWrite();
      instance.setTimeToRequestCompletedUs(value);
      return this;
    }
    /**
     * <pre>
     * The time in microseconds since the start of the network request and the
     * upload of the last request byte.
     * </pre>
     *
     * <code>optional int64 time_to_request_completed_us = 8;</code>
     * @return This builder for chaining.
     */
    public Builder clearTimeToRequestCompletedUs() {
      copyOnWrite();
      instance.clearTimeToRequestCompletedUs();
      return this;
    }

    /**
     * <pre>
     * The time in microseconds between the start of the network request and the
     * receipt of the first byte of the response headers.
     * </pre>
     *
     * <code>optional int64 time_to_response_initiated_us = 9;</code>
     * @return Whether the timeToResponseInitiatedUs field is set.
     */
    @java.lang.Override
    public boolean hasTimeToResponseInitiatedUs() {
      return instance.hasTimeToResponseInitiatedUs();
    }
    /**
     * <pre>
     * The time in microseconds between the start of the network request and the
     * receipt of the first byte of the response headers.
     * </pre>
     *
     * <code>optional int64 time_to_response_initiated_us = 9;</code>
     * @return The timeToResponseInitiatedUs.
     */
    @java.lang.Override
    public long getTimeToResponseInitiatedUs() {
      return instance.getTimeToResponseInitiatedUs();
    }
    /**
     * <pre>
     * The time in microseconds between the start of the network request and the
     * receipt of the first byte of the response headers.
     * </pre>
     *
     * <code>optional int64 time_to_response_initiated_us = 9;</code>
     * @param value The timeToResponseInitiatedUs to set.
     * @return This builder for chaining.
     */
    public Builder setTimeToResponseInitiatedUs(long value) {
      copyOnWrite();
      instance.setTimeToResponseInitiatedUs(value);
      return this;
    }
    /**
     * <pre>
     * The time in microseconds between the start of the network request and the
     * receipt of the first byte of the response headers.
     * </pre>
     *
     * <code>optional int64 time_to_response_initiated_us = 9;</code>
     * @return This builder for chaining.
     */
    public Builder clearTimeToResponseInitiatedUs() {
      copyOnWrite();
      instance.clearTimeToResponseInitiatedUs();
      return this;
    }

    /**
     * <pre>
     * The time in microseconds between the start of the network request and the
     * receipt of the last response byte.
     * </pre>
     *
     * <code>optional int64 time_to_response_completed_us = 10;</code>
     * @return Whether the timeToResponseCompletedUs field is set.
     */
    @java.lang.Override
    public boolean hasTimeToResponseCompletedUs() {
      return instance.hasTimeToResponseCompletedUs();
    }
    /**
     * <pre>
     * The time in microseconds between the start of the network request and the
     * receipt of the last response byte.
     * </pre>
     *
     * <code>optional int64 time_to_response_completed_us = 10;</code>
     * @return The timeToResponseCompletedUs.
     */
    @java.lang.Override
    public long getTimeToResponseCompletedUs() {
      return instance.getTimeToResponseCompletedUs();
    }
    /**
     * <pre>
     * The time in microseconds between the start of the network request and the
     * receipt of the last response byte.
     * </pre>
     *
     * <code>optional int64 time_to_response_completed_us = 10;</code>
     * @param value The timeToResponseCompletedUs to set.
     * @return This builder for chaining.
     */
    public Builder setTimeToResponseCompletedUs(long value) {
      copyOnWrite();
      instance.setTimeToResponseCompletedUs(value);
      return this;
    }
    /**
     * <pre>
     * The time in microseconds between the start of the network request and the
     * receipt of the last response byte.
     * </pre>
     *
     * <code>optional int64 time_to_response_completed_us = 10;</code>
     * @return This builder for chaining.
     */
    public Builder clearTimeToResponseCompletedUs() {
      copyOnWrite();
      instance.clearTimeToResponseCompletedUs();
      return this;
    }

    @java.lang.Override

    public int getCustomAttributesCount() {
      return instance.getCustomAttributesMap().size();
    }
    /**
     * <pre>
     * A map of network-level custom attribute names to values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
     */
    @java.lang.Override

    public boolean containsCustomAttributes(
        java.lang.String key) {
      java.lang.Class<?> keyClass = key.getClass();
      return instance.getCustomAttributesMap().containsKey(key);
    }

    public Builder clearCustomAttributes() {
      copyOnWrite();
      instance.getMutableCustomAttributesMap().clear();
      return this;
    }
    /**
     * <pre>
     * A map of network-level custom attribute names to values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
     */

    public Builder removeCustomAttributes(
        java.lang.String key) {
      java.lang.Class<?> keyClass = key.getClass();
      copyOnWrite();
      instance.getMutableCustomAttributesMap().remove(key);
      return this;
    }
    /**
     * Use {@link #getCustomAttributesMap()} instead.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getCustomAttributes() {
      return getCustomAttributesMap();
    }
    /**
     * <pre>
     * A map of network-level custom attribute names to values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getCustomAttributesMap() {
      return java.util.Collections.unmodifiableMap(
          instance.getCustomAttributesMap());
    }
    /**
     * <pre>
     * A map of network-level custom attribute names to values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
     */
    @java.lang.Override

    public java.lang.String getCustomAttributesOrDefault(
        java.lang.String key,
        java.lang.String defaultValue) {
      java.lang.Class<?> keyClass = key.getClass();
      java.util.Map<java.lang.String, java.lang.String> map =
          instance.getCustomAttributesMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * A map of network-level custom attribute names to values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
     */
    @java.lang.Override

    public java.lang.String getCustomAttributesOrThrow(
        java.lang.String key) {
      java.lang.Class<?> keyClass = key.getClass();
      java.util.Map<java.lang.String, java.lang.String> map =
          instance.getCustomAttributesMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }
    /**
     * <pre>
     * A map of network-level custom attribute names to values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
     */
    public Builder putCustomAttributes(
        java.lang.String key,
        java.lang.String value) {
      java.lang.Class<?> keyClass = key.getClass();
      java.lang.Class<?> valueClass = value.getClass();
      copyOnWrite();
      instance.getMutableCustomAttributesMap().put(key, value);
      return this;
    }
    /**
     * <pre>
     * A map of network-level custom attribute names to values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
     */
    public Builder putAllCustomAttributes(
        java.util.Map<java.lang.String, java.lang.String> values) {
      copyOnWrite();
      instance.getMutableCustomAttributesMap().putAll(values);
      return this;
    }

    /**
     * <pre>
     * Sessions across which the network request spanned. A session lasts
     * from one change in the app state (foreground/background) to the next.
     * Basically every foreground and background session gets it's own session id.
     * A network request may span across multiple such sessions. So we need a list
     * to identify which sessions it spanned across.
     * </pre>
     *
     * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.firebase.perf.v1.PerfSession> getPerfSessionsList() {
      return java.util.Collections.unmodifiableList(
          instance.getPerfSessionsList());
    }
    /**
     * <pre>
     * Sessions across which the network request spanned. A session lasts
     * from one change in the app state (foreground/background) to the next.
     * Basically every foreground and background session gets it's own session id.
     * A network request may span across multiple such sessions. So we need a list
     * to identify which sessions it spanned across.
     * </pre>
     *
     * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
     */
    @java.lang.Override
    public int getPerfSessionsCount() {
      return instance.getPerfSessionsCount();
    }/**
     * <pre>
     * Sessions across which the network request spanned. A session lasts
     * from one change in the app state (foreground/background) to the next.
     * Basically every foreground and background session gets it's own session id.
     * A network request may span across multiple such sessions. So we need a list
     * to identify which sessions it spanned across.
     * </pre>
     *
     * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
     */
    @java.lang.Override
    public com.google.firebase.perf.v1.PerfSession getPerfSessions(int index) {
      return instance.getPerfSessions(index);
    }
    /**
     * <pre>
     * Sessions across which the network request spanned. A session lasts
     * from one change in the app state (foreground/background) to the next.
     * Basically every foreground and background session gets it's own session id.
     * A network request may span across multiple such sessions. So we need a list
     * to identify which sessions it spanned across.
     * </pre>
     *
     * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
     */
    public Builder setPerfSessions(
        int index, com.google.firebase.perf.v1.PerfSession value) {
      copyOnWrite();
      instance.setPerfSessions(index, value);
      return this;
    }
    /**
     * <pre>
     * Sessions across which the network request spanned. A session lasts
     * from one change in the app state (foreground/background) to the next.
     * Basically every foreground and background session gets it's own session id.
     * A network request may span across multiple such sessions. So we need a list
     * to identify which sessions it spanned across.
     * </pre>
     *
     * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
     */
    public Builder setPerfSessions(
        int index, com.google.firebase.perf.v1.PerfSession.Builder builderForValue) {
      copyOnWrite();
      instance.setPerfSessions(index,
          builderForValue.build());
      return this;
    }
    /**
     * <pre>
     * Sessions across which the network request spanned. A session lasts
     * from one change in the app state (foreground/background) to the next.
     * Basically every foreground and background session gets it's own session id.
     * A network request may span across multiple such sessions. So we need a list
     * to identify which sessions it spanned across.
     * </pre>
     *
     * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
     */
    public Builder addPerfSessions(com.google.firebase.perf.v1.PerfSession value) {
      copyOnWrite();
      instance.addPerfSessions(value);
      return this;
    }
    /**
     * <pre>
     * Sessions across which the network request spanned. A session lasts
     * from one change in the app state (foreground/background) to the next.
     * Basically every foreground and background session gets it's own session id.
     * A network request may span across multiple such sessions. So we need a list
     * to identify which sessions it spanned across.
     * </pre>
     *
     * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
     */
    public Builder addPerfSessions(
        int index, com.google.firebase.perf.v1.PerfSession value) {
      copyOnWrite();
      instance.addPerfSessions(index, value);
      return this;
    }
    /**
     * <pre>
     * Sessions across which the network request spanned. A session lasts
     * from one change in the app state (foreground/background) to the next.
     * Basically every foreground and background session gets it's own session id.
     * A network request may span across multiple such sessions. So we need a list
     * to identify which sessions it spanned across.
     * </pre>
     *
     * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
     */
    public Builder addPerfSessions(
        com.google.firebase.perf.v1.PerfSession.Builder builderForValue) {
      copyOnWrite();
      instance.addPerfSessions(builderForValue.build());
      return this;
    }
    /**
     * <pre>
     * Sessions across which the network request spanned. A session lasts
     * from one change in the app state (foreground/background) to the next.
     * Basically every foreground and background session gets it's own session id.
     * A network request may span across multiple such sessions. So we need a list
     * to identify which sessions it spanned across.
     * </pre>
     *
     * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
     */
    public Builder addPerfSessions(
        int index, com.google.firebase.perf.v1.PerfSession.Builder builderForValue) {
      copyOnWrite();
      instance.addPerfSessions(index,
          builderForValue.build());
      return this;
    }
    /**
     * <pre>
     * Sessions across which the network request spanned. A session lasts
     * from one change in the app state (foreground/background) to the next.
     * Basically every foreground and background session gets it's own session id.
     * A network request may span across multiple such sessions. So we need a list
     * to identify which sessions it spanned across.
     * </pre>
     *
     * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
     */
    public Builder addAllPerfSessions(
        java.lang.Iterable<? extends com.google.firebase.perf.v1.PerfSession> values) {
      copyOnWrite();
      instance.addAllPerfSessions(values);
      return this;
    }
    /**
     * <pre>
     * Sessions across which the network request spanned. A session lasts
     * from one change in the app state (foreground/background) to the next.
     * Basically every foreground and background session gets it's own session id.
     * A network request may span across multiple such sessions. So we need a list
     * to identify which sessions it spanned across.
     * </pre>
     *
     * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
     */
    public Builder clearPerfSessions() {
      copyOnWrite();
      instance.clearPerfSessions();
      return this;
    }
    /**
     * <pre>
     * Sessions across which the network request spanned. A session lasts
     * from one change in the app state (foreground/background) to the next.
     * Basically every foreground and background session gets it's own session id.
     * A network request may span across multiple such sessions. So we need a list
     * to identify which sessions it spanned across.
     * </pre>
     *
     * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
     */
    public Builder removePerfSessions(int index) {
      copyOnWrite();
      instance.removePerfSessions(index);
      return this;
    }

    // @@protoc_insertion_point(builder_scope:firebase.perf.v1.NetworkRequestMetric)
  }
  @java.lang.Override
  @java.lang.SuppressWarnings({"unchecked", "fallthrough"})
  protected final java.lang.Object dynamicMethod(
      com.google.protobuf.GeneratedMessageLite.MethodToInvoke method,
      java.lang.Object arg0, java.lang.Object arg1) {
    switch (method) {
      case NEW_MUTABLE_INSTANCE: {
        return new com.google.firebase.perf.v1.NetworkRequestMetric();
      }
      case NEW_BUILDER: {
        return new Builder();
      }
      case BUILD_MESSAGE_INFO: {
          java.lang.Object[] objects = new java.lang.Object[] {
            "bitField0_",
            "url_",
            "httpMethod_",
            com.google.firebase.perf.v1.NetworkRequestMetric.HttpMethod.internalGetVerifier(),
            "requestPayloadBytes_",
            "responsePayloadBytes_",
            "httpResponseCode_",
            "responseContentType_",
            "clientStartTimeUs_",
            "timeToRequestCompletedUs_",
            "timeToResponseInitiatedUs_",
            "timeToResponseCompletedUs_",
            "networkClientErrorReason_",
            com.google.firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason.internalGetVerifier(),
            "customAttributes_",
            CustomAttributesDefaultEntryHolder.defaultEntry,
            "perfSessions_",
            com.google.firebase.perf.v1.PerfSession.class,
          };
          java.lang.String info =
              "\u0001\r\u0000\u0001\u0001\r\r\u0001\u0001\u0000\u0001\u1008\u0000\u0002\u100c\u0001" +
              "\u0003\u1002\u0002\u0004\u1002\u0003\u0005\u1004\u0005\u0006\u1008\u0006\u0007\u1002" +
              "\u0007\b\u1002\b\t\u1002\t\n\u1002\n\u000b\u100c\u0004\f2\r\u001b";
          return newMessageInfo(DEFAULT_INSTANCE, info, objects);
      }
      // fall through
      case GET_DEFAULT_INSTANCE: {
        return DEFAULT_INSTANCE;
      }
      case GET_PARSER: {
        com.google.protobuf.Parser<com.google.firebase.perf.v1.NetworkRequestMetric> parser = PARSER;
        if (parser == null) {
          synchronized (com.google.firebase.perf.v1.NetworkRequestMetric.class) {
            parser = PARSER;
            if (parser == null) {
              parser =
                  new DefaultInstanceBasedParser<com.google.firebase.perf.v1.NetworkRequestMetric>(
                      DEFAULT_INSTANCE);
              PARSER = parser;
            }
          }
        }
        return parser;
    }
    case GET_MEMOIZED_IS_INITIALIZED: {
      return (byte) 1;
    }
    case SET_MEMOIZED_IS_INITIALIZED: {
      return null;
    }
    }
    throw new UnsupportedOperationException();
  }


  // @@protoc_insertion_point(class_scope:firebase.perf.v1.NetworkRequestMetric)
  private static final com.google.firebase.perf.v1.NetworkRequestMetric DEFAULT_INSTANCE;
  static {
    NetworkRequestMetric defaultInstance = new NetworkRequestMetric();
    // New instances are implicitly immutable so no need to make
    // immutable.
    DEFAULT_INSTANCE = defaultInstance;
    com.google.protobuf.GeneratedMessageLite.registerDefaultInstance(
      NetworkRequestMetric.class, defaultInstance);
  }

  public static com.google.firebase.perf.v1.NetworkRequestMetric getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static volatile com.google.protobuf.Parser<NetworkRequestMetric> PARSER;

  public static com.google.protobuf.Parser<NetworkRequestMetric> parser() {
    return DEFAULT_INSTANCE.getParserForType();
  }
}

