/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.firebase.sessions.SessionLifecycleClient;
import com.google.firebase.sessions.SessionLifecycleServiceBinder;
import com.google.firebase.sessions.api.FirebaseSessionsDependencies;
import com.google.firebase.sessions.api.SessionSubscriber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\r\b\u0000\u0018\u0000 $2\u00020\u0001:\u0002#$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0010J \u0010\u0017\u001a\u0004\u0018\u00010\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u001bH\u0002J\u0016\u0010 \u001a\u00020!2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019H\u0003J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/google/firebase/sessions/SessionLifecycleClient;", "", "backgroundDispatcher", "Lkotlin/coroutines/CoroutineContext;", "(Lkotlin/coroutines/CoroutineContext;)V", "queuedMessages", "Ljava/util/concurrent/LinkedBlockingDeque;", "Landroid/os/Message;", "service", "Landroid/os/Messenger;", "serviceBound", "", "serviceConnection", "com/google/firebase/sessions/SessionLifecycleClient$serviceConnection$1", "Lcom/google/firebase/sessions/SessionLifecycleClient$serviceConnection$1;", "backgrounded", "", "bindToService", "sessionLifecycleServiceBinder", "Lcom/google/firebase/sessions/SessionLifecycleServiceBinder;", "drainQueue", "", "foregrounded", "getLatestByCode", "messages", "", "msgCode", "", "queueMessage", "msg", "sendLifecycleEvent", "messageCode", "sendLifecycleEvents", "Lkotlinx/coroutines/Job;", "sendMessageToServer", "ClientUpdateHandler", "Companion", "com.google.firebase-firebase-sessions"})
public final class SessionLifecycleClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineContext backgroundDispatcher;
    @Nullable
    private Messenger service;
    private boolean serviceBound;
    @NotNull
    private final LinkedBlockingDeque<Message> queuedMessages;
    @NotNull
    private final serviceConnection.1 serviceConnection;
    @NotNull
    public static final String TAG = "SessionLifecycleClient";
    private static final int MAX_QUEUED_MESSAGES = 20;

    public SessionLifecycleClient(@NotNull CoroutineContext backgroundDispatcher) {
        Intrinsics.checkNotNullParameter((Object)backgroundDispatcher, (String)"backgroundDispatcher");
        this.backgroundDispatcher = backgroundDispatcher;
        this.queuedMessages = new LinkedBlockingDeque(20);
        this.serviceConnection = new ServiceConnection(this){
            final /* synthetic */ SessionLifecycleClient this$0;
            {
                this.this$0 = $receiver;
            }

            public void onServiceConnected(@Nullable ComponentName className, @Nullable IBinder serviceBinder) {
                Log.d((String)"SessionLifecycleClient", (String)("Connected to SessionLifecycleService. Queue size " + SessionLifecycleClient.access$getQueuedMessages$p(this.this$0).size()));
                SessionLifecycleClient.access$setService$p(this.this$0, new Messenger(serviceBinder));
                SessionLifecycleClient.access$setServiceBound$p(this.this$0, true);
                SessionLifecycleClient.access$sendLifecycleEvents(this.this$0, SessionLifecycleClient.access$drainQueue(this.this$0));
            }

            public void onServiceDisconnected(@Nullable ComponentName className) {
                Log.d((String)"SessionLifecycleClient", (String)"Disconnected from SessionLifecycleService");
                SessionLifecycleClient.access$setService$p(this.this$0, null);
                SessionLifecycleClient.access$setServiceBound$p(this.this$0, false);
            }
        };
    }

    public final void bindToService(@NotNull SessionLifecycleServiceBinder sessionLifecycleServiceBinder) {
        Intrinsics.checkNotNullParameter((Object)sessionLifecycleServiceBinder, (String)"sessionLifecycleServiceBinder");
        sessionLifecycleServiceBinder.bindToService(new Messenger((Handler)new ClientUpdateHandler(this.backgroundDispatcher)), this.serviceConnection);
    }

    public final void foregrounded() {
        this.sendLifecycleEvent(1);
    }

    public final void backgrounded() {
        this.sendLifecycleEvent(2);
    }

    private final void sendLifecycleEvent(int messageCode) {
        List<Message> allMessages = this.drainQueue();
        Message message = Message.obtain(null, (int)messageCode, (int)0, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"obtain(null, messageCode, 0, 0)");
        allMessages.add(message);
        this.sendLifecycleEvents(allMessages);
    }

    @CanIgnoreReturnValue
    private final Job sendLifecycleEvents(List<Message> messages) {
        return BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.backgroundDispatcher), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, messages, null){
            int label;
            final /* synthetic */ SessionLifecycleClient this$0;
            final /* synthetic */ List<Message> $messages;
            {
                this.this$0 = $receiver;
                this.$messages = $messages;
                super(2, $completion);
            }

            /*
             * Could not resolve type clashes
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = FirebaseSessionsDependencies.INSTANCE.getRegisteredSubscribers$com_google_firebase_firebase_sessions((Continuation<? super Map<SessionSubscriber.Name, ? extends SessionSubscriber>>)((Continuation)this));
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (!(subscribers = (Map)v0).isEmpty()) ** GOTO lbl17
                        Log.d((String)"SessionLifecycleClient", (String)"Sessions SDK did not have any dependent SDKs register as dependencies. Events will not be sent.");
                        ** GOTO lbl44
lbl17:
                        // 1 sources

                        $this$none$iv = (Object[])subscribers.values();
                        $i$f$none = false;
                        if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl22
                        v1 = true;
                        ** GOTO lbl29
lbl22:
                        // 2 sources

                        for (T element$iv : $this$none$iv) {
                            it = (SessionSubscriber)element$iv;
                            $i$a$-none-SessionLifecycleClient$sendLifecycleEvents$1$1 = false;
                            if (!it.isDataCollectionEnabled()) continue;
                            v1 = false;
                            ** GOTO lbl29
                        }
                        v1 = true;
lbl29:
                        // 3 sources

                        if (v1) {
                            Log.d((String)"SessionLifecycleClient", (String)"Data Collection is disabled for all subscribers. Skipping this Event");
                        } else {
                            $this$none$iv = new Message[]{SessionLifecycleClient.access$getLatestByCode(this.this$0, this.$messages, 2), SessionLifecycleClient.access$getLatestByCode(this.this$0, this.$messages, 1)};
                            $this$sortedBy$iv = CollectionsKt.filterNotNull((Iterable)CollectionsKt.mutableListOf((Object[])$this$none$iv));
                            $i$f$sortedBy = false;
                            $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                                public final int compare(T a, T b) {
                                    Message it = (Message)a;
                                    boolean bl = false;
                                    Comparable comparable = Long.valueOf(it.getWhen());
                                    it = (Message)b;
                                    Comparable comparable2 = comparable;
                                    bl = false;
                                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getWhen()));
                                }
                            });
                            var4_6 = this.this$0;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (Message)element$iv;
                                $i$a$-forEach-SessionLifecycleClient$sendLifecycleEvents$1$3 = false;
                                SessionLifecycleClient.access$sendMessageToServer(var4_6, it);
                            }
                        }
lbl44:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void sendMessageToServer(Message msg) {
        if (this.service != null) {
            try {
                Log.d((String)TAG, (String)("Sending lifecycle " + msg.what + " to service"));
                Messenger messenger = this.service;
                if (messenger != null) {
                    messenger.send(msg);
                }
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)("Unable to deliver message: " + msg.what), (Throwable)e);
                this.queueMessage(msg);
            }
        } else {
            this.queueMessage(msg);
        }
    }

    private final void queueMessage(Message msg) {
        if (this.queuedMessages.offer(msg)) {
            Log.d((String)TAG, (String)("Queued message " + msg.what + ". Queue size " + this.queuedMessages.size()));
        } else {
            Log.d((String)TAG, (String)("Failed to enqueue message " + msg.what + ". Dropping."));
        }
    }

    private final List<Message> drainQueue() {
        List messages = new ArrayList();
        this.queuedMessages.drainTo(messages);
        return messages;
    }

    /*
     * WARNING - void declaration
     */
    private final Message getLatestByCode(List<Message> messages, int msgCode) {
        Object v0;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = messages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Message it = (Message)element$iv$iv;
            boolean bl = false;
            if (!(it.what == msgCode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Message it = (Message)maxElem$iv;
                boolean bl = false;
                long maxValue$iv = it.getWhen();
                do {
                    Object e$iv = iterator$iv.next();
                    Message it2 = (Message)e$iv;
                    $i$a$-maxByOrNull-SessionLifecycleClient$getLatestByCode$2 = false;
                    long v$iv = it2.getWhen();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    public static final /* synthetic */ Message access$getLatestByCode(SessionLifecycleClient $this, List messages, int msgCode) {
        return $this.getLatestByCode(messages, msgCode);
    }

    public static final /* synthetic */ void access$sendMessageToServer(SessionLifecycleClient $this, Message msg) {
        $this.sendMessageToServer(msg);
    }

    public static final /* synthetic */ LinkedBlockingDeque access$getQueuedMessages$p(SessionLifecycleClient $this) {
        return $this.queuedMessages;
    }

    public static final /* synthetic */ void access$setService$p(SessionLifecycleClient $this, Messenger messenger) {
        $this.service = messenger;
    }

    public static final /* synthetic */ void access$setServiceBound$p(SessionLifecycleClient $this, boolean bl) {
        $this.serviceBound = bl;
    }

    public static final /* synthetic */ Job access$sendLifecycleEvents(SessionLifecycleClient $this, List messages) {
        return $this.sendLifecycleEvents(messages);
    }

    public static final /* synthetic */ List access$drainQueue(SessionLifecycleClient $this) {
        return $this.drainQueue();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/google/firebase/sessions/SessionLifecycleClient$ClientUpdateHandler;", "Landroid/os/Handler;", "backgroundDispatcher", "Lkotlin/coroutines/CoroutineContext;", "(Lkotlin/coroutines/CoroutineContext;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "handleSessionUpdate", "sessionId", "", "com.google.firebase-firebase-sessions"})
    public static final class ClientUpdateHandler
    extends Handler {
        @NotNull
        private final CoroutineContext backgroundDispatcher;

        public ClientUpdateHandler(@NotNull CoroutineContext backgroundDispatcher) {
            Intrinsics.checkNotNullParameter((Object)backgroundDispatcher, (String)"backgroundDispatcher");
            super(Looper.getMainLooper());
            this.backgroundDispatcher = backgroundDispatcher;
        }

        public void handleMessage(@NotNull Message msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            if (msg.what == 3) {
                Object object = msg.getData();
                if (object == null || (object = object.getString("SessionUpdateExtra")) == null) {
                    object = "";
                }
                this.handleSessionUpdate((String)object);
            } else {
                Log.w((String)SessionLifecycleClient.TAG, (String)("Received unexpected event from the SessionLifecycleService: " + msg));
                super.handleMessage(msg);
            }
        }

        private final void handleSessionUpdate(String sessionId) {
            Log.d((String)SessionLifecycleClient.TAG, (String)("Session update received: " + sessionId));
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.backgroundDispatcher), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(sessionId, null){
                int label;
                final /* synthetic */ String $sessionId;
                {
                    this.$sessionId = $sessionId;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = FirebaseSessionsDependencies.INSTANCE.getRegisteredSubscribers$com_google_firebase_firebase_sessions((Continuation<? super Map<SessionSubscriber.Name, ? extends SessionSubscriber>>)((Continuation)this));
                            if (v0 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            var2_3 = ((Map)v0).values();
                            var3_4 = this.$sessionId;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                subscriber = (SessionSubscriber)element$iv;
                                $i$a$-forEach-SessionLifecycleClient$ClientUpdateHandler$handleSessionUpdate$1$1 = false;
                                subscriber.onSessionChanged(new SessionSubscriber.SessionDetails(var3_4));
                                Log.d((String)"SessionLifecycleClient", (String)("Notified " + (Object)subscriber.getSessionSubscriberName() + " of new session " + var3_4));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/google/firebase/sessions/SessionLifecycleClient$Companion;", "", "()V", "MAX_QUEUED_MESSAGES", "", "TAG", "", "com.google.firebase-firebase-sessions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

