/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin.instrumentation;

import com.google.firebase.perf.plugin.instrumentation.InstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.InstrumentationContext;
import com.google.firebase.perf.plugin.instrumentation.PerfInstrumentedAttribute;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodAdapter;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodInstrumentationFactory;
import com.google.firebase.perf.plugin.instrumentation.exceptions.AlreadyPerfInstrumentedException;
import com.google.firebase.perf.plugin.instrumentation.model.AnnotationInfo;
import com.google.firebase.perf.plugin.instrumentation.model.ClassInfo;
import com.google.firebase.perf.plugin.instrumentation.network.NetworkObjectInstrumentation;
import com.google.firebase.perf.plugin.instrumentation.network.NetworkObjectInstrumentationFactory;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationVisitor
extends ClassVisitor {
    private static final boolean LOG_VISITS = false;
    public static final boolean LOG_INSTRUMENTATION = true;
    private final ClassVisitor mCV;
    private final InstrumentationConfig mInstrumentationConfig;
    private final int mApi;
    private final ClassInfo mClassInfo = new ClassInfo();
    private final InstrumentationContext mInstrContext = new InstrumentationContext();
    private boolean mEnding;
    Logger mLogger = LoggerFactory.getLogger((String)"FirebasePerformancePlugin");

    public InstrumentationVisitor(ClassVisitor cv, InstrumentationConfig config) {
        super(327680, cv);
        this.mCV = cv;
        this.mInstrumentationConfig = config;
        this.mApi = 327680;
    }

    public void visit(int version, int access, String className, String signature, String superName, String[] interfaces) {
        super.visit(version, access, className, signature, superName, interfaces);
        this.mClassInfo.type = Type.getObjectType((String)className);
        this.mClassInfo.interfaces = interfaces;
        this.mInstrContext.clazz.put("name", this.mClassInfo.type.getClassName());
    }

    public void visitOuterClass(String owner, String className, String classDesc) {
        super.visitOuterClass(owner, className, classDesc);
    }

    public AnnotationVisitor visitAnnotation(String classDesc, boolean visible) {
        AnnotationInfo ai = new AnnotationInfo();
        ai.type = Type.getType((String)classDesc);
        this.mClassInfo.annotations.add(ai);
        AnnotationVisitor av = super.visitAnnotation(classDesc, visible);
        return new FirebasePerfAnnotationVisitor(this, this.mApi, av, ai);
    }

    public void visitAttribute(Attribute attr) {
        super.visitAttribute(attr);
        if (!this.mEnding && attr instanceof PerfInstrumentedAttribute) {
            throw new AlreadyPerfInstrumentedException();
        }
    }

    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        this.mInstrContext.method.clear();
        MethodVisitor mv = this.mCV.visitMethod(access, methodName, methodDesc, signature, exceptions);
        FirebasePerfMethodVisitor mmv = new FirebasePerfMethodVisitor(this.mClassInfo.type.getDescriptor(), this.mApi, mv, access, methodName, methodDesc, this.mInstrumentationConfig);
        return mmv;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public void visitEnd() {
        this.mEnding = true;
        this.visitAttribute(new PerfInstrumentedAttribute("instrumented"));
        super.visitEnd();
    }

    private class FirebasePerfAnnotationVisitor
    extends AnnotationVisitor {
        private final AnnotationInfo ai;

        public FirebasePerfAnnotationVisitor(InstrumentationVisitor instrumentationVisitor, int api, AnnotationVisitor av, AnnotationInfo ai) {
            super(api, av);
            this.ai = ai;
        }

        public void visit(String name, Object value) {
            this.ai.values.put(name, value);
            super.visit(name, value);
        }
    }

    private class FirebasePerfMethodVisitor
    extends AdviceAdapter {
        private final InstrumentationConfig mInstrumentationConfig;
        private final String mClassDesc;
        private final String mMethodName;
        private final String mMethodDesc;
        private List<AnnotatedMethodAdapter> mAnnotationInstr;

        protected FirebasePerfMethodVisitor(String classDesc, int api, MethodVisitor mv, int access, String methodName, String methodDesc, InstrumentationConfig config) {
            super(api, mv, access, methodName, methodDesc);
            this.mAnnotationInstr = new ArrayList<AnnotatedMethodAdapter>();
            this.mInstrumentationConfig = config;
            this.mClassDesc = classDesc;
            this.mMethodName = methodName;
            this.mMethodDesc = methodDesc;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            AnnotationVisitor av = super.visitAnnotationDefault();
            AnnotationInfo ai = new AnnotationInfo();
            return new FirebasePerfAnnotationVisitor(InstrumentationVisitor.this, InstrumentationVisitor.this.mApi, av, ai);
        }

        public AnnotationVisitor visitAnnotation(String classDesc, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(classDesc, visible);
            AnnotationInfo ai = new AnnotationInfo();
            av = new FirebasePerfAnnotationVisitor(InstrumentationVisitor.this, InstrumentationVisitor.this.mApi, av, ai);
            List<AnnotatedMethodInstrumentationFactory> factories = this.mInstrumentationConfig.getAnnotatedMethodInstrumentationFactories(classDesc);
            if (factories != null) {
                String string = this.mMethodName;
                String string2 = this.mMethodDesc;
                InstrumentationVisitor.this.mLogger.debug(new StringBuilder(34 + String.valueOf(classDesc).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append("Instrumenting annotation ").append(classDesc).append(" method ").append(string).append(" ").append(string2).toString());
                for (AnnotatedMethodInstrumentationFactory fac : factories) {
                    this.mAnnotationInstr.add(fac.newAnnotatedMethodInstrumentation(InstrumentationVisitor.this.mInstrContext, this, ai, this.mMethodName, this.mMethodDesc));
                }
            }
            return av;
        }

        protected void onMethodEnter() {
            super.onMethodEnter();
            for (AnnotatedMethodAdapter instr : this.mAnnotationInstr) {
                String string = this.mClassDesc;
                String string2 = this.mMethodName;
                String string3 = this.mMethodDesc;
                InstrumentationVisitor.this.mLogger.debug(new StringBuilder(43 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Apply annotation instrumentation: ").append(string).append(" method ").append(string2).append(" ").append(string3).toString());
                instr.onMethodEnter();
            }
        }

        protected void onMethodExit(int opcode) {
            super.onMethodExit(opcode);
            for (AnnotatedMethodAdapter instr : this.mAnnotationInstr) {
                instr.onMethodExit();
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            NetworkObjectInstrumentationFactory factory = this.mInstrumentationConfig.getNetworkObjectInstrumentationFactory(owner, name, desc);
            NetworkObjectInstrumentation networkObjectInstrumentation = null;
            if (factory != null) {
                networkObjectInstrumentation = factory.newObjectInstrumentation(owner, name, desc);
                String string = String.valueOf(networkObjectInstrumentation);
                InstrumentationVisitor.this.mLogger.debug(new StringBuilder(33 + String.valueOf(owner).length() + String.valueOf(name).length() + String.valueOf(desc).length() + String.valueOf(string).length()).append("Instrumenting return obj ").append(owner).append(" ").append(name).append(" ").append(desc).append(" with ").append(string).toString());
            }
            if (networkObjectInstrumentation != null) {
                networkObjectInstrumentation.injectBefore(this.mv);
                if (!networkObjectInstrumentation.replaceMethod(this.mv, opcode)) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
                networkObjectInstrumentation.injectAfter(this.mv);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }
}

