/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin.instrumentation.network;

import com.google.firebase.perf.plugin.instrumentation.network.NetworkObjectInstrumentationFactory;

public abstract class NetworkObjectInstrumentationConfig {
    private final NetworkObjectInstrumentationFactory mFactory;
    private final String mClassName;
    private final String mMethodName;
    private final String mMethodDesc;
    private final String mId;

    public NetworkObjectInstrumentationConfig(NetworkObjectInstrumentationFactory factory, String className, String methodName, String methodDesc) {
        this.mFactory = factory;
        this.mClassName = className;
        this.mMethodName = methodName;
        this.mMethodDesc = methodDesc;
        this.mId = NetworkObjectInstrumentationConfig.getId(className, methodName, methodDesc);
    }

    public NetworkObjectInstrumentationFactory getFactory() {
        return this.mFactory;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getMethodName() {
        return this.mMethodName;
    }

    public String getMethodDesc() {
        return this.mMethodDesc;
    }

    public boolean equals(Object obj) {
        NetworkObjectInstrumentationConfig o = (NetworkObjectInstrumentationConfig)obj;
        return o.mId.equals(this.mId);
    }

    public int hashCode() {
        return this.mId.hashCode();
    }

    public static String getId(String className, String methodName, String methodDesc) {
        return new StringBuilder(String.valueOf(className).length() + String.valueOf(methodName).length() + String.valueOf(methodDesc).length()).append(className).append(methodName).append(methodDesc).toString();
    }
}

