/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin;

import android.support.annotation.NonNull;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.api.variant.VariantInfo;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.firebase.perf.plugin.FirebasePerfPlugin;
import com.google.firebase.perf.plugin.InstrumentationFlagState;
import com.google.firebase.perf.plugin.instrumentation.Instrument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.provider.Provider;
import org.slf4j.Logger;

public class FirebasePerfTransform
extends Transform {
    private static final Logger logger = FirebasePerfPlugin.getLogger();
    private final Set<QualifiedContent.ContentType> typeClasses;
    private final Set<QualifiedContent.Scope> scopes;
    private Instrument firebasePerfInstrumentation;
    private boolean applyToVariantUsed = false;
    private final InstrumentationFlagState instrumentationFlagState;
    private final Provider<List<File>> bootClasspathProvider;

    public FirebasePerfTransform(InstrumentationFlagState instrumentationFlagState, Provider<List<File>> bootClasspathProvider) {
        this.instrumentationFlagState = instrumentationFlagState;
        this.bootClasspathProvider = bootClasspathProvider;
        this.typeClasses = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
        this.scopes = ImmutableSet.of((Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Object)QualifiedContent.Scope.PROJECT, (Object)QualifiedContent.Scope.SUB_PROJECTS);
    }

    @NonNull
    public String getName() {
        return "FirebasePerformancePlugin";
    }

    @NonNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.typeClasses;
    }

    @NonNull
    public Set<QualifiedContent.Scope> getScopes() {
        return this.scopes;
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean applyToVariant(VariantInfo variant) {
        this.applyToVariantUsed = true;
        boolean enabled = this.instrumentationFlagState.isEnabledFor(variant.getFullVariantName(), variant.getBuildTypeName(), (List<String>)variant.getFlavorNames());
        logger.info(String.format("applyToVariant(%s): %s", variant, enabled));
        return enabled;
    }

    @NonNull
    public Map<String, Object> getParameterInputs() {
        return ImmutableMap.copyOf(this.instrumentationFlagState.getVariantToInstrumentationEnabledMap());
    }

    public void transform(TransformInvocation invocation) throws IOException {
        Collection transformInputs = invocation.getInputs();
        Collection referencedInputs = invocation.getReferencedInputs();
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        boolean incremental = invocation.isIncremental();
        String variantName = invocation.getContext().getVariantName();
        boolean instrumentationEnabled = this.applyToVariantUsed || this.instrumentationFlagState.isEnabledFor(variantName);
        logger.info("Executing transform for buildVariant: {}; instrumentationEnabled: {}, applyToVariantUsed: {}", new Object[]{invocation.getContext().getVariantName(), instrumentationEnabled, this.applyToVariantUsed});
        List<URL> runtimeCP = this.buildRuntimeClasspath(transformInputs, referencedInputs);
        logger.debug("Effective app classpath at runtime:");
        for (URL url : runtimeCP) {
            logger.debug("- " + url);
        }
        try (URLClassLoader cl = new URLClassLoader(runtimeCP.toArray(new URL[0]));){
            logger.info("Transforming with incremental: {}", (Object)incremental);
            if (!incremental) {
                outputProvider.deleteAll();
            }
            this.firebasePerfInstrumentation = new Instrument(cl);
            for (TransformInput transformInput : transformInputs) {
                this.transformDirectoryInputs(transformInput, outputProvider, incremental, instrumentationEnabled);
                this.transformJarInputs(transformInput, outputProvider, incremental, instrumentationEnabled);
            }
        }
    }

    private void transformDirectoryInputs(TransformInput transformInput, TransformOutputProvider outputProvider, boolean incremental, boolean instrumentationEnabled) throws IOException {
        for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
            File inputDir = directoryInput.getFile();
            File outputDir = outputProvider.getContentLocation(directoryInput.getName(), directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY);
            logger.debug("transformDirectoryInputs() >> inputDir: '{}', outputDir: '{}'", (Object)inputDir, (Object)outputDir);
            if (instrumentationEnabled) {
                this.performTransformationForDirectoryInput(directoryInput, inputDir, outputDir, incremental);
                continue;
            }
            this.performDummyTransformationForDirectoryInput(inputDir, outputDir);
        }
    }

    private void performTransformationForDirectoryInput(DirectoryInput directoryInput, File inputDir, File outputDir, boolean incremental) throws IOException {
        if (incremental) {
            for (Map.Entry entry : directoryInput.getChangedFiles().entrySet()) {
                File inputFile = (File)entry.getKey();
                Status incrementalStatus = (Status)entry.getValue();
                logger.debug("performTransformationForDirectoryInput() >> inputFile: '{}', incrementalStatus: {}", (Object)inputFile, (Object)incrementalStatus);
                switch (incrementalStatus) {
                    case NOTCHANGED: {
                        break;
                    }
                    case ADDED: 
                    case CHANGED: {
                        this.transformFile(inputFile, inputDir, outputDir);
                        break;
                    }
                    case REMOVED: {
                        File outputFile = FirebasePerfTransform.toOutputFile(outputDir, inputDir, inputFile);
                        com.android.utils.FileUtils.deleteIfExists((File)outputFile);
                    }
                }
            }
        } else {
            for (File inputFile : com.android.utils.FileUtils.getAllFiles((File)inputDir)) {
                this.transformFile(inputFile, inputDir, outputDir);
            }
        }
    }

    private void transformFile(File inputFile, File inputDir, File outputDir) throws IOException {
        if (!inputFile.isDirectory() && inputFile.getName().endsWith(".class")) {
            File outputFile = FirebasePerfTransform.toOutputFile(outputDir, inputDir, inputFile);
            Files.createParentDirs((File)outputFile);
            this.firebasePerfInstrumentation.instrumentClassFile(inputFile, outputFile);
        }
    }

    private void performDummyTransformationForDirectoryInput(File inputDir, File outputDir) throws IOException {
        if (outputDir.mkdirs() || outputDir.isDirectory()) {
            FileUtils.deleteDirectory((File)outputDir);
            com.android.utils.FileUtils.copyDirectory((File)inputDir, (File)outputDir);
        }
    }

    private void transformJarInputs(TransformInput transformInput, TransformOutputProvider outputProvider, boolean incremental, boolean instrumentationEnabled) throws IOException {
        for (JarInput jarInput : transformInput.getJarInputs()) {
            File inputJar = jarInput.getFile();
            File outputJar = outputProvider.getContentLocation(jarInput.getName(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
            logger.debug("transformJarInputs() >> inputJar: '{}', outputJar: '{}'", (Object)inputJar, (Object)outputJar);
            if (instrumentationEnabled) {
                this.performTransformationForJarInput(jarInput, inputJar, outputJar, incremental);
                continue;
            }
            this.performDummyTransformationForJarInput(inputJar, outputJar);
        }
    }

    private void performTransformationForJarInput(JarInput jarInput, File inputJar, File outputJar, boolean incremental) throws IOException {
        if (incremental) {
            Status incrementalStatus = jarInput.getStatus();
            logger.debug("performTransformationForJarInput() >> inputJar: '{}', incrementalStatus: {}", (Object)inputJar, (Object)incrementalStatus);
            switch (incrementalStatus) {
                case NOTCHANGED: {
                    break;
                }
                case ADDED: 
                case CHANGED: {
                    this.transformJar(inputJar, outputJar);
                    break;
                }
                case REMOVED: {
                    com.android.utils.FileUtils.deleteIfExists((File)outputJar);
                }
            }
        } else {
            this.transformJar(inputJar, outputJar);
        }
    }

    private void transformJar(File inputJar, File outputJar) throws IOException {
        Files.createParentDirs((File)outputJar);
        this.firebasePerfInstrumentation.instrumentClassesInJar(inputJar, outputJar);
    }

    private void performDummyTransformationForJarInput(File inputJar, File outputJar) throws IOException {
        Files.createParentDirs((File)outputJar);
        try (FileInputStream fis = new FileInputStream(inputJar);
             FileOutputStream fos = new FileOutputStream(outputJar);){
            IOUtils.copy((InputStream)fis, (OutputStream)fos);
        }
    }

    private static File toOutputFile(File outputDir, File inputDir, File inputFile) {
        return new File(outputDir, com.android.utils.FileUtils.relativePossiblyNonExistingPath((File)inputFile, (File)inputDir));
    }

    private List<URL> buildRuntimeClasspath(Collection<TransformInput> transformInputs, Collection<TransformInput> referencedInputs) {
        ArrayList<File> classPaths = new ArrayList<File>((Collection)this.bootClasspathProvider.get());
        for (Collection transformInputCollection : Arrays.asList(transformInputs, referencedInputs)) {
            for (TransformInput transformInput : transformInputCollection) {
                List<Collection> allQualifiedContents = Arrays.asList(transformInput.getDirectoryInputs(), transformInput.getJarInputs());
                for (Collection qualifiedContentCollection : allQualifiedContents) {
                    for (QualifiedContent qualifiedContent : qualifiedContentCollection) {
                        classPaths.add(qualifiedContent.getFile());
                    }
                }
            }
        }
        return classPaths.stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                logger.error("Unable to instrument classes due to file '{}'", file);
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }
}

