/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.cenc;

import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.boxes.cenc.CencSampleAuxiliaryDataFormat;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonEncryptionSampleList
extends AbstractList<Sample> {
    List<CencSampleAuxiliaryDataFormat> auxiliaryDataFormats;
    SecretKey secretKey;
    List<Sample> parent;
    static Cipher cipher;

    static {
        try {
            cipher = Cipher.getInstance("AES/CTR/NoPadding");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public CommonEncryptionSampleList(SecretKey secretKey, List<Sample> parent, List<CencSampleAuxiliaryDataFormat> auxiliaryDataFormats) {
        this.auxiliaryDataFormats = auxiliaryDataFormats;
        this.secretKey = secretKey;
        this.parent = parent;
    }

    @Override
    public Sample get(int index) {
        Sample clearSample = this.parent.get(index);
        CencSampleAuxiliaryDataFormat entry = this.auxiliaryDataFormats.get(index);
        return new EncryptedSampleImpl(clearSample, entry, cipher);
    }

    protected void initCipher(byte[] iv) {
        try {
            byte[] fullIv = new byte[16];
            System.arraycopy(iv, 0, fullIv, 0, iv.length);
            cipher.init(1, (Key)this.secretKey, new IvParameterSpec(fullIv));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    private class EncryptedSampleImpl
    implements Sample {
        private final Sample clearSample;
        private final CencSampleAuxiliaryDataFormat cencSampleAuxiliaryDataFormat;
        private final Cipher cipher;

        private EncryptedSampleImpl(Sample clearSample, CencSampleAuxiliaryDataFormat cencSampleAuxiliaryDataFormat, Cipher cipher) {
            this.clearSample = clearSample;
            this.cencSampleAuxiliaryDataFormat = cencSampleAuxiliaryDataFormat;
            this.cipher = cipher;
        }

        public void writeTo(WritableByteChannel channel) throws IOException {
            ByteBuffer sample = (ByteBuffer)this.clearSample.asByteBuffer().rewind();
            CommonEncryptionSampleList.this.initCipher(this.cencSampleAuxiliaryDataFormat.iv);
            try {
                if (this.cencSampleAuxiliaryDataFormat.pairs != null && this.cencSampleAuxiliaryDataFormat.pairs.size() > 0) {
                    for (CencSampleAuxiliaryDataFormat.Pair pair : this.cencSampleAuxiliaryDataFormat.pairs) {
                        byte[] clears = new byte[pair.clear];
                        sample.get(clears);
                        channel.write(ByteBuffer.wrap(clears));
                        if (pair.encrypted <= 0L) continue;
                        byte[] toBeEncrypted = new byte[CastUtils.l2i(pair.encrypted)];
                        sample.get(toBeEncrypted);
                        assert (toBeEncrypted.length % 16 == 0);
                        byte[] encrypted = this.cipher.update(toBeEncrypted);
                        assert (encrypted.length == toBeEncrypted.length);
                        channel.write(ByteBuffer.wrap(encrypted));
                    }
                } else {
                    byte[] fullyEncryptedSample = new byte[sample.limit()];
                    sample.get(fullyEncryptedSample);
                    channel.write(ByteBuffer.wrap(this.cipher.doFinal(fullyEncryptedSample)));
                }
                sample.rewind();
            }
            catch (IllegalBlockSizeException e) {
                throw new RuntimeException(e);
            }
            catch (BadPaddingException e) {
                throw new RuntimeException(e);
            }
        }

        public long getSize() {
            return this.clearSample.getSize();
        }

        public ByteBuffer asByteBuffer() {
            ByteBuffer sample = (ByteBuffer)this.clearSample.asByteBuffer().rewind();
            ByteBuffer encSample = ByteBuffer.allocate(sample.limit());
            CencSampleAuxiliaryDataFormat entry = this.cencSampleAuxiliaryDataFormat;
            CommonEncryptionSampleList.this.initCipher(this.cencSampleAuxiliaryDataFormat.iv);
            try {
                if (entry.pairs != null) {
                    for (CencSampleAuxiliaryDataFormat.Pair pair : entry.pairs) {
                        byte[] clears = new byte[pair.clear];
                        sample.get(clears);
                        encSample.put(clears);
                        if (pair.encrypted <= 0L) continue;
                        byte[] toBeEncrypted = new byte[CastUtils.l2i(pair.encrypted)];
                        sample.get(toBeEncrypted);
                        assert (toBeEncrypted.length % 16 == 0);
                        byte[] encrypted = this.cipher.update(toBeEncrypted);
                        assert (encrypted.length == toBeEncrypted.length);
                        encSample.put(encrypted);
                    }
                } else {
                    byte[] fullyEncryptedSample = new byte[sample.limit()];
                    sample.get(fullyEncryptedSample);
                    encSample.put(this.cipher.doFinal(fullyEncryptedSample));
                }
                sample.rewind();
            }
            catch (IllegalBlockSizeException e) {
                throw new RuntimeException(e);
            }
            catch (BadPaddingException e) {
                throw new RuntimeException(e);
            }
            encSample.rewind();
            return encSample;
        }
    }
}

