/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;

final class ProxyFactory {
    ProxyFactory() {
    }

    static <T> T createProxy(Object target, Class<T> targetInterface) {
        return ProxyFactory.newProxyInstance(targetInterface, new ProxyingInvocationHandler(target));
    }

    private static <T> T newProxyInstance(Class<T> targetInterface, InvocationHandler invocationHandler) {
        return (T)Proxy.newProxyInstance(targetInterface.getClassLoader(), new Class[]{targetInterface}, invocationHandler);
    }

    private static final class ProxyingInvocationHandler
    implements InvocationHandler {
        private final Object target;

        private ProxyingInvocationHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            try {
                Method targetMethod = this.target.getClass().getMethod(method.getName(), ProxyingInvocationHandler.convertTypes(method.getParameterTypes(), this.target.getClass().getClassLoader()));
                Object[] targetArgs = ProxyingInvocationHandler.toTargetArgs(args);
                Object result = targetMethod.invoke(this.target, targetArgs);
                if (result == null || ProxyingInvocationHandler.isJdkType(result.getClass())) {
                    return result;
                }
                return ProxyFactory.createProxy(result, method.getReturnType());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke " + method + " on " + this.target + " with args " + Arrays.toString(args), e);
            }
        }

        private static Object[] toTargetArgs(Object[] args) {
            if (args == null || args.length == 0) {
                return args;
            }
            if (args.length == 1 && args[0] instanceof Action) {
                return new Object[]{ProxyingInvocationHandler.adaptActionArg((Action)args[0])};
            }
            if (Arrays.stream(args).allMatch(it -> ProxyingInvocationHandler.isJdkType(it.getClass()))) {
                return args;
            }
            throw new RuntimeException("Unsupported argument types in " + Arrays.toString(args));
        }

        private static Action<Object> adaptActionArg(Action action) {
            return arg -> action.execute(ProxyingInvocationHandler.createLocalProxy(arg));
        }

        private static Object createLocalProxy(Object target) {
            ClassLoader localClassLoader = ProxyFactory.class.getClassLoader();
            return Proxy.newProxyInstance(localClassLoader, ProxyingInvocationHandler.convertTypes(ProxyingInvocationHandler.collectInterfaces(target.getClass()), localClassLoader), (InvocationHandler)new ProxyingInvocationHandler(target));
        }

        public static Class<?>[] collectInterfaces(Class<?> type) {
            LinkedHashSet result = new LinkedHashSet();
            ProxyingInvocationHandler.collectInterfaces(type, result);
            return result.toArray(new Class[0]);
        }

        private static void collectInterfaces(Class<?> type, Set<Class<?>> result) {
            for (Class<?> candidate = type; candidate != null; candidate = candidate.getSuperclass()) {
                for (Class<?> i : candidate.getInterfaces()) {
                    if (!result.add(i)) continue;
                    ProxyingInvocationHandler.collectInterfaces(i, result);
                }
            }
        }

        private static Class<?>[] convertTypes(Class<?>[] parameterTypes, ClassLoader classLoader) {
            if (parameterTypes.length == 0) {
                return parameterTypes;
            }
            return (Class[])Arrays.stream(parameterTypes).map(type -> {
                if (ProxyingInvocationHandler.isJdkType(type)) {
                    return type;
                }
                try {
                    return classLoader.loadClass(type.getName());
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to load class: " + type.getName(), e);
                }
            }).toArray(Class[]::new);
        }

        private static boolean isJdkType(Class<?> type) {
            ClassLoader typeClassLoader = type.getClassLoader();
            return typeClassLoader == null || typeClassLoader.equals(Object.class.getClassLoader());
        }
    }
}

