/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.Utils;
import org.gradle.api.provider.ProviderFactory;

final class CiUtils {
    private CiUtils() {
    }

    static boolean isCi(ProviderFactory providers) {
        return CiUtils.isGenericCI(providers) || CiUtils.isJenkins(providers) || CiUtils.isHudson(providers) || CiUtils.isTeamCity(providers) || CiUtils.isCircleCI(providers) || CiUtils.isBamboo(providers) || CiUtils.isGitHubActions(providers) || CiUtils.isGitLab(providers) || CiUtils.isTravis(providers) || CiUtils.isBitrise(providers) || CiUtils.isGoCD(providers) || CiUtils.isAzurePipelines(providers) || CiUtils.isBuildkite(providers);
    }

    static boolean isGenericCI(ProviderFactory providers) {
        return Utils.envVariable("CI", providers).isPresent() || Utils.sysProperty("CI", providers).isPresent();
    }

    static boolean isJenkins(ProviderFactory providers) {
        return Utils.envVariable("JENKINS_URL", providers).isPresent();
    }

    static boolean isHudson(ProviderFactory providers) {
        return Utils.envVariable("HUDSON_URL", providers).isPresent();
    }

    static boolean isTeamCity(ProviderFactory providers) {
        return Utils.envVariable("TEAMCITY_VERSION", providers).isPresent();
    }

    static boolean isCircleCI(ProviderFactory providers) {
        return Utils.envVariable("CIRCLE_BUILD_URL", providers).isPresent();
    }

    static boolean isBamboo(ProviderFactory providers) {
        return Utils.envVariable("bamboo_resultsUrl", providers).isPresent();
    }

    static boolean isGitHubActions(ProviderFactory providers) {
        return Utils.envVariable("GITHUB_ACTIONS", providers).isPresent();
    }

    static boolean isGitLab(ProviderFactory providers) {
        return Utils.envVariable("GITLAB_CI", providers).isPresent();
    }

    static boolean isTravis(ProviderFactory providers) {
        return Utils.envVariable("TRAVIS_JOB_ID", providers).isPresent();
    }

    static boolean isBitrise(ProviderFactory providers) {
        return Utils.envVariable("BITRISE_BUILD_URL", providers).isPresent();
    }

    static boolean isGoCD(ProviderFactory providers) {
        return Utils.envVariable("GO_SERVER_URL", providers).isPresent();
    }

    static boolean isAzurePipelines(ProviderFactory providers) {
        return Utils.envVariable("TF_BUILD", providers).isPresent();
    }

    static boolean isBuildkite(ProviderFactory providers) {
        return Utils.envVariable("BUILDKITE", providers).isPresent();
    }
}

