/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.gradle.adapters.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);

    private ReflectionUtils() {
    }

    public static Object invokeMethod(Object obj, String method, Object ... args) {
        try {
            Method maybeMethod = ReflectionUtils.findMethod(obj, method, args);
            if (maybeMethod != null) {
                maybeMethod.setAccessible(true);
                return maybeMethod.invoke(obj, args);
            }
            ReflectionUtils.warnAboutUnsupportedMethod(method);
            return null;
        }
        catch (ReflectiveOperationException e) {
            ReflectionUtils.warnAboutUnsupportedMethod(method);
            return null;
        }
    }

    @Nullable
    private static Method findMethod(Object obj, String method, Object[] args) {
        List matchingMethods = Arrays.stream(obj.getClass().getMethods()).filter(it -> it.getName().equals(method)).collect(Collectors.toList());
        if (matchingMethods.isEmpty()) {
            return null;
        }
        if (matchingMethods.size() == 1) {
            return (Method)matchingMethods.get(0);
        }
        for (Method matchingMethod : matchingMethods) {
            if (!ReflectionUtils.hasMatchingParameters(matchingMethod, args)) continue;
            return matchingMethod;
        }
        return null;
    }

    private static boolean hasMatchingParameters(Method matchingMethod, Object[] args) {
        if (matchingMethod.getParameterCount() != args.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            Class<?> type = matchingMethod.getParameterTypes()[i];
            if (type.isAssignableFrom(arg.getClass())) continue;
            return false;
        }
        return true;
    }

    public static boolean isMethodSupported(Object obj, String method) {
        return Arrays.stream(obj.getClass().getMethods()).anyMatch(it -> it.getName().equals(method));
    }

    public static void warnAboutUnsupportedMethod(String method) {
        LOGGER.warn("The '{}' method is not supported by this version of the Develocity extension", (Object)method);
    }
}

